/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.StatusDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnBackupUser;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnLoadUser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WarnOutOfSync
extends OutOfSyncDilemmaHandler {
    private final WarnLoadUser warnLoadUser;
    private final BackupDilemmaHandler backupHandler;
    private final Shell shell;
    private final String dialogTitle;
    private boolean outOfSyncSharesDetected;

    public WarnOutOfSync(Shell shell, String title) {
        this(shell, title, new WarnBackupUser(shell, title));
    }

    public WarnOutOfSync(Shell shell, String title, BackupDilemmaHandler warnBackupUser) {
        this.shell = shell;
        this.dialogTitle = title;
        this.backupHandler = warnBackupUser;
        this.warnLoadUser = new WarnLoadUser(shell, title, this.backupHandler);
        this.outOfSyncSharesDetected = false;
    }

    public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
        return this.warnLoadUser.collision(collisions, removedShares, sharesOutOfSync);
    }

    public int outOfSync(final Collection<IShareOutOfSync> sharesOutOfSync) {
        if (sharesOutOfSync.isEmpty()) {
            return 0;
        }
        this.outOfSyncSharesDetected = true;
        final int[] result = new int[]{1};
        IShare[] shares = new IShare[sharesOutOfSync.size()];
        int i = 0;
        for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
            shares[i] = shareOutOfSync.getShare();
            ++i;
        }
        ILocalChange[] changes = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges(shares);
        final String direction = changes.length > 0 ? Messages.WarnOutOfSync_0 : Messages.WarnOutOfSync_1;
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IStatus[] statuses = new IStatus[sharesOutOfSync.size()];
                    int i = 0;
                    for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                        statuses[i] = FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)Messages.WarnOutOfSync_2, (Object)shareOutOfSync.getShare().getPath()));
                        ++i;
                    }
                    Arrays.sort(statuses, new Comparator<IStatus>(){

                        @Override
                        public int compare(IStatus o1, IStatus o2) {
                            String msg1 = o1.getMessage();
                            String msg2 = o2.getMessage();
                            return msg1.compareToIgnoreCase(msg2);
                        }
                    });
                    Object status = statuses.length > 1 ? new MultiStatus("com.ibm.team.filesystem.client", 4, statuses, NLS.bind((String)Messages.WarnOutOfSync_3, (Object)statuses.length), null) : statuses[0];
                    StatusDialog dialog = new StatusDialog(DialogUtil.checkShell(WarnOutOfSync.this.shell), WarnOutOfSync.this.dialogTitle, direction, "", (IStatus)status, 7);
                    if (dialog.open() == 0) {
                        result[0] = 100;
                    }
                }
            });
        }
        return result[0];
    }

    public boolean willIgnoreAllSharesOutOfSync() {
        return false;
    }

    public boolean isPreserveLocalChangesOnLoadOutOfSync() {
        return true;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.backupHandler;
    }

    public boolean wasOutOfSync() {
        return this.outOfSyncSharesDetected;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        return this.warnLoadUser.deletedContent(contentDeleted);
    }
}

