/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.LineDelimiterListSelectionDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WarnChangeFileProperties
extends ChangePropertiesDilemmaHandler {
    protected final Shell shell;
    private WarnOutOfSync warnOutOfSync;
    private String title;

    public WarnChangeFileProperties(Shell shell, String title) {
        this.shell = shell;
        this.warnOutOfSync = new WarnOutOfSync(shell, title);
        this.title = title;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.warnOutOfSync.getBackupDilemmaHandler();
    }

    public int invalidContentTypes(List<? extends IChangePropertiesRequest> invalidContentTypeChangeRequests, IProgressMonitor monitor) throws FileSystemException {
        return 0;
    }

    public int inconsistentLineDelimiters(final List<? extends IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) {
        final int[] result = new int[]{1};
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IChangePropertiesRequest[] requests = inconsistentDelimiters.toArray(new IChangePropertiesRequest[inconsistentDelimiters.size()]);
                String msg = Messages.WarnChangeFileProperties_0;
                LineDelimiterListSelectionDialog dialog = new LineDelimiterListSelectionDialog(DialogUtil.checkShell(WarnChangeFileProperties.this.shell), requests, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new ConvertRequestLabelProvider(), msg);
                dialog.setTitle(WarnChangeFileProperties.this.title);
                if (dialog.open() == 0) {
                    Object[] convert = dialog.getResult();
                    int i = 0;
                    while (i < convert.length) {
                        IChangePropertiesRequest request = (IChangePropertiesRequest)convert[i];
                        request.setForceLineDelimiterConversion(true);
                        ++i;
                    }
                    result[0] = 0;
                }
            }
        });
        return result[0];
    }

    private class ConvertRequestLabelProvider
    extends BaseLabelProvider {
        private ConvertRequestLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IChangePropertiesRequest) {
                IChangePropertiesRequest request = (IChangePropertiesRequest)element;
                label.setText(request.getShareableToChange().getLocalPath().toString());
                ImageDescriptor desc = this.getImageDescriptor(request);
                label.setImage(desc == null ? null : this.getResources().createImageWithDefault(desc));
            }
        }

        private ImageDescriptor getImageDescriptor(IChangePropertiesRequest request) {
            IWorkbenchAdapter wbAdapter;
            IResource resource = (IResource)request.getShareableToChange().getAdapter(IResource.class);
            if (resource != null && (wbAdapter = (IWorkbenchAdapter)resource.getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbAdapter.getImageDescriptor((Object)resource);
            }
            return null;
        }
    }
}

