/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.util.AutoResolveMergerSelectionDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnApplyAcceptedUser;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnResolveAsMergedUser;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class StandardAutoResolveDilemmaHandler
extends AutoResolveConflictsDilemmaHandler {
    private UIContext context;
    private OutOfSyncDilemmaHandler outOfSyncProblemHandler;
    private ApplyAcceptedDilemmaHandler applyAcceptedProblemHandler;
    private MarkAsMergedDilemmaHandler markAsMergedProblemHandler;

    public StandardAutoResolveDilemmaHandler(UIContext context, boolean verifyOutOfSync) {
        this.context = context;
        this.outOfSyncProblemHandler = verifyOutOfSync ? new WarnOutOfSync(context.getShell(), Messages.StandardAutoResolveDilemmaHandler_0) : new WarnOutOfSync(context.getShell(), Messages.StandardAutoResolveDilemmaHandler_1){

            @Override
            public boolean willIgnoreAllSharesOutOfSync() {
                return true;
            }
        };
        this.applyAcceptedProblemHandler = new WarnApplyAcceptedUser(context.getShell(), Messages.StandardAutoResolveDilemmaHandler_2);
        this.markAsMergedProblemHandler = new WarnResolveAsMergedUser(context.getShell(), Messages.StandardAutoResolveDilemmaHandler_3);
    }

    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return this.outOfSyncProblemHandler;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.outOfSyncProblemHandler.getBackupDilemmaHandler();
    }

    public ApplyAcceptedDilemmaHandler getApplyAcceptedDilemmaHandler() {
        return this.applyAcceptedProblemHandler;
    }

    public int missingStorageMerger(final Collection<IFailedAutoResolveRequest> unknownTypes, Collection<IFailedAutoResolveRequest> itemsWithNoHandlers, IProgressMonitor monitor) throws FileSystemException {
        if (unknownTypes.size() == 0) {
            return 0;
        }
        final int[] result = new int[1];
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AutoResolveMergerSelectionDialog dialog = new AutoResolveMergerSelectionDialog(StandardAutoResolveDilemmaHandler.this.context.getShell(), unknownTypes);
                dialog.open();
                result[0] = dialog.getReturnCode();
            }
        });
        if (result[0] == 1) {
            return 1;
        }
        return 0;
    }

    public ChangePropertiesDilemmaHandler getChangePropertiesDilemmaHandler() {
        ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler = new ChangePropertiesDilemmaHandler(){

            public int inconsistentLineDelimiters(List<? extends IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) {
                return 0;
            }
        };
        return changePropertiesDilemmaHandler;
    }

    public MarkAsMergedDilemmaHandler getMarkAsMergedDilemmaHandler() {
        return this.markAsMergedProblemHandler;
    }
}

