/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.common.internal.IFileItemProperties;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.properties.PropertyNamespaceManager;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class SCMPropertiesUtil {
    public static String getShortValue(String value, int maxlength) {
        if (value.length() > maxlength) {
            return NLS.bind((String)Messages.SCMPropertiesUtil_0, (Object)SCMPropertiesUtil.flattenLineEndings(value.substring(0, maxlength)));
        }
        return SCMPropertiesUtil.flattenLineEndings(value);
    }

    private static String flattenLineEndings(String string) {
        string = string.replace("\r\n", " ");
        string = string.replace("\n", " ");
        string = string.replace("\r", " ");
        return string;
    }

    public static void populatePropertiesBG(Map<String, Map<String, String>> allDisplayValues, ITeamRepository repo, IProgressMonitor monitor) {
        PropertyNamespaceManager namespaceManager = PropertyNamespaceManager.getInstance();
        int mapSize = 0;
        for (Map.Entry<String, Map<String, String>> entry : allDisplayValues.entrySet()) {
            Map<String, String> map = entry.getValue();
            mapSize += map.size();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)mapSize);
        for (Map.Entry<String, Map<String, String>> entry : allDisplayValues.entrySet()) {
            String propertyName = entry.getKey();
            Map<String, String> map = entry.getValue();
            if (propertyName.startsWith("scm") && !IFileItemProperties.definedUserProperties.contains(propertyName) || !namespaceManager.hasDisplayValue(propertyName)) continue;
            for (Map.Entry<String, String> mapEntry : map.entrySet()) {
                String rawValue;
                String key = mapEntry.getKey();
                String displayValue = rawValue = mapEntry.getValue();
                try {
                    displayValue = namespaceManager.getDisplayValue(propertyName, rawValue, repo, (IProgressMonitor)progress.newChild(1));
                }
                catch (Exception e) {
                    displayValue = rawValue;
                }
                map.put(key, displayValue);
            }
        }
    }
}

