/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.util.IConflictDialogFactory;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class DialogUtil {
    public static IConflictDialogFactory conflictDialogFactory = new IConflictDialogFactory(){

        @Override
        public ListDialog createConflictDialog(Shell shell, Collection<ILogicalChange> conflictItems, String title, String message) {
            ListDialog dialog = new ListDialog(shell);
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setLabelProvider((ILabelProvider)new LogicalChangeLabelProvider());
            dialog.setInput(conflictItems);
            dialog.setBlockOnOpen(true);
            dialog.setMessage(message);
            dialog.setTitle(title);
            return dialog;
        }
    };

    public static Shell checkShell(Shell shell) {
        if (shell != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    public static ListDialog createConflictDialog(Shell shell, Collection<ILogicalChange> conflictItems, String title, String message) {
        return conflictDialogFactory.createConflictDialog(shell, conflictItems, title, message);
    }

    public static Button createPushButton(WidgetFactoryContext context, Composite parent, String text, SelectionListener listener) {
        WidgetToolkit toolkit = context.getToolkit();
        Button button = toolkit.createButton(parent, text, 8);
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }

    public static void setAccessibleDescription(final Button button) {
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = button.getText();
            }
        });
    }

    public static void setAccessibleDescription(final Button button, final String supplementalDescription) {
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)Messages.DialogUtil_ACCESSIBLE_BUTTON_DESCRIPTION, (Object)button.getText(), (Object)supplementalDescription);
            }
        });
    }

    private static class LogicalChangeLabelProvider
    extends LabelProvider {
        private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources((Display)Display.getDefault()));

        public void dispose() {
            super.dispose();
            this.resources.dispose();
        }

        public String getText(Object element) {
            if (element instanceof ILogicalChange) {
                ILogicalChange change = (ILogicalChange)element;
                String[] path = change.getPathHint();
                if (path.length > 0) {
                    return path[path.length - 1];
                }
                return ILogicalChange.UNKNOWN_PATH;
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof ILogicalChange) {
                ILogicalChange change = (ILogicalChange)element;
                String simpleName = null;
                if (change.item() instanceof IFolderHandle) {
                    String[] path = change.getPathHint();
                    simpleName = path.length > 0 ? path[path.length - 1] : IChangeSummary.UNKNOWN_PATH;
                }
                ImageDescriptor desc = this.getFileSystemImageDescriptor(simpleName);
                return this.resources.createImage(desc);
            }
            return super.getImage(element);
        }

        public ImageDescriptor getFileSystemImageDescriptor(String filename) {
            if (filename == null) {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(filename);
        }
    }
}

