/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class CollisionListSelectionDialog
extends ListSelectionDialog {
    private static final int SELECT_OUT_OF_SYNC_ID = 1025;
    private static final String DIALOG_SETTINGS_SECTION = "CollisionListSelectionDialogSettings";
    private final boolean createOutOfSyncButton;
    private final String helpContextId;

    public CollisionListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message, boolean createOutOfSyncButton, String helpContextId) {
        super(parentShell, input, contentProvider, labelProvider, message);
        this.helpContextId = helpContextId;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.createOutOfSyncButton = createOutOfSyncButton;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.createOutOfSyncButton) {
            Button selectAllButton = this.getButton(18);
            Composite buttonComposite = selectAllButton.getParent();
            Button selectOutOfSyncButton = this.createButton(buttonComposite, 1025, Messages.CollisionListSelectionDialog_0, false);
            selectOutOfSyncButton.moveBelow((Control)selectAllButton);
            if (this.getInitialElementSelections().isEmpty()) {
                selectOutOfSyncButton.setEnabled(false);
            }
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!CollisionListSelectionDialog.this.getInitialElementSelections().isEmpty()) {
                        CheckboxTableViewer viewer = CollisionListSelectionDialog.this.getViewer();
                        for (Object itemToSelect : CollisionListSelectionDialog.this.getInitialElementSelections()) {
                            viewer.setChecked(itemToSelect, true);
                        }
                    }
                }
            };
            selectOutOfSyncButton.addSelectionListener((SelectionListener)listener);
        }
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.helpContextId);
        }
        return composite;
    }

    protected Label createMessageArea(Composite composite) {
        Label superLabel = super.createMessageArea(composite);
        String message = superLabel.getText();
        superLabel.dispose();
        Label realLabel = new Label(composite, 64);
        realLabel.setText(message);
        GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo((Control)realLabel);
        return realLabel;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = RcpUiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }
}

