/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreference;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreferenceManager;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.properties.ChangeFilePropertiesUtil;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.mapping.IStorageMerger;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class AutoResolveMergerSelectionDialog
extends TitleAreaDialog {
    private static final String EMPTY = "";
    private Map<String, Set<IFailedAutoResolveRequest>> extensionMap = new HashMap<String, Set<IFailedAutoResolveRequest>>();
    private Set<IFailedAutoResolveRequest> noExtension = new HashSet<IFailedAutoResolveRequest>();
    private Map<String, Integer> extensionSelection = new HashMap<String, Integer>();
    private Map<IFailedAutoResolveRequest, Integer> requestSelection = new HashMap<IFailedAutoResolveRequest, Integer>();
    private List<IContentType> mergers;
    private CheckboxTreeViewer viewer;

    public AutoResolveMergerSelectionDialog(Shell parentShell, Collection<IFailedAutoResolveRequest> requests) {
        super(parentShell);
        this.setShellStyle(0x10C70 | AutoResolveMergerSelectionDialog.getDefaultOrientation());
        for (IFailedAutoResolveRequest request : requests) {
            String extension = AutoResolveMergerSelectionDialog.getFileExtension(request);
            if (extension == null) {
                this.noExtension.add(request);
            } else {
                this.extensionSelection.put(extension, 0);
                Set<IFailedAutoResolveRequest> set = this.extensionMap.get(extension);
                if (set == null) {
                    set = new HashSet<IFailedAutoResolveRequest>();
                    this.extensionMap.put(extension, set);
                }
                set.add(request);
            }
            this.requestSelection.put(request, 0);
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.AutoResolveMergerSelectionDialog_2);
        super.configureShell(newShell);
    }

    private static String getFileExtension(IFailedAutoResolveRequest request) {
        return ResourceUtil.getFileExtension((String)request.getConflictPath().getName());
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AutoResolveMergerSelectionDialog_3);
        this.setMessage(Messages.AutoResolveMergerSelectionDialog_4);
        Composite createDialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(createDialogArea, 0);
        Link link = ChangeFilePropertiesUtil.createLinkToFilePropertiesPreferencePage(composite, this.getShell());
        Label help = new Label(composite, 64);
        help.setText(Messages.AutoResolveMergerSelectionDialog_5);
        Composite treeAndButtonsComposite = new Composite(composite, 0);
        Composite treeComposite = new Composite(treeAndButtonsComposite, 0);
        this.viewer = new CheckboxTreeViewer(treeComposite, 68352);
        final Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(tree, 0);
        column1.setText(Messages.AutoResolveMergerSelectionDialog_6);
        column1.setWidth(150);
        TreeColumn column2 = new TreeColumn(tree, 0);
        column2.setText(Messages.AutoResolveMergerSelectionDialog_7);
        column2.setWidth(150);
        column2.setToolTipText(Messages.AutoResolveMergerSelectionDialog_1);
        IContentType[] contentTypes = Platform.getContentTypeManager().getAllContentTypes();
        this.mergers = new ArrayList<IContentType>();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            IStorageMerger storageMerger = Team.createMerger((IContentType)contentType);
            if (storageMerger != null) {
                this.mergers.add(contentType);
            }
            ++n2;
        }
        final Combo combo = new Combo((Composite)tree, 2060);
        combo.setToolTipText(Messages.AutoResolveMergerSelectionDialog_1);
        combo.setBackground(tree.getBackground());
        combo.add(Messages.AutoResolveMergerSelectionDialog_8);
        Collections.sort(this.mergers, new Comparator<IContentType>(){

            @Override
            public int compare(IContentType o1, IContentType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (IContentType merger : this.mergers) {
            combo.add(merger.getName());
        }
        final TreeEditor editor = new TreeEditor(tree);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.horizontalAlignment = 16384;
        editor.setEditor((Control)combo, null, 1);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = editor.getItem();
                Object data = item.getData();
                int selection = combo.getSelectionIndex();
                if (data instanceof String) {
                    String extension = (String)data;
                    AutoResolveMergerSelectionDialog.this.extensionSelection.put(extension, selection);
                    Set set = (Set)AutoResolveMergerSelectionDialog.this.extensionMap.get(extension);
                    for (IFailedAutoResolveRequest request : set) {
                        AutoResolveMergerSelectionDialog.this.requestSelection.put(request, selection);
                    }
                    AutoResolveMergerSelectionDialog.this.viewer.update(set.toArray(), null);
                    AutoResolveMergerSelectionDialog.this.viewer.update((Object)extension, null);
                } else if (data instanceof IFailedAutoResolveRequest) {
                    IFailedAutoResolveRequest request = (IFailedAutoResolveRequest)data;
                    String extension = AutoResolveMergerSelectionDialog.getFileExtension(request);
                    AutoResolveMergerSelectionDialog.this.requestSelection.put(request, selection);
                    if (extension != null) {
                        boolean allSame = true;
                        Set set = (Set)AutoResolveMergerSelectionDialog.this.extensionMap.get(extension);
                        for (IFailedAutoResolveRequest r : set) {
                            if (((Integer)AutoResolveMergerSelectionDialog.this.requestSelection.get(r)).equals(selection)) continue;
                            allSame = false;
                            break;
                        }
                        if (allSame) {
                            AutoResolveMergerSelectionDialog.this.extensionSelection.put(extension, selection);
                        } else {
                            AutoResolveMergerSelectionDialog.this.extensionSelection.put(extension, null);
                        }
                        AutoResolveMergerSelectionDialog.this.viewer.update((Object)extension, null);
                    }
                    AutoResolveMergerSelectionDialog.this.viewer.update((Object)request, null);
                }
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Integer selection = null;
                if (tree.getSelectionCount() == 0) {
                    combo.setVisible(false);
                    editor.setItem(null);
                } else {
                    TreeItem item = tree.getSelection()[0];
                    combo.setVisible(true);
                    editor.setItem(item);
                    Object data = item.getData();
                    if (data instanceof IFailedAutoResolveRequest) {
                        IFailedAutoResolveRequest request = (IFailedAutoResolveRequest)data;
                        selection = (Integer)AutoResolveMergerSelectionDialog.this.requestSelection.get(request);
                    } else if (data instanceof String) {
                        String extension = (String)data;
                        selection = (Integer)AutoResolveMergerSelectionDialog.this.extensionSelection.get(extension);
                    }
                }
                if (selection != null) {
                    combo.select(selection.intValue());
                } else {
                    combo.select(-1);
                    combo.setText(AutoResolveMergerSelectionDialog.EMPTY);
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement == tree) {
                    ArrayList<String> children = new ArrayList<String>();
                    for (String extension : AutoResolveMergerSelectionDialog.this.extensionMap.keySet()) {
                        children.add(extension);
                    }
                    children.addAll(AutoResolveMergerSelectionDialog.this.noExtension);
                    return children.toArray();
                }
                if (parentElement instanceof String) {
                    String extension = (String)parentElement;
                    return ((Set)AutoResolveMergerSelectionDialog.this.extensionMap.get(extension)).toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element == tree) {
                    return true;
                }
                return element instanceof String;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof String) {
                    String extension = (String)element;
                    switch (columnIndex) {
                        case 0: {
                            return extension;
                        }
                        case 1: {
                            Integer selection = (Integer)AutoResolveMergerSelectionDialog.this.extensionSelection.get(element);
                            if (selection == null) {
                                return AutoResolveMergerSelectionDialog.EMPTY;
                            }
                            if (selection == 0) {
                                return Messages.AutoResolveMergerSelectionDialog_9;
                            }
                            return AutoResolveMergerSelectionDialog.this.getMerger(selection).getName();
                        }
                    }
                    return AutoResolveMergerSelectionDialog.EMPTY;
                }
                if (element instanceof IFailedAutoResolveRequest) {
                    IFailedAutoResolveRequest request = (IFailedAutoResolveRequest)element;
                    switch (columnIndex) {
                        case 0: {
                            String portableString = request.getConflictPath().toString();
                            if (portableString.charAt(0) == '/') {
                                portableString = portableString.substring(1);
                            }
                            return portableString;
                        }
                        case 1: {
                            Integer selection = (Integer)AutoResolveMergerSelectionDialog.this.requestSelection.get(element);
                            if (selection == 0) {
                                return Messages.AutoResolveMergerSelectionDialog_10;
                            }
                            return AutoResolveMergerSelectionDialog.this.getMerger(selection).getName();
                        }
                    }
                    return AutoResolveMergerSelectionDialog.EMPTY;
                }
                return AutoResolveMergerSelectionDialog.EMPTY;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof String) {
                    return 0;
                }
                return 1;
            }
        });
        this.viewer.setInput((Object)tree);
        this.viewer.expandAll();
        this.viewer.collapseAll();
        Composite buttonsComposite = new Composite(treeAndButtonsComposite, 0);
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(Messages.AutoResolveMergerSelectionDialog_11);
        selectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AutoResolveMergerSelectionDialog.this.viewer.setAllChecked(true);
            }
        });
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(Messages.AutoResolveMergerSelectionDialog_12);
        deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AutoResolveMergerSelectionDialog.this.viewer.setAllChecked(false);
            }
        });
        Label spacer = new Label(composite, 64);
        spacer.setText(Messages.AutoResolveMergerSelectionDialog_0);
        Dialog.applyDialogFont((Control)parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)link);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)spacer);
        GridLayoutFactory.fillDefaults().generateLayout(treeComposite);
        GridLayoutFactory.fillDefaults().generateLayout(buttonsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(treeAndButtonsComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeAndButtonsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.dialog_automergertext");
        return createDialogArea;
    }

    protected void okPressed() {
        try {
            this.savePref((IProgressMonitor)TempHelper.MONITOR);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.AutoResolveMergerSelectionDialog_13, (String)Messages.AutoResolveMergerSelectionDialog_14, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        catch (BackingStoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.AutoResolveMergerSelectionDialog_15, (String)Messages.AutoResolveMergerSelectionDialog_16, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        catch (FileSystemException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.AutoResolveMergerSelectionDialog_13, (String)Messages.AutoResolveMergerSelectionDialog_14, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        for (Set<IFailedAutoResolveRequest> set : this.extensionMap.values()) {
            for (IFailedAutoResolveRequest request : set) {
                this.setMerger(request);
            }
        }
        for (IFailedAutoResolveRequest request : this.noExtension) {
            this.setMerger(request);
        }
        super.okPressed();
    }

    private void savePref(IProgressMonitor monitor) throws CoreException, BackingStoreException, FileSystemException {
        Object[] items = this.viewer.getCheckedElements();
        ContentPropertiesPreferenceManager manager = new ContentPropertiesPreferenceManager();
        HashSet<String> extensionsToSave = new HashSet<String>();
        HashSet<IFailedAutoResolveRequest> requestsToSave = new HashSet<IFailedAutoResolveRequest>();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof String) {
                extensionsToSave.add((String)item);
            } else if (item instanceof IFailedAutoResolveRequest) {
                requestsToSave.add((IFailedAutoResolveRequest)item);
            }
            ++n2;
        }
        for (String extension : extensionsToSave) {
            Integer extSelection = this.extensionSelection.get(extension);
            for (IFailedAutoResolveRequest request : this.extensionMap.get(extension)) {
                if (!requestsToSave.contains(request) || !this.requestSelection.get(request).equals(extSelection)) continue;
                requestsToSave.remove(request);
            }
        }
        for (String extension : extensionsToSave) {
            Integer selection = this.extensionSelection.get(extension);
            String prefKey = extension;
            String contentTypeSpec = extension.substring(2);
            Set<IFailedAutoResolveRequest> set = this.extensionMap.get(extension);
            IFailedAutoResolveRequest first = set.iterator().next();
            IShareable shareable = first.getConflictedShareable();
            if (shareable == null) continue;
            FileLineDelimiter lineDelimiter = shareable.getLineDelimiter(monitor);
            String mimeType = shareable.getContentType(monitor);
            if (lineDelimiter == null) {
                lineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
            }
            if (mimeType == null) {
                mimeType = "application/unknown";
            }
            for (IFailedAutoResolveRequest request : set) {
                shareable = request.getConflictedShareable();
                if (!lineDelimiter.equals((Object)shareable.getLineDelimiter(monitor))) {
                    lineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                }
                if (mimeType.equals(shareable.getContentType(monitor))) continue;
                mimeType = "application/unknown";
            }
            this.savePref(manager, selection, prefKey, lineDelimiter, mimeType, 8, contentTypeSpec);
        }
        for (IFailedAutoResolveRequest request : requestsToSave) {
            Integer selection = this.requestSelection.get(request);
            IShareable shareable = request.getConflictedShareable();
            if (shareable == null) continue;
            String key = shareable.getLocalPath().getName();
            FileLineDelimiter lineDelimiter = shareable.getLineDelimiter(monitor);
            String mimeType = shareable.getContentType(monitor);
            if (lineDelimiter == null) {
                lineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
            }
            if (mimeType == null) {
                mimeType = "application/unknown";
            }
            this.savePref(manager, selection, key, lineDelimiter, mimeType, 4, key);
        }
        manager.flush();
    }

    private void setMerger(IFailedAutoResolveRequest request) {
        Integer selection = this.requestSelection.get(request);
        if (selection != 0) {
            request.setRetryMerge(true);
            request.defaultContentTypeMerger(this.getMerger(selection).getId());
        }
    }

    private void savePref(ContentPropertiesPreferenceManager manager, Integer selection, String prefKey, FileLineDelimiter lineDelimiter, String mimeType, int type, String contentTypeSpec) throws CoreException {
        if (selection != null) {
            IContentType contentType = null;
            if (selection > 1 && (contentType = this.getMerger(selection)) != null) {
                contentType.addFileSpec(contentTypeSpec, type);
            }
            ContentPropertiesPreference pref = manager.get(contentType, prefKey);
            pref.setLineDelimiter(lineDelimiter);
            pref.setMimeType(mimeType);
        }
    }

    private IContentType getMerger(int selection) {
        return this.mergers.get(selection - 1);
    }
}

