/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.properties;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.properties.SCMPropertyEntry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SCMPropertyDialog
extends TitleAreaDialog {
    private final String title;
    private String description;
    private String name;
    private boolean canChangeName;
    private String value;
    private final String helpContextId;
    private IChangePropertiesOperation changePropertiesOp = IOperationFactory.instance.getChangePropertiesOperation(new ChangePropertiesDilemmaHandler());

    public SCMPropertyDialog(Shell parentShell, String name, String value, String title) {
        this(parentShell, name, value, title, Messages.SCMPropertyDialog_2, true);
    }

    public SCMPropertyDialog(Shell parentShell, String name, String value, String title, String description, boolean canChangeName) {
        this(parentShell, name, value, title, description, canChangeName, null);
    }

    public SCMPropertyDialog(Shell parentShell, String name, String value, String title, String description, boolean canChangeName, String helpContextId) {
        super(parentShell);
        this.name = name;
        this.value = value;
        this.title = title;
        this.description = description;
        this.canChangeName = canChangeName;
        this.helpContextId = helpContextId;
        this.setHelpAvailable(this.helpContextId != null);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public SCMPropertyEntry getPropertyEntry() {
        return new SCMPropertyEntry(this.name, this.value);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(c, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label l1 = new Label(composite, 0);
        l1.setText(Messages.SCMPropertyDialog_0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)l1);
        int style = 2052;
        final Text nameText = new Text(composite, style);
        nameText.setText(this.name);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameText);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SCMPropertyDialog.this.handleNameModification(nameText.getText());
            }
        });
        nameText.setEnabled(this.canChangeName);
        Label l2 = new Label(composite, 0);
        l2.setText(Messages.SCMPropertyDialog_1);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)l2);
        final StyledText valueText = new StyledText(composite, 2818);
        valueText.setText(this.value);
        valueText.setIndent(2);
        GridDataFactory.fillDefaults().grab(true, true).hint(200, 100).applyTo((Control)valueText);
        valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SCMPropertyDialog.this.handleValueModification(valueText.getText());
            }
        });
        if (this.name.length() > 0) {
            valueText.setFocus();
        }
        Dialog.applyDialogFont((Control)composite);
        return c;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, this.helpContextId);
        }
        this.setTitle(this.title);
        this.setMessage(this.description);
        this.updateEnablement();
        return control;
    }

    protected void handleValueModification(String newValue) {
        this.value = newValue;
        this.updateEnablement();
    }

    protected void updateEnablement() {
        IStatus status = this.changePropertiesOp.validateProperty(this.name, this.value);
        this.getButton(0).setEnabled(status.isOK());
        if (status.isOK() || this.name.length() == 0) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(status.getMessage());
        }
    }

    protected void handleNameModification(String newName) {
        this.name = newName;
        this.updateEnablement();
    }
}

