/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.properties;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.rcp.ui.IPropertyEntry;
import com.ibm.team.filesystem.rcp.ui.PropertyNamespaceProvider;
import com.ibm.team.filesystem.rcp.ui.internal.properties.PropertyNamespace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.swt.widgets.Shell;

public class PropertyNamespaceManager {
    private static PropertyNamespaceManager instance;
    private Map<String, PropertyNamespace> namespaces;
    private PropertyNamespace defaultNamespace = new PropertyNamespace(new PropertyNamespaceProvider(){

        @Override
        public String getName() {
            return "default";
        }
    }, "");

    public static synchronized PropertyNamespaceManager getInstance() {
        if (instance == null) {
            instance = new PropertyNamespaceManager();
            instance.loadNamespaces();
        }
        return instance;
    }

    public void loadNamespaces() {
        IConfigurationElement[] configs;
        if (this.namespaces != null) {
            return;
        }
        this.namespaces = new HashMap<String, PropertyNamespace>();
        IConfigurationElement[] iConfigurationElementArray = configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.rcp.ui", "propertyNamespace");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            PropertyNamespace namespace = this.createFor(config);
            if (namespace != null) {
                this.namespaces.put(namespace.getPrefix(), namespace);
            }
            ++n2;
        }
    }

    private PropertyNamespace createFor(IConfigurationElement config) {
        return this.extractNamespace(config);
    }

    private PropertyNamespace extractNamespace(IConfigurationElement config) {
        try {
            Object extension = config.createExecutableExtension("provider");
            if (extension instanceof PropertyNamespaceProvider) {
                String prefix = config.getAttribute("prefix");
                return new PropertyNamespace((PropertyNamespaceProvider)extension, prefix);
            }
        }
        catch (CoreException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
        return null;
    }

    public String getDisplayLabel(String name) {
        PropertyNamespace namespace = this.getNamespace(name);
        return namespace.getDisplayLabel(name);
    }

    private PropertyNamespace getNamespace(String name) {
        for (Map.Entry<String, PropertyNamespace> entry : this.namespaces.entrySet()) {
            if (!name.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.defaultNamespace;
    }

    public IPropertyEntry editProperty(Shell shell, IShareable shareable, IPropertyEntry entry) {
        PropertyNamespace namespace = this.getNamespace(entry.getName());
        return namespace.editProperty(shell, shareable, entry);
    }

    public String[] getClientPageIds() {
        ArrayList<String> pages = new ArrayList<String>();
        pages.add("com.ibm.team.filesystem.ui.versionablePropertiesPropertyPage");
        for (PropertyNamespace ns : this.namespaces.values()) {
            pages.addAll(ns.getPropertyPageIds());
        }
        return pages.toArray(new String[pages.size()]);
    }

    public boolean hasDisplayValue(String name) {
        PropertyNamespace namespace = this.getNamespace(name);
        return namespace.hasDisplayValue(name);
    }

    public String getDisplayValue(String name, String value, ITeamRepository repo, IProgressMonitor monitor) {
        PropertyNamespace namespace = this.getNamespace(name);
        return namespace.getDisplayValue(name, value, repo, monitor);
    }
}

