/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.properties;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ChangeFilePropertiesUtil {
    public static final Map<FileLineDelimiter, String> DELIMITER_STRINGS = new LinkedHashMap<FileLineDelimiter, String>();

    static {
        DELIMITER_STRINGS.put(FileLineDelimiter.LINE_DELIMITER_NONE, Messages.ChangeFilePropertiesUtil_0);
        DELIMITER_STRINGS.put(FileLineDelimiter.LINE_DELIMITER_LF, Messages.ChangeFilePropertiesUtil_1);
        DELIMITER_STRINGS.put(FileLineDelimiter.LINE_DELIMITER_CR, Messages.ChangeFilePropertiesUtil_2);
        DELIMITER_STRINGS.put(FileLineDelimiter.LINE_DELIMITER_CRLF, Messages.ChangeFilePropertiesUtil_3);
        DELIMITER_STRINGS.put(FileLineDelimiter.LINE_DELIMITER_PLATFORM, Messages.ChangeFilePropertiesUtil_4);
        FileLineDelimiter[] fileLineDelimiterArray = FileLineDelimiter.values();
        int n = fileLineDelimiterArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileLineDelimiter delimiter = fileLineDelimiterArray[n2];
            if (!DELIMITER_STRINGS.containsKey(delimiter)) {
                DELIMITER_STRINGS.put(delimiter, delimiter.toString());
            }
            ++n2;
        }
    }

    public static String delimiterToString(FileLineDelimiter delimiter) {
        if (delimiter == null) {
            return Messages.ChangeFilePropertiesUtil_5;
        }
        return DELIMITER_STRINGS.get(delimiter);
    }

    private ChangeFilePropertiesUtil() {
    }

    public static Link createLinkToFilePropertiesPreferencePage(Composite composite, final Shell shell) {
        return ChangeFilePropertiesUtil.createLinkToFilePropertiesPreferencePage(composite, new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"com.ibm.team.filesystem.ide.ui.changefileproperties.ChangeFilePropertiesPreferencePage", null, null);
                prefDialog.open();
            }
        });
    }

    public static Link createLinkToFilePropertiesPreferencePage(Composite composite, SelectionListener selectionListener) {
        Link link = new Link(composite, 64);
        link.setText(Messages.ChangeFilePropertiesUtil_6);
        link.addSelectionListener(selectionListener);
        return link;
    }

    public static Link createLinkToUserPropertiesPage(Composite composite, IPath path, SelectionListener selectionListener) {
        Link link = new Link(composite, 64);
        link.setText(NLS.bind((String)Messages.ChangeFilePropertiesUtil_7, (Object)path.toPortableString()));
        link.addSelectionListener(selectionListener);
        return link;
    }
}

