/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.properties;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.operations.ChangePropertiesOperation;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreference;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreferenceManager;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.properties.ChangeFilePropertiesUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.osgi.service.prefs.BackingStoreException;

public class ChangeFilePropertiesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.ibm.team.filesystem.ide.ui.changefileproperties.ChangeFilePropertiesPreferencePage";
    private TreeViewer viewer;
    private ContentPropertiesPreferenceManager manager;
    private Set<ContentPropertiesPreference> toBeRemoved = new HashSet<ContentPropertiesPreference>();

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Composite header = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)header);
        Label description = new Label(header, 64);
        description.setText(Messages.ChangeFilePropertiesPreferencePage_0);
        new PreferenceLinkArea(header, 0, "org.eclipse.ui.preferencePages.ContentTypes", "", (IWorkbenchPreferenceContainer)this.getContainer(), null);
        description = new Label(header, 64);
        description.setText(Messages.ChangeFilePropertiesPreferencePage_2);
        GridLayoutFactory.fillDefaults().generateLayout(header);
        Composite controlComposite = new Composite(composite, 0);
        final Tree tree = new Tree(controlComposite, 68352);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn column1 = new TreeColumn(tree, 16384);
        column1.setText(Messages.ChangeFilePropertiesPreferencePage_3);
        column1.setWidth(200);
        TreeColumn column2 = new TreeColumn(tree, 16384);
        column2.setText(Messages.ChangeFilePropertiesPreferencePage_4);
        column2.setWidth(100);
        column2.setToolTipText(Messages.ChangeFilePropertiesPreferencePage_5);
        TreeColumn column3 = new TreeColumn(tree, 16384);
        column3.setText(Messages.ChangeFilePropertiesPreferencePage_6);
        column3.setWidth(100);
        column3.setToolTipText(Messages.ChangeFilePropertiesPreferencePage_7);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement == ChangeFilePropertiesPreferencePage.this.manager) {
                    return ChangeFilePropertiesPreferencePage.this.manager.getChildren();
                }
                ContentPropertiesPreference node = (ContentPropertiesPreference)parentElement;
                Set children = ChangeFilePropertiesPreferencePage.this.getChildren(node);
                return children.toArray();
            }

            public Object getParent(Object element) {
                if (element == ChangeFilePropertiesPreferencePage.this.manager) {
                    return null;
                }
                ContentPropertiesPreference node = (ContentPropertiesPreference)element;
                return node.getParent();
            }

            public boolean hasChildren(Object element) {
                if (element == ChangeFilePropertiesPreferencePage.this.manager) {
                    return true;
                }
                ContentPropertiesPreference node = (ContentPropertiesPreference)element;
                return node.getChildren().length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        final LabelProvider labelProvider = new LabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof ContentPropertiesPreference.IContentTypePreferences) {
                    return 0;
                }
                if (element instanceof ContentPropertiesPreference) {
                    ContentPropertiesPreference pref = (ContentPropertiesPreference)element;
                    if (pref.getId().equals(ResourceUtil.getFileExtension((String)pref.getId()))) {
                        return 1;
                    }
                    return 2;
                }
                return 3;
            }
        });
        this.viewer.setInput((Object)this.manager);
        Composite buttons = new Composite(controlComposite, 0);
        Button addExtension = new Button(buttons, 8);
        addExtension.setText(Messages.ChangeFilePropertiesPreferencePage_8);
        final Text mimeEdit = new Text((Composite)tree, 0);
        mimeEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (tree.getSelectionCount() == 0) {
                    return;
                }
                ContentPropertiesPreference node = (ContentPropertiesPreference)tree.getSelection()[0].getData();
                String newMime = mimeEdit.getText().trim().toLowerCase();
                ChangeFilePropertiesPreferencePage.this.setMessage(null);
                if (newMime.equals("")) {
                    node.setMimeType(null);
                    ChangeFilePropertiesPreferencePage.this.setValid(true);
                } else if (!ChangePropertiesOperation.validMimeType((String)newMime)) {
                    ChangeFilePropertiesPreferencePage.this.setMessage(Messages.bind((String)Messages.ChangeFilePropertiesPreferencePage_18, (Object)newMime), 3);
                    ChangeFilePropertiesPreferencePage.this.setValid(false);
                } else {
                    node.setMimeType(newMime);
                    ChangeFilePropertiesPreferencePage.this.setValid(true);
                }
                ChangeFilePropertiesPreferencePage.this.viewer.update((Object)node, null);
            }
        });
        final CCombo lineDelimiterEdit = new CCombo((Composite)tree, 12);
        lineDelimiterEdit.setToolTipText(column3.getToolTipText());
        lineDelimiterEdit.setBackground(tree.getBackground());
        FileLineDelimiter[] fileLineDelimiterArray = FileLineDelimiter.values();
        int n = fileLineDelimiterArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileLineDelimiter lineDelimiter = fileLineDelimiterArray[n2];
            String text = ChangeFilePropertiesUtil.delimiterToString(lineDelimiter);
            lineDelimiterEdit.add(text);
            lineDelimiterEdit.setData(text, (Object)lineDelimiter);
            ++n2;
        }
        lineDelimiterEdit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ContentPropertiesPreference node = (ContentPropertiesPreference)tree.getSelection()[0].getData();
                FileLineDelimiter newLineDelimiter = (FileLineDelimiter)lineDelimiterEdit.getData(lineDelimiterEdit.getText());
                node.setLineDelimiter(newLineDelimiter);
                if (!node.isDirty() && !ChangeFilePropertiesPreferencePage.this.manager.isDirty()) {
                    ChangeFilePropertiesPreferencePage.this.getApplyButton().setEnabled(false);
                }
            }
        });
        final TreeEditor mimeEditor = new TreeEditor(tree);
        mimeEditor.setEditor((Control)mimeEdit, null, 1);
        mimeEditor.horizontalAlignment = 16384;
        mimeEditor.grabHorizontal = true;
        mimeEditor.grabVertical = true;
        final TreeEditor lineDelimiterEditor = new TreeEditor(tree);
        lineDelimiterEditor.setEditor((Control)lineDelimiterEdit, null, 2);
        lineDelimiterEditor.horizontalAlignment = 16384;
        lineDelimiterEditor.grabHorizontal = true;
        lineDelimiterEditor.grabVertical = true;
        final Button remove = new Button(buttons, 8);
        remove.setText(Messages.ChangeFilePropertiesPreferencePage_9);
        remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (tree.getSelectionCount() == 0) {
                    return;
                }
                TreeItem item = tree.getSelection()[0];
                ContentPropertiesPreference node = (ContentPropertiesPreference)item.getData();
                boolean wasEmpty = node.getTrueMimeType() == null && node.getTrueMimeType() == null;
                node.setLineDelimiter(null);
                node.setMimeType(null);
                String keepReason = null;
                if (node instanceof ContentPropertiesPreference.IContentTypePreferences) {
                    keepReason = NLS.bind((String)Messages.ChangeFilePropertiesPreferencePage_10, (Object)node.getName());
                } else {
                    IContentType contentType = node.getIContentType();
                    if (contentType != null) {
                        String[] specs;
                        String fileSpec = node.getId();
                        int type = 4;
                        if (this.matchFileSpec(fileSpec, contentType.getFileSpecs(8))) {
                            type = 8;
                        } else if (this.matchFileSpec(fileSpec, contentType.getFileSpecs(4))) {
                            type = 4;
                        } else if (fileSpec.startsWith("*.")) {
                            type = 8;
                            fileSpec = fileSpec.substring(2);
                        }
                        String[] stringArray = specs = contentType.getFileSpecs(type | 2);
                        int n = specs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String spec = stringArray[n2];
                            if (spec.equals(fileSpec)) {
                                keepReason = NLS.bind((String)Messages.ChangeFilePropertiesPreferencePage_11, (Object)node.getId(), (Object)contentType.getName());
                                break;
                            }
                            ++n2;
                        }
                        try {
                            contentType.removeFileSpec(fileSpec, type);
                        }
                        catch (CoreException e) {
                            ErrorDialog.openError((Shell)ChangeFilePropertiesPreferencePage.this.getShell(), (String)Messages.ChangeFilePropertiesPreferencePage_20, (String)NLS.bind((String)Messages.ChangeFilePropertiesPreferencePage_21, (Object)fileSpec, (Object)contentType.getName()), (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
                        }
                    }
                }
                Set children = ChangeFilePropertiesPreferencePage.this.getChildren(node);
                if (keepReason == null && children.size() > 0) {
                    ContentPropertiesPreference child = Collections.min(ChangeFilePropertiesPreferencePage.this.getChildren(node), new Comparator<ContentPropertiesPreference>(){

                        @Override
                        public int compare(ContentPropertiesPreference o1, ContentPropertiesPreference o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    keepReason = NLS.bind((String)Messages.ChangeFilePropertiesPreferencePage_12, (Object)node.getName(), (Object)child.getName());
                }
                if (keepReason == null) {
                    ChangeFilePropertiesPreferencePage.this.toBeRemoved.add(node);
                    ChangeFilePropertiesPreferencePage.this.viewer.refresh((Object)node.getParent());
                } else {
                    if (wasEmpty) {
                        keepReason = String.valueOf(keepReason) + Messages.ChangeFilePropertiesPreferencePage_13;
                        ToolTip toolTip = new ToolTip(ChangeFilePropertiesPreferencePage.this.getShell(), 4096);
                        toolTip.setMessage(keepReason);
                        Rectangle itemBounds = item.getBounds();
                        Point p = tree.toDisplay(0, 0);
                        Point spacing = LayoutConstants.getMargins();
                        p.x += itemBounds.x + spacing.x;
                        p.y += itemBounds.y + spacing.y;
                        toolTip.setLocation(p);
                        toolTip.setVisible(true);
                    }
                    ChangeFilePropertiesPreferencePage.this.viewer.update((Object)node, null);
                    mimeEdit.setText("");
                    lineDelimiterEdit.select(-1);
                }
            }

            private boolean matchFileSpec(String fileSpec, String[] fileSpecs) {
                String[] stringArray = fileSpecs;
                int n = fileSpecs.length;
                int n2 = 0;
                while (n2 < n) {
                    String spec = stringArray[n2];
                    if (fileSpec.equals(spec)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        final SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (tree.getSelectionCount() == 0) {
                    mimeEdit.setVisible(false);
                    mimeEditor.setItem(null);
                    lineDelimiterEdit.setVisible(false);
                    lineDelimiterEditor.setItem(null);
                    remove.setEnabled(false);
                    return;
                }
                TreeItem item = tree.getSelection()[0];
                ContentPropertiesPreference node = (ContentPropertiesPreference)item.getData();
                if (node.getId().equals("org.eclipse.core.runtime.text") || node.getId().equals("File names and Extensions")) {
                    mimeEdit.setVisible(false);
                    mimeEditor.setItem(null);
                    lineDelimiterEdit.setVisible(false);
                    lineDelimiterEditor.setItem(null);
                    remove.setEnabled(false);
                } else {
                    mimeEdit.setVisible(true);
                    mimeEdit.setText(labelProvider.getColumnText(node, 1));
                    mimeEditor.setItem(item);
                    mimeEditor.layout();
                    mimeEdit.setSelection(0, mimeEdit.getText().length());
                    mimeEdit.setFocus();
                    lineDelimiterEdit.setVisible(true);
                    String text = labelProvider.getColumnText(node, 2);
                    if (text.equals("")) {
                        lineDelimiterEdit.select(-1);
                    } else {
                        FileLineDelimiter lineDelimiter = (FileLineDelimiter)lineDelimiterEdit.getData(text);
                        lineDelimiterEdit.select(lineDelimiter.dbValue());
                    }
                    lineDelimiterEditor.setItem(item);
                    lineDelimiterEditor.layout();
                    remove.setEnabled(true);
                }
            }
        };
        addExtension.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent event) {
                IContentType parent = null;
                String message = tree.getSelectionCount() != 0 ? ((parent = ((ContentPropertiesPreference)tree.getSelection()[0].getData()).getIContentType()) != null ? NLS.bind((String)Messages.ChangeFilePropertiesPreferencePage_14, (Object[])new Object[]{Messages.ChangeFilePropertiesPreferencePage_15, parent.getName(), "File names and Extensions"}) : Messages.ChangeFilePropertiesPreferencePage_16) : Messages.ChangeFilePropertiesPreferencePage_17;
                InputDialog dialog = new InputDialog(ChangeFilePropertiesPreferencePage.this.getShell(), Messages.ChangeFilePropertiesPreferencePage_19, message, "", new IInputValidator(){

                    public String isValid(String newText) {
                        return null;
                    }
                });
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ContentPropertiesPreference pref;
                    String value = dialog.getValue().trim();
                    if (value.length() == 0) {
                        return;
                    }
                    if (parent != null) {
                        try {
                            if (value.equals(ResourceUtil.getFileExtension((String)value))) {
                                parent.addFileSpec(value.substring(value.lastIndexOf(46) + 1), 8);
                            } else {
                                parent.addFileSpec(value, 4);
                            }
                        }
                        catch (CoreException e) {
                            ErrorDialog.openError((Shell)ChangeFilePropertiesPreferencePage.this.getShell(), (String)Messages.ChangeFilePropertiesPreferencePage_22, (String)NLS.bind((String)Messages.ChangeFilePropertiesPreferencePage_23, (Object)value, (Object)parent.getName()), (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
                            return;
                        }
                    }
                    ContentPropertiesPreference ancestor = pref = ChangeFilePropertiesPreferencePage.this.manager.get(parent, value);
                    while (true) {
                        ChangeFilePropertiesPreferencePage.this.toBeRemoved.remove(ancestor);
                        if (ancestor.getParent() == null) break;
                        ancestor = ancestor.getParent();
                    }
                    ChangeFilePropertiesPreferencePage.this.viewer.refresh((Object)ancestor);
                    ChangeFilePropertiesPreferencePage.this.viewer.refresh();
                    ChangeFilePropertiesPreferencePage.this.viewer.setSelection((ISelection)new StructuredSelection((Object)pref));
                    selectionListener.widgetSelected(null);
                }
            }
        });
        this.applyDialogFont(composite);
        GridLayoutFactory.fillDefaults().generateLayout(buttons);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(controlComposite);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        tree.addSelectionListener(selectionListener);
        tree.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.preference_page_changefileproperties");
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.manager = new ContentPropertiesPreferenceManager();
        try {
            this.manager.populate();
        }
        catch (BackingStoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ChangeFilePropertiesPreferencePage_24, (String)Messages.ChangeFilePropertiesPreferencePage_25, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
    }

    public boolean performOk() {
        try {
            this.manager.flush();
            this.viewer.refresh();
            this.getApplyButton().setEnabled(false);
        }
        catch (BackingStoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ChangeFilePropertiesPreferencePage_26, (String)Messages.ChangeFilePropertiesPreferencePage_27, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        return super.performOk();
    }

    protected void performDefaults() {
        try {
            this.manager.refresh();
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        catch (BackingStoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ChangeFilePropertiesPreferencePage_24, (String)Messages.ChangeFilePropertiesPreferencePage_25, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
    }

    private Set<ContentPropertiesPreference> getChildren(ContentPropertiesPreference node) {
        HashSet<ContentPropertiesPreference> children = new HashSet<ContentPropertiesPreference>();
        ContentPropertiesPreference[] contentPropertiesPreferenceArray = node.getChildren();
        int n = contentPropertiesPreferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentPropertiesPreference child = contentPropertiesPreferenceArray[n2];
            if (!this.toBeRemoved.contains(child)) {
                children.add(child);
            }
            ++n2;
        }
        return children;
    }

    private static class LabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ContentPropertiesPreference node = (ContentPropertiesPreference)element;
            switch (columnIndex) {
                case 0: {
                    return node.getName();
                }
                case 1: {
                    return node.getTrueMimeType() != null ? node.getTrueMimeType() : "";
                }
                case 2: {
                    if (node.getTrueLineDelimiter() == null) break;
                    FileLineDelimiter lineDelimiter = node.getTrueLineDelimiter();
                    if (lineDelimiter == null) {
                        return "";
                    }
                    return ChangeFilePropertiesUtil.delimiterToString(lineDelimiter);
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }
}

