/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.checkin.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.rcp.core.internal.compare.ComparePropertiesState;
import com.ibm.team.filesystem.rcp.core.internal.compare.VersionableComparePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class VersionableTypedElement
extends BufferedContent
implements IEncodedStreamContentAccessor,
ITypedElement,
IEditableContent {
    private final IWorkspaceConnection workspace;
    private IComponentHandle component;
    private final IVersionable versionable;
    private final DisposableInputStreamProvider buffer;
    private FileLineDelimiter lineDelimiter;
    private IChangeSetHandle targetChangeSet;

    public VersionableTypedElement(IWorkspaceConnection workspace, IComponentHandle component, IVersionable versionable, DisposableInputStreamProvider buffer) {
        this(workspace, component, versionable, buffer, null);
    }

    public VersionableTypedElement(IWorkspaceConnection workspace, IComponentHandle component, IVersionable versionable, DisposableInputStreamProvider buffer, IChangeSetHandle targetChangeSet) {
        this.targetChangeSet = targetChangeSet;
        this.workspace = workspace;
        this.component = component;
        this.versionable = versionable;
        this.buffer = buffer;
    }

    public boolean isEditable() {
        return this.versionable instanceof IFileItem;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.versionable.getName();
    }

    public Image getImage() {
        if (this.getType().equals("FOLDER")) {
            return CompareUI.getImage((String)"FOLDER");
        }
        if (this.getFileExtension() == null) {
            return null;
        }
        return CompareUI.getImage((String)this.getFileExtension());
    }

    private String getFileExtension() {
        return new Path(this.getName()).getFileExtension();
    }

    public String getType() {
        String fileExtension;
        if (this.versionable instanceof IFolder) {
            return "FOLDER";
        }
        if (this.versionable instanceof IFileItem && (fileExtension = this.getFileExtension()) != null) {
            return fileExtension;
        }
        return "???";
    }

    public String getCharset() throws CoreException {
        if (this.versionable instanceof IFileItem) {
            IFileItem fileItem = (IFileItem)this.versionable;
            return fileItem.getContent().getCharacterEncoding();
        }
        return null;
    }

    protected InputStream createStream() throws CoreException {
        try {
            return this.buffer.getInputStream((IProgressMonitor)TempHelper.MONITOR);
        }
        catch (IOException e) {
            throw new CoreException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
    }

    public void commit(IProgressMonitor monitor) throws FileSystemException {
        if (Display.getCurrent() == null) {
            this.internalCommit(monitor);
            return;
        }
        final FileSystemException[] exception = new FileSystemException[1];
        Job job = new Job(Messages.VersionableTypedElement_1){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    VersionableTypedElement.this.internalCommit(monitor);
                }
                catch (FileSystemException e) {
                    exception[0] = e;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        int count = 0;
        while (job.getState() != 0) {
            try {
                Thread.sleep(500L);
                ++count;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (count <= 60) continue;
            job.cancel();
            throw new FileSystemException(Messages.VersionableTypedElement_2);
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    private void internalCommit(IProgressMonitor monitor) throws FileSystemException {
        byte[] content = this.getContent();
        try {
            this.commit(content, monitor);
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private void commit(byte[] bytes, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IFileContent content = this.uploadFileContent(bytes, (IProgressMonitor)progress.newChild(1));
        this.commitWithContent(content, (IProgressMonitor)progress.newChild(1));
    }

    private void commitWithContent(IFileContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        if (content != null) {
            ((IFileItem)this.versionable).setContent(content);
        }
        ChangeSetChooser chooser = new ChangeSetChooser(this.workspace, null, Messages.VersionableTypedElement_0);
        IWorkspaceConnection.ISaveOp op = this.workspace.configurationOpFactory().save(this.versionable);
        if (this.targetChangeSet == null) {
            chooser.toCommit(this.component, (IVersionableHandle)this.versionable, (IWorkspaceConnection.IConfigurationOp)op, (IProgressMonitor)progress.newChild(1));
        } else {
            chooser.toCommit(this.component, (IVersionableHandle)this.versionable, (IWorkspaceConnection.IConfigurationOp)op, this.targetChangeSet, null, (IProgressMonitor)progress.newChild(1));
        }
        IUpdateReport report = chooser.commit((IProgressMonitor)progress.newChild(1));
        UpdateOperation updateOperation = new UpdateOperation(this.workspace, Collections.singletonList(report), 3, UpdateDilemmaHandler.getDefault(), null);
        updateOperation.run((IProgressMonitor)progress.newChild(1));
    }

    private IFileContent uploadFileContent(byte[] content, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.versionable instanceof IFileItem) {
            IFileItem file = (IFileItem)this.versionable;
            IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)this.getTeamRepository());
            return contentManager.storeContent(file.getContent().getCharacterEncoding(), this.lineDelimiter == null ? file.getContent().getLineDelimiter() : this.lineDelimiter, this.getStreamProvider(content), file.getContent().getHash(), monitor);
        }
        return null;
    }

    private AbstractVersionedContentManagerInputStreamProvider getStreamProvider(final byte[] content) {
        return new AbstractVersionedContentManagerInputStreamProvider(){

            public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                return in;
            }

            public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                return new ByteArrayInputStream(content);
            }

            public void dispose() throws IOException, TeamRepositoryException {
            }
        };
    }

    public ComparePropertiesState createComparePropertiesState(FileState left, FileState right, FileState ancestor) {
        return new VersionableComparePropertiesState(left, left, right, ancestor){

            /*
             * WARNING - void declaration
             */
            public void updateState(Boolean executable, String contentType, FileLineDelimiter lineDelimiter, String linkTarget, boolean directoryLink, Map<String, String> properties, ChangePropertiesDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
                void var9_15;
                for (Map.Entry entry : VersionableTypedElement.this.versionable.getUserProperties().entrySet()) {
                    if (properties.containsKey(entry.getKey())) continue;
                    VersionableTypedElement.this.versionable.removeUserProperty((String)entry.getKey());
                }
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    VersionableTypedElement.this.versionable.setUserProperty((String)entry.getKey(), (String)entry.getValue());
                }
                Object var9_13 = null;
                if (this.isFile()) {
                    if (contentType != null) {
                        ((IFileItem)VersionableTypedElement.this.versionable).setContentType(contentType);
                    }
                    if (lineDelimiter != null) {
                        VersionableTypedElement.this.setLineDelimiter(lineDelimiter);
                    }
                    if (executable != null) {
                        ((IFileItem)VersionableTypedElement.this.versionable).setExecutable(executable.booleanValue());
                    }
                    String string = ((IFileItem)VersionableTypedElement.this.versionable).getContent().getCharacterEncoding();
                }
                if (this.isSymbolicLink() && linkTarget != null) {
                    ((ISymbolicLink)VersionableTypedElement.this.versionable).setTarget(linkTarget);
                    ((ISymbolicLink)VersionableTypedElement.this.versionable).setIsDirectoryLink(directoryLink);
                }
                FileState left = FileState.create((VersionablePathSegment)this.getLeft().getPath(), (Date)this.getLeft().getTimestamp(), (IInputStreamProvider)this.getLeft().getContents(), (boolean)executable, (String)contentType, (FileLineDelimiter)lineDelimiter, (boolean)this.getLeft().isTextType(), (String)var9_15, (boolean)false, properties, (StateId)this.getLeft().getStateId(), (ExternalLinks)this.getLeft().getExternalLinks(), (FileState.VersionIdType)this.getLeft().getVersionIds());
                this.setLeft(left);
            }

            public IVersionable getVersionable() {
                return VersionableTypedElement.this.versionable;
            }
        };
    }

    protected void setLineDelimiter(FileLineDelimiter lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    protected ITeamRepository getTeamRepository() {
        return this.workspace.teamRepository();
    }
}

