/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.compare.ComparePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.AbstractCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FolderTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.InputStreamProviderTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.VersionableTypedElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class VersionableChangeCompareEditorInput
extends AbstractCompareEditorInput
implements IResourceChangeListener {
    private IWorkspaceConnection fWorkspace;
    private IComponentHandle fComponent;
    private IVersionableChange fVersionableChange;
    private UUID fOriginalCurrentPortId;
    private IFile fLocalFile;
    private IChangeSetHandle fTargetChangeSet;

    public VersionableChangeCompareEditorInput(IWorkbenchPage page, CompareConfiguration compareConfiguration, IWorkspaceConnection workspace, IComponentHandle component, IVersionableChange versionableChange, boolean isExternal) {
        super(compareConfiguration, isExternal);
        this.setPage(page);
        this.fWorkspace = workspace;
        this.fComponent = component;
        this.fVersionableChange = versionableChange;
        ICurrentPatch currentPort = this.fWorkspace.getCurrentPatch(this.fComponent);
        if (currentPort != null) {
            this.fOriginalCurrentPortId = currentPort.getSourceId();
            this.fTargetChangeSet = currentPort.getTargetChangeSet();
        }
    }

    @Override
    public void contentsCreated() {
        if (this.fLocalFile != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        super.contentsCreated();
    }

    public String getTitle() {
        return this.fVersionableChange.getName();
    }

    protected String getFileName() {
        return this.getTitle();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fLocalFile != null) {
            Shell shell;
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta = delta.findMember(this.fLocalFile.getFullPath());
            }
            if (delta != null && ((delta.getKind() & 3) > 0 || (delta.getKind() & 4) > 0 && (delta.getFlags() & 0x40100) > 0) && (shell = this.getShell()) != null && !shell.isDisposed()) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        VersionableChangeCompareEditorInput.this.fireInputChange();
                    }
                });
            }
        }
    }

    @Override
    protected ITypedElement createLeftElement(IFile file) throws FileSystemException {
        this.fLocalFile = file;
        return super.createLeftElement(this.fLocalFile);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeLeft(IProgressMonitor monitor) throws CoreException, IOException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IVersionableHandle versionableHandle = this.fVersionableChange.getVersionable();
        IShareable shareable = ComponentSyncUtil.findShareable((IContextHandle)this.fWorkspace.getContextHandle(), (IComponentHandle)this.fComponent, (IVersionableHandle)versionableHandle, (IProgressMonitor)progress.newChild(1));
        if (shareable != null || this.fVersionableChange.getAfterState() == null) {
            ITypedElement element = this.createLeftElement(shareable, (IProgressMonitor)progress.newChild(1));
            String fileName = shareable != null ? this.getFileName() : Messages.ContentChangeCompareEditorInput_2;
            return new AbstractCompareEditorInput.TypedElementAndData(element, fileName, shareable);
        }
        String name = this.getFileName();
        String label = NLS.bind((String)Messages.ConflictCompareEditorInput_3, (Object)name);
        ITeamRepository repo = this.fWorkspace.teamRepository();
        IVersionable versionable = this.fWorkspace.configuration(this.fComponent).fetchCompleteItem(versionableHandle, (IProgressMonitor)progress.newChild(1));
        if (versionable == null) {
            ITypedElement element = this.createLeftElement(null, (IProgressMonitor)progress.newChild(1));
            return new AbstractCompareEditorInput.TypedElementAndData(element, Messages.ContentChangeCompareEditorInput_2, shareable);
        }
        IVersionable workingCopy = (IVersionable)versionable.getWorkingCopy();
        FileState fileState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)versionable.getItemType(), (IVersionable)versionable);
        IInputStreamProvider inputStreamProvider = fileState.getContents();
        DisposableInputStreamProvider buffer = inputStreamProvider instanceof DisposableInputStreamProvider ? (DisposableInputStreamProvider)inputStreamProvider : TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)inputStreamProvider, (IProgressMonitor)monitor);
        VersionableTypedElement element = new VersionableTypedElement(this.fWorkspace, this.fComponent, workingCopy, buffer, this.fTargetChangeSet);
        return new AbstractCompareEditorInput.TypedElementAndData(element, label, fileState, workingCopy);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeRight(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        String label = null;
        label = this.fVersionableChange.getAfterState() != null ? NLS.bind((String)Messages.ContentChangeCompareEditorInput_1, (Object)this.getFileName()) : Messages.SimpleConflictCompareEditorInput_15;
        return this.compute(this.fVersionableChange.getAfterState(), label, monitor);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeAncestor(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        String label = null;
        if (this.fVersionableChange.getBeforeState() != null) {
            label = NLS.bind((String)Messages.ContentChangeCompareEditorInput_0, (Object)this.getFileName());
        }
        return this.compute(this.fVersionableChange.getBeforeState(), label, monitor);
    }

    private AbstractCompareEditorInput.TypedElementAndData compute(IVersionableHandle versionableHandle, String label, IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            FileLineDelimiter localLineDelimeter = this.getLocalLineDelimiter(versionableHandle, (IProgressMonitor)progress.newChild(1));
            FileState fileState = this.getFileState(versionableHandle, (IProgressMonitor)progress.newChild(1));
            ITypedElement element = this.createTypedElement(fileState, localLineDelimeter, (IProgressMonitor)progress.newChild(1));
            AbstractCompareEditorInput.TypedElementAndData typedElementAndData = new AbstractCompareEditorInput.TypedElementAndData(element, label, fileState);
            return typedElementAndData;
        }
        finally {
            progress.done();
        }
    }

    private FileLineDelimiter getLocalLineDelimiter(IVersionableHandle versionableHandle, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            IShareable shareable;
            FileLineDelimiter localLineDelimeter = null;
            if (versionableHandle != null && (shareable = ComponentSyncUtil.findShareable((IContextHandle)this.fWorkspace.getContextHandle(), (IComponentHandle)this.fComponent, (IVersionableHandle)versionableHandle, (IProgressMonitor)progress.newChild(1))) != null) {
                localLineDelimeter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(1));
            }
            FileLineDelimiter fileLineDelimiter = localLineDelimeter;
            return fileLineDelimiter;
        }
        finally {
            progress.done();
        }
    }

    private FileState getFileState(IVersionableHandle versionableHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (versionableHandle == null) {
            return null;
        }
        ITeamRepository repo = this.fWorkspace.teamRepository();
        IVersionable item = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(versionableHandle, monitor);
        return ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)item.getItemType(), (IVersionable)item);
    }

    private ITypedElement createTypedElement(FileState fileState, FileLineDelimiter localLineDelimeter, IProgressMonitor monitor) throws IOException {
        Object element = fileState == null ? null : (fileState.getStateId().getItemType().equals(IFileItem.ITEM_TYPE) ? InputStreamProviderTypedElement.createTypedElement(fileState, localLineDelimeter, monitor) : new FolderTypedElement(FileChangeEditorInput.getName(fileState)));
        return element;
    }

    @Override
    protected ComparePropertiesState createFilePropertyState(AbstractCompareEditorInput.TypedElementAndData left, AbstractCompareEditorInput.TypedElementAndData right, AbstractCompareEditorInput.TypedElementAndData ancestor, IProgressMonitor monitor) throws FileSystemException {
        IShareable shareable = left.getShareable();
        if (shareable != null) {
            return ComparePropertiesState.createFor((IShareable)shareable, (FileState)right.getFileState(), (FileState)ancestor.getFileState(), (IProgressMonitor)monitor);
        }
        if (left.getElement() instanceof VersionableTypedElement && left.getVersionable() != null) {
            return ((VersionableTypedElement)left.getElement()).createComparePropertiesState(left.getFileState(), right.getFileState(), ancestor.getFileState());
        }
        return ComparePropertiesState.createFor((FileState)left.getFileState(), (FileState)right.getFileState(), (FileState)ancestor.getFileState());
    }

    @Override
    protected boolean includeFileProperties() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fWorkspace == null ? 0 : this.fWorkspace.getResolvedWorkspace().getItemId().hashCode());
        result = 31 * result + (this.fComponent == null ? 0 : this.fComponent.getItemId().hashCode());
        result = 31 * result + (this.fVersionableChange == null ? 0 : this.fVersionableChange.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionableChangeCompareEditorInput other = (VersionableChangeCompareEditorInput)obj;
        if (this.fWorkspace == null ? other.fWorkspace != null : !this.fWorkspace.equals((Object)other.fWorkspace)) {
            return false;
        }
        if (this.fComponent == null ? other.fComponent != null : !this.fComponent.sameItemId((IItemHandle)other.fComponent)) {
            return false;
        }
        return !(this.fVersionableChange == null ? other.fVersionableChange != null : !this.fVersionableChange.getId().equals((Object)other.fVersionableChange.getId()));
    }

    @Override
    public void handleDispose() {
        if (this.fLocalFile != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        super.handleDispose();
    }

    @Override
    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        super.saveChanges(monitor);
        Job job = new Job(Messages.ContentChangeCompareEditorInput_3){

            protected IStatus run(IProgressMonitor monitor) {
                ICheckinOperation commitOp = IOperationFactory.instance.getCheckinOperation(CommitDilemmaHandler.getDefault(), IRepositoryResolver.EXISTING_SHARED);
                ICurrentPatch currentPort = VersionableChangeCompareEditorInput.this.fWorkspace.getCurrentPatch(VersionableChangeCompareEditorInput.this.fComponent);
                if (VersionableChangeCompareEditorInput.this.fOriginalCurrentPortId == null || currentPort == null || !currentPort.getSourceId().equals((Object)VersionableChangeCompareEditorInput.this.fOriginalCurrentPortId)) {
                    return Status.OK_STATUS;
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                try {
                    IShareable shareable = ComponentSyncUtil.findShareable((IContextHandle)VersionableChangeCompareEditorInput.this.fWorkspace.getContextHandle(), (IComponentHandle)VersionableChangeCompareEditorInput.this.fComponent, (IVersionableHandle)VersionableChangeCompareEditorInput.this.fVersionableChange.getVersionable(), (IProgressMonitor)progress.newChild(1));
                    if (shareable != null) {
                        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
                        lcm.refreshChanges(Collections.singletonList(shareable), ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)progress.newChild(1));
                        IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
                        if (share != null) {
                            lcm.syncPendingChanges(share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), shareable.getSandbox(), (IProgressMonitor)progress.newChild(1));
                        }
                        commitOp.requestCheckin(new IShareable[]{shareable}, currentPort.getTargetChangeSet(), null, (IProgressMonitor)progress.newChild(1));
                        commitOp.run((IProgressMonitor)progress.newChild(1));
                    }
                }
                catch (TeamRepositoryException e) {
                    return FileSystemStatusUtil.getStatusFor((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }
}

