/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FireChangeDiffNode;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class PropertyCompareEditorInput
extends CompareEditorInput {
    private final String left;
    private final String right;
    private final String ancestor;
    private final String propertyName;
    private String result;

    public PropertyCompareEditorInput(String propertyName, String left, String right, String ancestor, CompareConfiguration configuration) {
        super(configuration);
        this.propertyName = propertyName;
        this.left = left;
        this.right = right;
        this.ancestor = ancestor;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        LeftElement leftElement = new LeftElement(this.left);
        TextElement rightElement = null;
        if (this.right != null) {
            rightElement = new TextElement(this.right);
        }
        TextElement ancestorElement = null;
        if (this.ancestor != null) {
            ancestorElement = new TextElement(this.ancestor);
        }
        Differencer d = new Differencer(){

            protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                return new FireChangeDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
            }
        };
        Object result = d.findDifferences(ancestorElement != null, monitor, null, (Object)ancestorElement, (Object)leftElement, (Object)rightElement);
        return result;
    }

    public String getResult() {
        return this.result;
    }

    public void cancelPressed() {
        this.result = null;
        super.cancelPressed();
    }

    public boolean okPressed() {
        boolean okPressed = super.okPressed();
        if (okPressed) {
            this.updateResult();
        }
        return okPressed;
    }

    protected void updateResult() {
        DiffNode dn;
        ITypedElement left;
        Object compareResult = this.getCompareResult();
        if (compareResult instanceof DiffNode && (left = (dn = (DiffNode)compareResult).getLeft()) instanceof BufferedContent) {
            BufferedContent bc = (BufferedContent)left;
            try {
                this.result = new String(bc.getContent(), this.getCharset());
            }
            catch (UnsupportedEncodingException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
        }
    }

    private String getCharset() {
        return "UTF-8";
    }

    public String getOKButtonLabel() {
        return IDialogConstants.OK_LABEL;
    }

    public String getTitle() {
        return NLS.bind((String)Messages.PropertyCompareEditorInput_0, (Object)this.propertyName);
    }

    private class LeftElement
    extends BufferedContent
    implements ITypedElement,
    IEncodedStreamContentAccessor,
    IEditableContent {
        private final String value;

        public LeftElement(String value) {
            this.value = value == null ? "" : value;
        }

        protected InputStream createStream() throws CoreException {
            try {
                return new ByteArrayInputStream(this.value.getBytes(this.getCharset()));
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
            }
        }

        public String getCharset() {
            return PropertyCompareEditorInput.this.getCharset();
        }

        public String getName() {
            return PropertyCompareEditorInput.this.propertyName;
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public boolean isEditable() {
            return true;
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return null;
        }
    }

    private class TextElement
    implements ITypedElement,
    IStreamContentAccessor,
    IEncodedStreamContentAccessor {
        private final String value;

        public TextElement(String value) {
            this.value = value;
        }

        public String getName() {
            return PropertyCompareEditorInput.this.propertyName;
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() throws CoreException {
            try {
                return new ByteArrayInputStream(this.value.getBytes(this.getCharset()));
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }

        public String getCharset() {
            return PropertyCompareEditorInput.this.getCharset();
        }
    }
}

