/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.PropertyCompareEditorInput;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IPropertyChangeDetail;
import com.ibm.team.scm.common.IVersionableChange;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class PropertyChangeDetailCompareEditorInput
extends PropertyCompareEditorInput {
    private IPropertyChangeDetail fPropertyChangeDetail;
    private IWorkspaceConnection fWorkspace;
    private IComponentHandle fComponent;
    private IVersionableChange fVersionableChange;
    private IShareable fShareable;
    private UpdateCurrentPatchDilemmaHandler fCustomHandler;
    private String fLocalValue;
    private boolean fInEditor;
    private boolean fMarkedAsResolved;

    public static PropertyChangeDetailCompareEditorInput create(IWorkspaceConnection workspace, IComponentHandle component, IVersionableChange versionableChange, IPropertyChangeDetail propertyChangeDetail, IShareable shareable, UpdateCurrentPatchDilemmaHandler customHandler, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        IMetadataProperties metadataProperties = shareable.getMetadataProperties((IProgressMonitor)progress.newChild(50));
        String currentValue = (String)metadataProperties.getCurrentProperties().get(propertyChangeDetail.getPropertyName());
        String localValue = currentValue == null ? Messages.PropertyChangeDetailCompareEditorInput_PROPERTY_NOT_DEFINED : currentValue;
        String beforeValue = propertyChangeDetail.getBeforeValue() == null ? Messages.PropertyChangeDetailCompareEditorInput_PROPERTY_NOT_DEFINED : propertyChangeDetail.getBeforeValue();
        String afterValue = propertyChangeDetail.getAfterValue() == null ? Messages.PropertyChangeDetailCompareEditorInput_PROPERTY_NOT_DEFINED : propertyChangeDetail.getAfterValue();
        CompareConfiguration configuration = new CompareConfiguration();
        configuration.setLeftEditable(true);
        configuration.setRightEditable(false);
        configuration.setLeftLabel(Messages.PropertyChangeDetailCompareEditorInput_LEFT_LABEL);
        configuration.setAncestorLabel(Messages.PropertyChangeDetailCompareEditorInput_ANCESTOR_LABEL);
        configuration.setRightLabel(Messages.PropertyChangeDetailCompareEditorInput_RIGHT_LABEL);
        if (propertyChangeDetail.getType() != 1) {
            configuration.setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (Object)true);
        }
        configuration.setChangeIgnored(3, true);
        return new PropertyChangeDetailCompareEditorInput(configuration, workspace, component, versionableChange, propertyChangeDetail, shareable, localValue, beforeValue, afterValue, customHandler);
    }

    private PropertyChangeDetailCompareEditorInput(CompareConfiguration compareConfiguration, IWorkspaceConnection workspace, IComponentHandle component, IVersionableChange versionableChange, IPropertyChangeDetail propertyChangeDetail, IShareable shareable, String localValue, String beforeValue, String afterValue, UpdateCurrentPatchDilemmaHandler customHandler) {
        super(propertyChangeDetail.getPropertyName(), localValue, afterValue, beforeValue, compareConfiguration);
        this.fWorkspace = workspace;
        this.fComponent = component;
        this.fVersionableChange = versionableChange;
        this.fPropertyChangeDetail = propertyChangeDetail;
        this.fShareable = shareable;
        this.fLocalValue = localValue;
        this.fCustomHandler = customHandler;
        this.fMarkedAsResolved = propertyChangeDetail.isResolved();
    }

    @Override
    public String getTitle() {
        return NLS.bind((String)Messages.PropertyChangeDetailCompareEditorInput_INPUT_TITLE, (Object)this.fPropertyChangeDetail.getPropertyName());
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        super.saveChanges(monitor);
        if (this.isInEditor()) {
            this.updateResult();
            Job job = new Job(Messages.ContentChangeCompareEditorInput_3){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        PropertyChangeDetailCompareEditorInput.this.applyPropertyChange(monitor);
                    }
                    catch (FileSystemException e) {
                        return FileSystemStatusUtil.getStatusFor((Throwable)e);
                    }
                    catch (OperationFailedException e) {
                        return FileSystemStatusUtil.getStatusFor((Throwable)e);
                    }
                    catch (TeamRepositoryException e) {
                        return FileSystemStatusUtil.getStatusFor((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(false);
            job.schedule();
        }
    }

    public boolean isInEditor() {
        return this.fInEditor;
    }

    public void setInEditor(boolean inEditor) {
        this.fInEditor = inEditor;
    }

    public void applyPropertyChange(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ICurrentPatch currentPort = this.fWorkspace.getCurrentPatch(this.fComponent);
        boolean hasUnresolvedChanges = false;
        ILocalChange localChange = this.fShareable.getChange((IProgressMonitor)progress.newChild(20));
        if (localChange != null && localChange.getType() != 0) {
            hasUnresolvedChanges = true;
        }
        IMetadataProperties metadataProperties = this.fShareable.getMetadataProperties((IProgressMonitor)progress.newChild(20));
        HashMap<String, String> currentProperties = new HashMap<String, String>(metadataProperties.getCurrentProperties());
        currentProperties.put(this.fPropertyChangeDetail.getPropertyName(), this.getResult());
        IChangePropertiesOperation changePropertiesOp = IOperationFactory.instance.getChangePropertiesOperation(ChangePropertiesDilemmaHandler.getDefault());
        changePropertiesOp.setProperties(this.fShareable, currentProperties);
        changePropertiesOp.run((IProgressMonitor)progress.newChild(20));
        if (!hasUnresolvedChanges) {
            ICheckinOperation checkinOp = IOperationFactory.instance.getCheckinOperation(CommitDilemmaHandler.getDefault(), IRepositoryResolver.EXISTING_SHARED);
            checkinOp.requestCheckin(new IShareable[]{this.fShareable}, currentPort.getTargetChangeSet(), null, (IProgressMonitor)progress.newChild(10));
            checkinOp.run((IProgressMonitor)progress.newChild(10));
        }
        progress.setWorkRemaining(20);
        if (!this.fMarkedAsResolved) {
            IUpdateCurrentPatchOperation updateCurrentPortOp = OperationFactory.getInstance().getUpdateCurrentPortOperation(this.fCustomHandler);
            updateCurrentPortOp.setContext(this.fWorkspace, this.fComponent);
            updateCurrentPortOp.markAsResolved(this.fVersionableChange.getVersionable(), Collections.singleton(this.fPropertyChangeDetail.getId()), true);
            updateCurrentPortOp.run((IProgressMonitor)progress.newChild(20));
            this.fMarkedAsResolved = true;
        }
        progress.done();
    }

    public boolean hasChange() {
        String result = this.getResult();
        return result != null && !result.equals(this.fLocalValue);
    }
}

