/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.compare.ComparePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.AbstractCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FolderTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.InputStreamProviderTypedElement;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConstantFunction;
import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LocalFileCompareEditorInput
extends AbstractCompareEditorInput {
    private IShareable shareable;
    private IRemoteFunction<FileState> rightFunction;
    private IRemoteFunction<FileState> ancestorFunction;

    public LocalFileCompareEditorInput(CompareConfiguration configuration, IShareable left, FileState ancestor, FileState right, boolean isExternal) {
        this(configuration, left, (IRemoteFunction<FileState>)(ancestor == null ? null : new ConstantFunction((Object)ancestor)), (IRemoteFunction<FileState>)new ConstantFunction((Object)right), isExternal);
    }

    public LocalFileCompareEditorInput(CompareConfiguration configuration, IShareable left, IRemoteFunction<FileState> right, boolean isExternal) {
        this(configuration, left, null, right, isExternal);
    }

    public LocalFileCompareEditorInput(CompareConfiguration configuration, IShareable left, IRemoteFunction<FileState> ancestor, IRemoteFunction<FileState> right, boolean isExternal) {
        super(configuration, isExternal);
        this.shareable = left;
        this.rightFunction = right;
        this.ancestorFunction = ancestor;
    }

    public String getTitle() {
        if (this.shareable != null) {
            return this.shareable.getLocalPath().getName();
        }
        return super.getTitle();
    }

    @Override
    public boolean canRunAsJob() {
        return true;
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeLeft(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        ITypedElement element = this.createLeftElement(this.shareable, monitor);
        String label = element.getName();
        return new AbstractCompareEditorInput.TypedElementAndData(element, label, this.shareable);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeAncestor(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        FileLineDelimiter localLineDelimeter = null;
        if (this.shareable != null) {
            localLineDelimeter = this.shareable.getLineDelimiter((IProgressMonitor)progress.newChild(1));
        }
        Object element = null;
        FileState fileState = null;
        if (this.ancestorFunction != null) {
            fileState = (FileState)this.ancestorFunction.compute((IProgressMonitor)progress.newChild(1));
            element = fileState.getStateId().getItemType().equals(IFileItem.ITEM_TYPE) ? InputStreamProviderTypedElement.createTypedElement(fileState, localLineDelimeter, (IProgressMonitor)progress.newChild(1)) : new FolderTypedElement(FileChangeEditorInput.getName(fileState));
        }
        String label = null;
        return new AbstractCompareEditorInput.TypedElementAndData((ITypedElement)element, label, fileState);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeRight(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        FileState fileState;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        FileLineDelimiter localLineDelimeter = null;
        if (this.shareable != null) {
            localLineDelimeter = this.shareable.getLineDelimiter((IProgressMonitor)progress.newChild(1));
        }
        Object element = (fileState = (FileState)this.rightFunction.compute((IProgressMonitor)progress.newChild(1))).getStateId().getItemType().equals(IFileItem.ITEM_TYPE) ? InputStreamProviderTypedElement.createTypedElement(fileState, localLineDelimeter, (IProgressMonitor)progress.newChild(1)) : new FolderTypedElement(FileChangeEditorInput.getName(fileState));
        String label = fileState.isDeleted() ? Messages.LocalFileCompareEditorInput_1 : this.getLabelWithVersion(fileState, element.getName());
        return new AbstractCompareEditorInput.TypedElementAndData((ITypedElement)element, label, fileState);
    }

    @Override
    protected ComparePropertiesState createFilePropertyState(AbstractCompareEditorInput.TypedElementAndData left, AbstractCompareEditorInput.TypedElementAndData right, AbstractCompareEditorInput.TypedElementAndData ancestor, IProgressMonitor monitor) throws FileSystemException {
        return ComparePropertiesState.createFor((IShareable)left.getShareable(), (FileState)right.getFileState(), null, (IProgressMonitor)monitor);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ancestorFunction == null ? 0 : this.ancestorFunction.hashCode());
        result = 31 * result + (this.rightFunction == null ? 0 : this.rightFunction.hashCode());
        result = 31 * result + (this.shareable == null ? 0 : this.shareable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalFileCompareEditorInput other = (LocalFileCompareEditorInput)obj;
        if (this.ancestorFunction == null ? other.ancestorFunction != null : !this.ancestorFunction.equals(other.ancestorFunction)) {
            return false;
        }
        if (this.rightFunction == null ? other.rightFunction != null : !this.rightFunction.equals(other.rightFunction)) {
            return false;
        }
        return !(this.shareable == null ? other.shareable != null : !this.shareable.equals(other.shareable));
    }
}

