/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.internal.FileContentInputStreamProvider;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.internal.repository.rcp.streams.ByteArrayInputStreamProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.VersionedContentDeleted;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.graphics.Image;

public final class InputStreamProviderTypedElement
implements ITypedElement,
IEncodedStreamContentAccessor,
IAdaptable {
    private String name;
    private String type;
    private final DisposableInputStreamProvider buffer;
    private final String encoding;

    public static InputStreamProviderTypedElement createTypedElement(ITeamRepository repository, IFileItem fileItem, String name, String extension, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        FileContentInputStreamProvider inputStreamProvider = new FileContentInputStreamProvider(repository, (IFileItemHandle)fileItem, fileItem.getContent());
        String encoding = fileItem.getContent().getCharacterEncoding();
        return InputStreamProviderTypedElement.createTypedElement((IInputStreamProvider)inputStreamProvider, name, extension, encoding, monitor);
    }

    public static ITypedElement createTypedElement(ITeamRepository repo, ISymbolicLink symbolicLink, String name, String extension, IProgressMonitor monitor) throws TeamRepositoryException {
        String target = symbolicLink.getTarget();
        ByteArrayInputStreamProvider streamProvider = new ByteArrayInputStreamProvider(target.getBytes());
        String encoding = System.getProperty("file.encoding");
        return InputStreamProviderTypedElement.createTypedElement((DisposableInputStreamProvider)streamProvider, name, extension, encoding);
    }

    public static InputStreamProviderTypedElement createTypedElement(FileState state, IProgressMonitor monitor) throws IOException {
        return InputStreamProviderTypedElement.createTypedElement(state, null, monitor);
    }

    public static InputStreamProviderTypedElement createTypedElement(final FileState state, final FileLineDelimiter localLineDelimeter, IProgressMonitor monitor) throws IOException {
        InputStreamProviderTypedElement ispte;
        IInputStreamProvider inputStreamProvider = state.getContents();
        inputStreamProvider = localLineDelimeter != null && InputStreamProviderTypedElement.requiresConversion(state.getLineDelimiter(), localLineDelimeter) ? new IInputStreamProvider(){

            public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
                InputStream is = state.getContents().getInputStream(monitor);
                String encoding = state.getCharacterEncoding();
                if (encoding.equals("") || localLineDelimeter == FileLineDelimiter.LINE_DELIMITER_NONE) {
                    return is;
                }
                return new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)is, (String)encoding, (FileLineDelimiter)localLineDelimeter));
            }
        } : state.getContents();
        String name = FileChangeEditorInput.getName(state);
        String extension = FileChangeEditorInput.getExtension(state);
        String encoding = state.getCharacterEncoding();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ispte = InputStreamProviderTypedElement.createTypedElement(inputStreamProvider, name, extension, encoding, (IProgressMonitor)progress.newChild(99));
        }
        catch (IOException e) {
            if (!(e.getCause() instanceof VersionedContentDeleted)) {
                throw e;
            }
            String msg = Messages.InputStreamProviderTypedElement_0;
            byte[] bytes = null;
            if (encoding != "") {
                try {
                    Charset c = Charset.forName(encoding);
                    if (c.canEncode()) {
                        CharsetEncoder ce = c.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                        ByteBuffer result = ce.encode(CharBuffer.wrap(msg));
                        bytes = new byte[result.limit()];
                        result.get(bytes);
                    }
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                }
                catch (MalformedInputException malformedInputException) {
                }
                catch (UnmappableCharacterException unmappableCharacterException) {
                    // empty catch block
                }
            }
            if (bytes == null) {
                encoding = "UTF-8";
                bytes = msg.getBytes(encoding);
            }
            progress.setWorkRemaining(100);
            ispte = InputStreamProviderTypedElement.createTypedElement((IInputStreamProvider)new ByteArrayInputStreamProvider(bytes), name, extension, encoding, (IProgressMonitor)progress.newChild(100));
        }
        return ispte;
    }

    private static boolean requiresConversion(FileLineDelimiter remoteLineDelimiter, FileLineDelimiter localLineDelimiter) {
        if (localLineDelimiter == null || localLineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE) {
            return false;
        }
        if (remoteLineDelimiter == null || remoteLineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE) {
            return true;
        }
        if (remoteLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
            remoteLineDelimiter = FileLineDelimiter.getPlatformDelimiter();
        }
        if (localLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
            localLineDelimiter = FileLineDelimiter.getPlatformDelimiter();
        }
        return !remoteLineDelimiter.equals((Object)localLineDelimiter);
    }

    public static InputStreamProviderTypedElement createTypedElement(IInputStreamProvider inputStreamProvider, String name, String extension, String encoding, IProgressMonitor monitor) throws IOException {
        DisposableInputStreamProvider buffer = inputStreamProvider instanceof DisposableInputStreamProvider ? (DisposableInputStreamProvider)inputStreamProvider : TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)inputStreamProvider, (IProgressMonitor)monitor);
        String encoding2 = ResourceUtil.getEncoding((String)encoding, (DisposableInputStreamProvider)buffer, (IProgressMonitor)monitor);
        return new InputStreamProviderTypedElement(buffer, name, extension, encoding2);
    }

    public static InputStreamProviderTypedElement createTypedElement(DisposableInputStreamProvider buffer, String name, String extension, String encoding) {
        return new InputStreamProviderTypedElement(buffer, name, extension, encoding);
    }

    private InputStreamProviderTypedElement(DisposableInputStreamProvider buffer, String name, String type, String encoding) {
        this.buffer = buffer;
        this.encoding = encoding;
        this.name = name;
        this.type = type;
    }

    public Image getImage() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getCharset() throws CoreException {
        return this.encoding;
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.buffer.getInputStream((IProgressMonitor)TempHelper.MONITOR);
        }
        catch (IOException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == DisposableInputStreamProvider.class) {
            return this.buffer;
        }
        return null;
    }
}

