/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.exceptions.ContentRetrievalFailure;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.graphics.Image;

public class FileStorageTypedElement
extends BufferedContent
implements IEncodedStreamContentAccessor,
ITypedElement,
IEditableContent,
IModificationDate {
    private final IFileStorage file;
    private final String encoding;
    private ResourceType type;
    private String target;
    private final FileLineDelimiter lineDelimiter;
    private final Map<String, String> properties;

    protected FileStorageTypedElement(IFileStorage fileStorage, FileLineDelimiter lineDelimiter, String encoding, Map<String, String> properties, ResourceType type, String target, boolean directoryLink) {
        this.file = fileStorage;
        this.lineDelimiter = lineDelimiter;
        this.encoding = encoding;
        this.properties = properties;
        this.type = type;
        this.target = target;
    }

    public static FileStorageTypedElement create(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ResourceType type = shareable.getResourceType((IProgressMonitor)sub.newChild(1));
        IFileStorage fileStorage = CoreShareablesUtil.getFileStorage((IShareable)shareable);
        String encoding = null;
        String target = null;
        Map currentProperties = shareable.getMetadataProperties((IProgressMonitor)sub.newChild(1)).getCurrentProperties();
        boolean directoryLink = false;
        if (type == ResourceType.SYMBOLIC_LINK) {
            LinkInfo linkTargetInfo = fileStorage.getLinkInfo((IProgressMonitor)sub.newChild(1));
            target = linkTargetInfo.getTarget();
            LinkType linkTargetType = linkTargetInfo.getType();
            if (linkTargetType == LinkType.DIRECTORY) {
                directoryLink = true;
            }
        } else {
            encoding = ResourceUtil.getEncoding((IFileStorage)fileStorage, (IProgressMonitor)sub.newChild(1));
        }
        return new FileStorageTypedElement(fileStorage, shareable.getLineDelimiter((IProgressMonitor)sub.newChild(1)), encoding, currentProperties, type, target, directoryLink);
    }

    protected InputStream createStream() throws CoreException {
        if (this.type == ResourceType.SYMBOLIC_LINK) {
            return new ByteArrayInputStream(this.target.getBytes());
        }
        try {
            return this.file.getContents((IFileOptions)new FileOptions(false, this.lineDelimiter, this.encoding, this.properties));
        }
        catch (ContentRetrievalFailure e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
    }

    public String getCharset() throws CoreException {
        return this.encoding;
    }

    public Image getImage() {
        if (this.type == ResourceType.FOLDER) {
            return CompareUI.getImage((String)"FOLDER");
        }
        Path path = new Path(this.getName());
        if (path.getFileExtension() == null) {
            return null;
        }
        return CompareUI.getImage((String)path.getFileExtension());
    }

    public String getName() {
        return this.file.getName();
    }

    public String getType() {
        String fileExtension;
        if (this.type == ResourceType.FOLDER) {
            return "FOLDER";
        }
        if (this.type == ResourceType.FILE && (fileExtension = new Path(this.getName()).getFileExtension()) != null) {
            return fileExtension;
        }
        return "???";
    }

    public boolean isEditable() {
        return this.type == ResourceType.FILE;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        throw new UnsupportedOperationException();
    }

    public long getModificationDate() {
        try {
            return this.file.getModificationStamp();
        }
        catch (FileSystemException e) {
            return 0L;
        }
    }

    public void commit(IProgressMonitor monitor) throws FileSystemException {
        byte[] content = this.getContent();
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        this.file.setContents((IFileOptions)new FileOptions(false, this.lineDelimiter, this.encoding, this.properties), (InputStream)stream, new Shed(BackupDilemmaHandler.getDefault()), monitor);
    }

    public IShareable getShareable() {
        return this.file.getShareable();
    }
}

