/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateComputer;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.FetchedItems;
import com.ibm.team.scm.common.internal.ItemWithLinks;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileStateRemoteFunction
implements IRemoteFunction<FileState> {
    private ItemWithLinks<IVersionable> versionable;
    private StateId<IVersionable> versionableState;
    private ITeamRepository repo;

    public FileStateRemoteFunction(ITeamRepository repo, StateId<? extends IVersionable> versionableState) {
        this.versionableState = versionableState;
        this.repo = repo;
    }

    public FileState compute(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.fetchVersionable((IProgressMonitor)progress.newChild(90));
        return ClientFileStateFactory.create((ITeamRepository)this.repo, (IItemType)this.versionableState.getItemType(), this.versionable, (boolean)FileStateComputer.showVersionIdForCompare(), (IProgressMonitor)progress.newChild(10));
    }

    private synchronized void fetchVersionable(IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList toFetch = NewCollection.arrayList();
        toFetch.add(this.versionableState);
        FetchedItems result = RepoFetcher.fetchItemsWithLinks((ITeamRepository)this.repo, (Collection)toFetch, (IProgressMonitor)monitor);
        this.versionable = result.getItemWithLinks(this.versionableState);
    }
}

