/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.FetchedItems;
import com.ibm.team.scm.common.internal.ItemWithLinks;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class FileStateComputer {
    private ItemWithLinks<IVersionable> leftItem;
    private ItemWithLinks<IVersionable> rightItem;
    private StateId<IVersionable> leftState;
    private StateId<IVersionable> rightState;
    private ITeamRepository repo;

    public FileStateComputer(ITeamRepository repo, StateId<? extends IVersionable> leftState, StateId<? extends IVersionable> rightState) {
        this.repo = repo;
        this.leftState = leftState;
        this.rightState = rightState;
    }

    private synchronized void fetchItems(IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList toFetch = NewCollection.arrayList();
        toFetch.add(this.leftState);
        toFetch.add(this.rightState);
        FetchedItems result = RepoFetcher.fetchItemsWithLinks((ITeamRepository)this.repo, (Collection)toFetch, (IProgressMonitor)monitor);
        this.leftItem = result.getItemWithLinks(this.leftState);
        this.rightItem = result.getItemWithLinks(this.rightState);
    }

    public IRemoteFunction<FileState> getLeft() {
        return new IRemoteFunction<FileState>(){

            public FileState compute(IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                FileStateComputer.this.fetchItems((IProgressMonitor)progress.newChild(90));
                return ClientFileStateFactory.create((ITeamRepository)FileStateComputer.this.repo, (IItemType)FileStateComputer.this.leftState.getItemType(), (ItemWithLinks)FileStateComputer.this.leftItem, (boolean)FileStateComputer.showVersionIdForCompare(), (IProgressMonitor)progress.newChild(10));
            }
        };
    }

    public IRemoteFunction<FileState> getRight() {
        return new IRemoteFunction<FileState>(){

            public FileState compute(IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                FileStateComputer.this.fetchItems((IProgressMonitor)progress.newChild(90));
                return ClientFileStateFactory.create((ITeamRepository)FileStateComputer.this.repo, (IItemType)FileStateComputer.this.rightState.getItemType(), (ItemWithLinks)FileStateComputer.this.rightItem, (boolean)FileStateComputer.showVersionIdForCompare(), (IProgressMonitor)progress.newChild(10));
            }
        };
    }

    public static boolean showVersionIdForCompare() {
        IPreferenceStore store = RcpUiPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("pref_show_version_identifiers_compare");
    }
}

