/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IApplyAcceptedOperation;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalConflict;
import com.ibm.team.filesystem.client.IMarkAsMergedOperation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IResolveLocalConflictsAsMergedOperation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.compare.ComparePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.ImagePool;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.compare.AbstractCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateComputer;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FolderTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.InputStreamProviderTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.VersionableTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.util.StandardAutoResolveDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnApplyAcceptedUser;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnResolveAsMergedUser;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.FetchedItems;
import com.ibm.team.scm.common.internal.ItemWithLinks;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ConflictCompareEditorInput
extends AbstractCompareEditorInput
implements IResourceChangeListener {
    private IAbstractConflictItem conflict;
    private IFile localFile;
    private Image conflictsImage;
    private boolean runningAutoResolve;
    private boolean isEvilTwin = false;

    public ConflictCompareEditorInput(CompareConfiguration compareConfiguration, IAbstractConflictItem conflict, IWorkbenchPage page, boolean isExternal) {
        super(compareConfiguration, isExternal);
        this.conflict = conflict;
        this.setPage(page);
    }

    public IAbstractConflictItem getConflictedItem() {
        return this.conflict;
    }

    public String getTitle() {
        return this.conflict.getName(false);
    }

    protected String getFileName() {
        return this.getTitle();
    }

    @Override
    public void contentsCreated() {
        if (this.localFile != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        super.contentsCreated();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.localFile != null) {
            Shell shell;
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta = delta.findMember(this.localFile.getFullPath());
            }
            if (delta != null && ((delta.getKind() & 3) > 0 || (delta.getKind() & 4) > 0 && (delta.getFlags() & 0x40100) > 0) && (shell = this.getShell()) != null && !shell.isDisposed()) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ConflictCompareEditorInput.this.fireInputChange();
                    }
                });
            }
        }
    }

    @Override
    protected ITypedElement createLeftElement(IFile file) throws FileSystemException {
        this.localFile = file;
        return super.createLeftElement(this.localFile);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeLeft(IProgressMonitor monitor) throws CoreException, IOException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IShareable shareable = ComponentSyncUtil.findShareable((IAbstractConflictItem)this.conflict, (boolean)true, (IProgressMonitor)progress.newChild(1));
        String name = this.getFileName();
        if (shareable != null) {
            ITypedElement element = this.createLeftElement(shareable, (IProgressMonitor)progress.newChild(1));
            boolean isEvilTwin = this.isEvilTwin(shareable, (IProgressMonitor)progress.newChild(1));
            String label = isEvilTwin ? NLS.bind((String)Messages.SimpleConflictCompareEditorInput_10, (Object)name) : name;
            return new AbstractCompareEditorInput.TypedElementAndData(element, label, shareable);
        }
        if (this.conflict.getSelectedContributorState() == null) {
            String label;
            IVersionableHandle leftHandle = this.conflict.getSelectedEvilTwinState();
            boolean isEvilTwin = leftHandle != null;
            String string = label = isEvilTwin ? NLS.bind((String)Messages.SimpleConflictCompareEditorInput_10, (Object)name) : name;
            if (isEvilTwin) {
                this.isEvilTwin = isEvilTwin;
                return this.createTypedElementAndData(leftHandle, label, monitor);
            }
            return new AbstractCompareEditorInput.TypedElementAndData(this.createLeftElement(null, (IProgressMonitor)progress.newChild(1)), label, null);
        }
        String label = NLS.bind((String)Messages.ConflictCompareEditorInput_3, (Object)name);
        IVersionableHandle versionableHandle = this.conflict.getSelectedContributorState();
        return this.createTypedElementAndData(versionableHandle, label, monitor);
    }

    private AbstractCompareEditorInput.TypedElementAndData createTypedElementAndData(IVersionableHandle versionableHandle, String label, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = this.conflict.getComponentSyncContext().localTeamRepository();
        ItemWithLinks<IVersionable> itemWithLinks = this.fetchVersionableWithLinks(repo, versionableHandle, (IProgressMonitor)progress.newChild(90));
        IVersionable workingCopy = (IVersionable)((IVersionable)itemWithLinks.getItem()).getWorkingCopy();
        FileState fileState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)itemWithLinks.getItemType(), itemWithLinks, (boolean)FileStateComputer.showVersionIdForCompare(), (IProgressMonitor)progress.newChild(10));
        IInputStreamProvider inputStreamProvider = fileState.getContents();
        DisposableInputStreamProvider buffer = inputStreamProvider instanceof DisposableInputStreamProvider ? (DisposableInputStreamProvider)inputStreamProvider : TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)inputStreamProvider, (IProgressMonitor)monitor);
        VersionableTypedElement element = new VersionableTypedElement(this.conflict.getComponentSyncContext().getOutgoingTeamPlace(), (IComponentHandle)this.conflict.getComponentSyncContext().getComponent(), workingCopy, buffer);
        return new AbstractCompareEditorInput.TypedElementAndData(element, label, fileState, workingCopy);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeRight(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        String label;
        if (this.conflict.getProposedContributorState() != null) {
            String name = this.getFileName();
            label = NLS.bind((String)Messages.SimpleConflictCompareEditorInput_14, (Object)name);
        } else {
            label = Messages.SimpleConflictCompareEditorInput_15;
        }
        return this.compute(this.conflict.getProposedContributorState(), label, monitor);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeAncestor(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        String label = null;
        if (this.conflict.getCommonAncestorState() != null) {
            String name = this.getFileName();
            label = NLS.bind((String)Messages.SimpleConflictCompareEditorInput_16, (Object)name);
        }
        return this.compute(this.conflict.getCommonAncestorState(), label, monitor);
    }

    private FileState getFileState(IVersionableHandle versionableHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (versionableHandle == null) {
            return null;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = this.conflict.getComponentSyncContext().localTeamRepository();
        ItemWithLinks<IVersionable> versionableWithLinks = this.fetchVersionableWithLinks(repo, versionableHandle, (IProgressMonitor)progress.newChild(90));
        return ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)versionableWithLinks.getItemType(), versionableWithLinks, (boolean)FileStateComputer.showVersionIdForCompare(), (IProgressMonitor)progress.newChild(10));
    }

    private ItemWithLinks<IVersionable> fetchVersionableWithLinks(ITeamRepository repo, IVersionableHandle versionableHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        StateId versionableState = new StateId((IItemHandle)versionableHandle);
        ArrayList toFetch = NewCollection.arrayList();
        toFetch.add(versionableState);
        FetchedItems result = RepoFetcher.fetchItemsWithLinks((ITeamRepository)repo, (Collection)toFetch, (IProgressMonitor)monitor);
        return result.getItemWithLinks(versionableState);
    }

    private AbstractCompareEditorInput.TypedElementAndData compute(IVersionableHandle versionableHandle, String label, IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        FileState fileState = this.getFileState(versionableHandle, (IProgressMonitor)progress.newChild(1));
        ITypedElement element = this.createTypedElement(fileState, (IProgressMonitor)progress.newChild(1));
        return new AbstractCompareEditorInput.TypedElementAndData(element, label, fileState);
    }

    private ITypedElement createTypedElement(FileState fileState, IProgressMonitor monitor) throws IOException {
        Object element = fileState == null ? null : (fileState.getStateId().getItemType().equals(IFileItem.ITEM_TYPE) ? InputStreamProviderTypedElement.createTypedElement(fileState, monitor) : new FolderTypedElement(FileChangeEditorInput.getName(fileState)));
        return element;
    }

    @Override
    protected ComparePropertiesState createFilePropertyState(AbstractCompareEditorInput.TypedElementAndData left, AbstractCompareEditorInput.TypedElementAndData right, AbstractCompareEditorInput.TypedElementAndData ancestor, IProgressMonitor monitor) throws FileSystemException {
        IShareable shareable = left.getShareable();
        if (shareable != null) {
            return ComparePropertiesState.createFor((IShareable)shareable, (FileState)right.getFileState(), (FileState)ancestor.getFileState(), (IProgressMonitor)monitor);
        }
        if (left.getElement() instanceof VersionableTypedElement && left.getVersionable() != null) {
            return ((VersionableTypedElement)left.getElement()).createComparePropertiesState(left.getFileState(), right.getFileState(), ancestor.getFileState());
        }
        return ComparePropertiesState.createFor((FileState)left.getFileState(), (FileState)right.getFileState(), (FileState)ancestor.getFileState());
    }

    @Override
    protected void createContents2(Composite top) {
        if (this.conflict.getItem() instanceof ISymbolicLinkHandle && this.isCreateOrDelete()) {
            Composite resolveTrim = this.createResolveTrim(top);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)resolveTrim);
        } else if (!this.isExternal()) {
            String text = this.conflict.getItem().getItemType().equals(IFileItem.ITEM_TYPE) ? Messages.SimpleConflictCompareEditorInput_0 : (this.conflict.getItem().getItemType().equals(IFolder.ITEM_TYPE) ? Messages.ConflictCompareEditorInput_0 : Messages.ConflictCompareEditorInput_1);
            Composite mergeTrim = this.createMergeTrim(top, text);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)mergeTrim);
        }
        super.createContents2(top);
    }

    protected Composite createResolveTrim(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        this.createConflictsImage(composite);
        Label label = new Label(composite, 64);
        label.setText(Messages.ConflictCompareEditorInput_SYMBOLIC_LINK_CONFLICT);
        GridDataFactory.defaultsFor((Control)label).grab(true, false).applyTo((Control)label);
        Button resolveMineButton = new Button(composite, 8);
        resolveMineButton.setText(Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE);
        resolveMineButton.setToolTipText(Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE_TOOLTIP);
        resolveMineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictCompareEditorInput.this.resolveWithMine();
            }
        });
        Button resolveProposeButton = new Button(composite, 8);
        resolveProposeButton.setText(Messages.ConflictCompareEditorInput_RESOLVE_WITH_PROPOSED);
        resolveProposeButton.setToolTipText(Messages.ConflictCompareEditorInput_RESOLVE_WITH_PROPOSED_TOOLTIP);
        resolveProposeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictCompareEditorInput.this.resolveWithProposed();
            }
        });
        Point margins = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().margins(margins.x / 2, margins.y / 2).numColumns(4).generateLayout(composite);
        return composite;
    }

    protected Composite createMergeTrim(Composite parent, String text) {
        Composite composite = new Composite(parent, 2048);
        this.createConflictsImage(composite);
        Label label = new Label(composite, 64);
        label.setText(text);
        GridDataFactory.defaultsFor((Control)label).grab(true, false).applyTo((Control)label);
        Button autoMergeButton = new Button(composite, 8);
        autoMergeButton.setText(Messages.SimpleConflictCompareEditorInput_1);
        autoMergeButton.setToolTipText(Messages.SimpleConflictCompareEditorInput_2);
        autoMergeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictCompareEditorInput.this.autoResolve();
            }
        });
        Button resolveButton = new Button(composite, 8);
        resolveButton.setText(Messages.SimpleConflictCompareEditorInput_8);
        resolveButton.setToolTipText(Messages.SimpleConflictCompareEditorInput_9);
        resolveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictCompareEditorInput.this.resolveAsMerged();
            }
        });
        Point margins = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().margins(margins.x / 2, margins.y / 2).numColumns(4).generateLayout(composite);
        return composite;
    }

    private Label createConflictsImage(Composite parent) {
        Label imageLabel = new Label(parent, 0);
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.UNRESOLVED_OVRL;
        this.conflictsImage = new OverlayIcon(ImagePool.WORKSPACE, imageDescriptorArray, 132096).createImage(true);
        imageLabel.setImage(this.conflictsImage);
        GridDataFactory.defaultsFor((Control)imageLabel).align(1, 1).applyTo((Control)imageLabel);
        return imageLabel;
    }

    private void resolveWithMine() {
        final Shell shell = this.getShell();
        IWorkbenchPart part = this.getContainer().getWorkbenchPart();
        IOperationRunner runner = UIContext.createPartContext((IWorkbenchPart)part).getUserOperationRunner();
        runner.enqueue(Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE, (int)100);
                if (ConflictCompareEditorInput.this.conflict instanceof ILocalConflictItem) {
                    IResolveLocalConflictsAsMergedOperation removeOp = IOperationFactory.instance.getResolveLocalConflictsAsMergedOperation();
                    ILocalConflict descriptor = ((ILocalConflictItem)ConflictCompareEditorInput.this.conflict).getLocalConflict();
                    removeOp.addConflictToResolve(descriptor);
                    removeOp.run((IProgressMonitor)progress.newChild(90));
                } else if (ConflictCompareEditorInput.this.conflict instanceof IConflictItem) {
                    IComponentSyncContext context = ConflictCompareEditorInput.this.conflict.getComponentSyncContext();
                    IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                    ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                    WarnResolveAsMergedUser problemHandler = new WarnResolveAsMergedUser(shell, Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE);
                    Collection changes = ComponentConflictUtil.getChanges(Collections.singleton((IConflictItem)ConflictCompareEditorInput.this.conflict));
                    if (changes.isEmpty()) {
                        return;
                    }
                    try {
                        IMarkAsMergedOperation mergedOp = IOperationFactory.instance.getMarkAsMergedOperation((MarkAsMergedDilemmaHandler)problemHandler);
                        mergedOp.setContext(wc, conflictReport);
                        mergedOp.addChangesToResolve(changes);
                        mergedOp.run((IProgressMonitor)progress.newChild(90));
                        ConflictCompareEditorInput.this.closeEditor(true);
                    }
                    catch (FileSystemException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                }
            }
        });
    }

    private void resolveWithProposed() {
        final Shell shell = this.getShell();
        IWorkbenchPart part = this.getContainer().getWorkbenchPart();
        IOperationRunner runner = UIContext.createPartContext((IWorkbenchPart)part).getUserOperationRunner();
        runner.enqueue(Messages.ConflictCompareEditorInput_RESOLVE_WITH_PROPOSED, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                if (ConflictCompareEditorInput.this.conflict instanceof ILocalConflictItem) {
                    ILocalChange[] localChange;
                    Collection shareables = FileSystemCore.getSharingManager().findShareables((IComponentHandle)ConflictCompareEditorInput.this.conflict.getComponentSyncContext().getComponent(), ConflictCompareEditorInput.this.conflict.getItem(), monitor);
                    if (!shareables.isEmpty() && (localChange = new ILocalChange[]{((IShareable)shareables.iterator().next()).getChange(monitor)})[0] != null && localChange[0].getType() != 0) {
                        FileSystemCore.getSharingManager().getLocalChangeManager().undoChanges(localChange, IRepositoryResolver.EXISTING_SHARED, UndoDilemmaHandler.getDefault(), monitor);
                    }
                } else if (ConflictCompareEditorInput.this.conflict instanceof IConflictItem) {
                    IComponentSyncContext context = ConflictCompareEditorInput.this.conflict.getComponentSyncContext();
                    IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                    ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                    Set<IConflictItem> conflictItems = Collections.singleton((IConflictItem)ConflictCompareEditorInput.this.conflict);
                    Collection changes = ComponentConflictUtil.getChanges(conflictItems);
                    if (changes.isEmpty()) {
                        return;
                    }
                    try {
                        IApplyAcceptedOperation op = IOperationFactory.instance.getApplyAcceptedOperation((ApplyAcceptedDilemmaHandler)new WarnApplyAcceptedUser(shell, Messages.ConflictCompareEditorInput_RESOLVE_WITH_PROPOSED));
                        op.setContext(wc, conflictReport);
                        op.addChangesToResolve(changes);
                        op.run(monitor);
                        ConflictCompareEditorInput.this.closeEditor(true);
                    }
                    catch (FileSystemException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                }
            }
        });
    }

    private void resolveAsMerged() {
        final Shell shell = this.getShell();
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.SimpleConflictCompareEditorInput_17, (int)100);
                        if (ConflictCompareEditorInput.this.isDirty()) {
                            ConflictCompareEditorInput.this.saveChanges((IProgressMonitor)monitor.newChild(50));
                            ConflictCompareEditorInput.this.waitForSave();
                        } else {
                            monitor.setWorkRemaining(50);
                        }
                        shell.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPart part = ConflictCompareEditorInput.this.getContainer().getWorkbenchPart();
                                IOperationRunner runner = UIContext.createPartContext((IWorkbenchPart)part).getUserOperationRunner();
                                runner.enqueue(Messages.SimpleConflictCompareEditorInput_18, (Operation)new RepositoryOperation(){

                                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                                        try {
                                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SimpleConflictCompareEditorInput_19, (int)100);
                                            IComponentSyncContext context = ConflictCompareEditorInput.this.conflict.getComponentSyncContext();
                                            IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                                            ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                                            final boolean[] okToClose = new boolean[1];
                                            WarnResolveAsMergedUser problemHandler = new WarnResolveAsMergedUser(shell, Messages.SimpleConflictCompareEditorInput_20){
                                                private boolean prompted;
                                                {
                                                    super($anonymous0, $anonymous1);
                                                    this.prompted = false;
                                                }

                                                @Override
                                                public int unmergedChanges(Collection<ILogicalChange> changes) {
                                                    if (!changes.isEmpty() && !ConflictCompareEditorInput.this.isEvilTwin) {
                                                        final int[] result = new int[]{1};
                                                        if (PlatformUI.isWorkbenchRunning()) {
                                                            Display display = PlatformUI.getWorkbench().getDisplay();
                                                            display.syncExec(new Runnable(){

                                                                @Override
                                                                public void run() {
                                                                    MessageDialog dialog = new MessageDialog(shell, Messages.SimpleConflictCompareEditorInput_21, null, Messages.SimpleConflictCompareEditorInput_22, 4, new String[]{Messages.SimpleConflictCompareEditorInput_23, IDialogConstants.CANCEL_LABEL}, 1);
                                                                    int r = dialog.open();
                                                                    if (r == 0) {
                                                                        result[0] = 0;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        this.prompted = true;
                                                        return result[0];
                                                    }
                                                    return 0;
                                                }

                                                public int confirmMarkAsMerged(Collection<ILogicalChange> changes) {
                                                    int[] result = new int[]{1};
                                                    if (this.prompted) {
                                                        result[0] = 0;
                                                    } else if (PlatformUI.isWorkbenchRunning()) {
                                                        result[0] = ConflictCompareEditorInput.this.updateResult();
                                                        this.prompted = true;
                                                    }
                                                    if (result[0] == 0) {
                                                        okToClose[0] = true;
                                                    }
                                                    return result[0];
                                                }

                                                public void warnUnmergedRelatedArtifacts() {
                                                    Display display = PlatformUI.getWorkbench().getDisplay();
                                                    final String title = MessageDialogFactory.getTitleForType((int)4);
                                                    final String message = Messages.WarnResolveAsMergedUser_WarnMergedLinksDiffer;
                                                    display.syncExec(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            MessageDialog.openWarning((Shell)this.getShell(), (String)title, (String)message);
                                                        }
                                                    });
                                                }
                                            };
                                            if (ConflictCompareEditorInput.this.conflict instanceof ILocalConflictItem) {
                                                IResolveLocalConflictsAsMergedOperation removeOp = IOperationFactory.instance.getResolveLocalConflictsAsMergedOperation();
                                                ILocalConflict descriptor = ((ILocalConflictItem)ConflictCompareEditorInput.this.conflict).getLocalConflict();
                                                removeOp.addConflictToResolve(descriptor);
                                                removeOp.run((IProgressMonitor)progress.newChild(90));
                                                okToClose[0] = true;
                                            } else if (ConflictCompareEditorInput.this.conflict instanceof IConflictItem) {
                                                Collection changes = ComponentConflictUtil.getChanges(Collections.singletonList((IConflictItem)ConflictCompareEditorInput.this.conflict));
                                                IMarkAsMergedOperation mergedOp = IOperationFactory.instance.getMarkAsMergedOperation((MarkAsMergedDilemmaHandler)problemHandler);
                                                mergedOp.setContext(wc, conflictReport);
                                                mergedOp.addChangesToResolve(changes);
                                                mergedOp.run((IProgressMonitor)progress.newChild(90));
                                            } else {
                                                okToClose[0] = false;
                                            }
                                            if (okToClose[0]) {
                                                ConflictCompareEditorInput.this.closeEditor(true);
                                            }
                                        }
                                        catch (FileSystemException e) {
                                            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                                        }
                                    }
                                });
                            }
                        });
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            IStatus status = StatusUtil.newStatus((Object)this, (Throwable)e.getTargetException());
            StatusUtil.log((IStatus)status);
            ErrorDialog.openError((Shell)shell, (String)Messages.SimpleConflictCompareEditorInput_26, (String)Messages.SimpleConflictCompareEditorInput_27, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int updateResult() {
        final int[] result = new int[]{1};
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IPreferenceStore store = RcpUiPlugin.getDefault().getPreferenceStore();
                boolean prompt = store.getBoolean("pref_confirm_resolve_as_merged");
                if (!prompt) {
                    result[0] = 0;
                } else {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)ConflictCompareEditorInput.this.getShell(), (String)Messages.SimpleConflictCompareEditorInput_24, (String)Messages.SimpleConflictCompareEditorInput_25, (String)Messages.ConflictCompareEditorInput_2, (boolean)false, null, null);
                    int code = dialog.getReturnCode();
                    boolean toggle = dialog.getToggleState();
                    if (code == 0) {
                        result[0] = 0;
                        if (toggle) {
                            store.setValue("pref_confirm_resolve_as_merged", false);
                        }
                    }
                }
            }
        });
        return result[0];
    }

    private void autoResolve() {
        boolean result;
        final Shell shell = this.getShell();
        if (this.isDirty() && !(result = MessageDialog.openConfirm((Shell)shell, (String)Messages.SimpleConflictCompareEditorInput_3, (String)Messages.SimpleConflictCompareEditorInput_4))) {
            return;
        }
        final UIContext currentContext = UIContext.createPageContext((Shell)shell, (IWorkbenchPage)this.getPage());
        currentContext.getUserOperationRunner().enqueue(Messages.SimpleConflictCompareEditorInput_5, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (ConflictCompareEditorInput.this.isDirty()) {
                    try {
                        ConflictCompareEditorInput.this.saveChanges((IProgressMonitor)progress.newChild(5));
                        ConflictCompareEditorInput.this.waitForSave();
                    }
                    catch (CoreException e) {
                        final IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                        StatusUtil.log((IStatus)status);
                        currentContext.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ErrorDialog.openError((Shell)shell, null, null, (IStatus)status);
                            }
                        });
                        return;
                    }
                }
                try {
                    try {
                        StandardAutoResolveDilemmaHandler dilemmaHandler = new StandardAutoResolveDilemmaHandler(currentContext, false){

                            @Override
                            public int missingStorageMerger(Collection<IFailedAutoResolveRequest> unknownTypes, Collection<IFailedAutoResolveRequest> itemsWithNoHandlers, IProgressMonitor monitor) {
                                for (IFailedAutoResolveRequest request : unknownTypes) {
                                    request.setRetryMerge(true);
                                    request.defaultContentTypeMerger("org.eclipse.core.runtime.text");
                                }
                                for (IFailedAutoResolveRequest request : itemsWithNoHandlers) {
                                    request.setRetryMerge(true);
                                    request.defaultContentTypeMerger("org.eclipse.core.runtime.text");
                                }
                                return 0;
                            }
                        };
                        IAutoResolveConflictsOperation autoResolveOperation = IOperationFactory.instance.getAutoResolveConflictsOperation((AutoResolveConflictsDilemmaHandler)dilemmaHandler, IRepositoryResolver.EXISTING_SHARED);
                        autoResolveOperation.setFileContentMerger(FileSystemResourcesPlugin.getConfiguredExternalFileContentMerger());
                        IAbstractConflictItem conflict = ConflictCompareEditorInput.this.getConflictedItem();
                        IComponentSyncContext context = conflict.getComponentSyncContext();
                        IWorkspaceConnection connection = context.getWorkspaceSyncContext().getLocal();
                        ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                        if (conflict instanceof IConflictItem) {
                            autoResolveOperation.autoResolveConflict(connection, conflictReport, ((IConflictItem)conflict).getLogicalChange());
                            ConflictCompareEditorInput.this.runningAutoResolve = true;
                            autoResolveOperation.run((IProgressMonitor)progress.newChild(100));
                            final int successCount = autoResolveOperation.numberOfConflictsResolved();
                            currentContext.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (successCount == 0) {
                                        MessageDialog.openError((Shell)shell, (String)Messages.SimpleConflictCompareEditorInput_6, (String)Messages.SimpleConflictCompareEditorInput_7);
                                    } else {
                                        ConflictCompareEditorInput.this.closeEditor(false);
                                    }
                                }
                            });
                        } else if (conflict instanceof ILocalConflictItem) {
                            ILocalConflictItem localConflict = (ILocalConflictItem)conflict;
                            IStatus mergeResult = localConflict.performAutoMerge(monitor);
                            if (mergeResult.isOK()) {
                                IResolveLocalConflictsAsMergedOperation removeOp = IOperationFactory.instance.getResolveLocalConflictsAsMergedOperation();
                                ILocalConflict descriptor = localConflict.getLocalConflict();
                                removeOp.addConflictToResolve(descriptor);
                                removeOp.run((IProgressMonitor)progress);
                                ConflictCompareEditorInput.this.closeEditor(false);
                            } else {
                                currentContext.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog.openError((Shell)shell, (String)Messages.SimpleConflictCompareEditorInput_6, (String)Messages.SimpleConflictCompareEditorInput_7);
                                    }
                                });
                            }
                        }
                    }
                    catch (FileSystemException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                    catch (IOException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                }
                finally {
                    ConflictCompareEditorInput.this.runningAutoResolve = false;
                }
            }
        });
    }

    private boolean isEvilTwin(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        if (shareable != null) {
            IVersionableHandle remote = shareable.getRemote(monitor);
            return remote == null || !remote.sameItemId((IItemHandle)this.conflict.getItem());
        }
        return false;
    }

    @Override
    public void fireInputChange() {
        if (!this.runningAutoResolve) {
            super.fireInputChange();
        }
    }

    public boolean equals(Object other) {
        ConflictCompareEditorInput otherInput;
        IAbstractConflictItem conflictedItem;
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass() && (conflictedItem = (otherInput = (ConflictCompareEditorInput)other).getConflictedItem()) != null && this.conflict != null) {
            return conflictedItem.getItem().sameItemId((IItemHandle)this.conflict.getItem());
        }
        return false;
    }

    public int hashCode() {
        if (this.conflict != null) {
            return this.conflict.getItem().getItemId().hashCode();
        }
        return super.hashCode();
    }

    @Override
    public void handleDispose() {
        if (this.localFile != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (this.conflictsImage != null) {
            this.conflictsImage.dispose();
        }
        super.handleDispose();
    }

    protected void waitForSave() {
        Job[] jobs = Job.getJobManager().find((Object)LocalChangeManager.getInstance());
        int tries = 0;
        while (jobs.length != 0 && tries < 10) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                return;
            }
            jobs = Job.getJobManager().find((Object)LocalChangeManager.getInstance());
            ++tries;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFile.class) {
            return this.localFile;
        }
        return super.getAdapter(adapter);
    }
}

