/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.operations.ChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.compare.ComparePropertiesState;
import com.ibm.team.filesystem.rcp.core.internal.compare.ShareableComparePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.PropertyCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.properties.ChangeFilePropertiesUtil;
import com.ibm.team.filesystem.rcp.ui.internal.properties.PropertyNamespaceManager;
import com.ibm.team.filesystem.rcp.ui.internal.util.SCMPropertiesUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnChangeFileProperties;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.LoggedInRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.LinkUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Twistie;

public abstract class CompareFilePropertiesViewerPane
extends ViewForm {
    private static int LEFT = 0;
    private static int RIGHT = 1;
    private static int ANCESTOR = 2;
    static final String VALIDATION_KEY = "VALIDATION_KEY";
    private boolean propertiesDirty = false;
    private ComparePropertiesState fileProperties;
    private IWorkbenchPartSite site;
    private List<AbstractPropertyRenderer> renderers;
    private final CompareConfiguration compareConfiguration;
    private PartSiteJobRunner fRunner;
    private LoggedInRunner loggedInRunner;

    public CompareFilePropertiesViewerPane(final Composite parent, CompareConfiguration cc, ComparePropertiesState compareFileProperties, final IWorkbenchPartSite site, boolean fileStreamChanges) {
        super(parent, 0x800800);
        this.compareConfiguration = cc;
        this.fileProperties = compareFileProperties;
        this.site = site;
        final Display display = parent.getDisplay();
        this.fRunner = new PartSiteJobRunner(site, false){

            protected boolean reportProblem(final String opName, Operation op, final IStatus reason) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!parent.isDisposed()) {
                            IStatus adjustedReason = reason;
                            ErrorDialog.openError((Shell)site.getShell(), (String)NLS.bind((String)Messages.CompareFilePropertiesViewerPane_OperationError, (Object)opName), null, (IStatus)adjustedReason);
                        }
                    }
                });
                return false;
            }
        };
        this.loggedInRunner = new LoggedInRunner((IOperationRunner)this.fRunner);
        Composite leftArea = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).spacing(0, 0).extendedMargins(0, 0, 0, 0).applyTo(leftArea);
        final Twistie twistie = new Twistie(leftArea, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)twistie);
        Label title = new Label(leftArea, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)title);
        title.setText(Messages.CompareFilePropertiesViewerPane_0);
        this.setTopLeft((Control)leftArea);
        final ScrolledComposite sc = this.createRenderers(cc);
        Point size = sc.getContent().computeSize(-1, -1);
        sc.setMinSize(0, size.y);
        Point titleSize = leftArea.computeSize(-1, -1);
        final WidgetHeight sizer = new WidgetHeight(this, this.fileProperties.isFile() && fileStreamChanges, size.y + titleSize.y + 5){

            @Override
            public void update() {
                this.showPropertiesPane(sc, twistie, this, this.getContent() != null);
            }
        };
        parent.addListener(11, (Listener)sizer);
        this.showPropertiesPane(sc, twistie, sizer, this.fileProperties.hasDifference());
        this.listenForFilePropertyChanges();
        title.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                boolean isVisible = CompareFilePropertiesViewerPane.this.getContent() != null;
                CompareFilePropertiesViewerPane.this.showPropertiesPane(sc, twistie, sizer, !isVisible);
            }
        });
        twistie.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                boolean isVisible = CompareFilePropertiesViewerPane.this.getContent() != null;
                CompareFilePropertiesViewerPane.this.showPropertiesPane(sc, twistie, sizer, !isVisible);
            }
        });
        IAction copyRightToLeftAction = this.createCopyRightToLeftAction();
        ToolBar tb = new ToolBar((Composite)this, 0x800000);
        final ToolBarManager toolBarManager = new ToolBarManager(tb);
        this.setTopCenter((Control)tb);
        ActionContributionItem action = new ActionContributionItem(copyRightToLeftAction);
        copyRightToLeftAction.setEnabled(this.fileProperties.hasAncestor());
        action.setVisible(true);
        toolBarManager.add((IContributionItem)action);
        toolBarManager.update(true);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolBarManager.removeAll();
                toolBarManager.dispose();
            }
        });
        if (compareFileProperties instanceof ShareableComparePropertiesState) {
            this.fetchDisplayProperties(parent, (ShareableComparePropertiesState)compareFileProperties);
        }
    }

    private void fetchDisplayProperties(final Composite parent, final ShareableComparePropertiesState shareableState) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor progress) {
                    IShareable shareable = shareableState.getShareable();
                    IShare share = null;
                    try {
                        share = shareable.getShare(progress);
                    }
                    catch (FileSystemException fileSystemException) {
                        // empty catch block
                    }
                    if (share != null) {
                        final HashMap allDisplayValues = new HashMap();
                        for (AbstractPropertyRenderer r : CompareFilePropertiesViewerPane.this.renderers) {
                            if (!(r instanceof DisplayPropertyRenderer)) continue;
                            DisplayPropertyRenderer dr = (DisplayPropertyRenderer)r;
                            LinkedHashMap map = (LinkedHashMap)allDisplayValues.get(dr.propertyName);
                            if (map == null) {
                                map = new LinkedHashMap();
                                allDisplayValues.put(dr.propertyName, map);
                            }
                            dr.populateDisplayValues(map);
                        }
                        ISharingDescriptor desc = share.getSharingDescriptor();
                        final ITeamRepository repo = CompareFilePropertiesViewerPane.getTeamRepository(desc);
                        CompareFilePropertiesViewerPane.this.loggedInRunner.cancelAll();
                        CompareFilePropertiesViewerPane.this.loggedInRunner.enqueue(repo, Messages.CompareFilePropertiesViewerPane_25, (Operation)new RepositoryOperation(){

                            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                                SCMPropertiesUtil.populatePropertiesBG(allDisplayValues, repo, monitor);
                                try {
                                    SWTUtil.runOnce((Display)CompareFilePropertiesViewerPane.this.getDisplay(), (Control)parent, (Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            for (AbstractPropertyRenderer r : CompareFilePropertiesViewerPane.this.renderers) {
                                                if (!(r instanceof DisplayPropertyRenderer)) continue;
                                                DisplayPropertyRenderer dr = (DisplayPropertyRenderer)r;
                                                Map map = (Map)allDisplayValues.get(((DisplayPropertyRenderer)r).propertyName);
                                                dr.updateDisplayValues(map);
                                            }
                                        }
                                    });
                                }
                                catch (SWTException sWTException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e.getTargetException());
            StatusUtil.log((IStatus)status);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static ITeamRepository getTeamRepository(ISharingDescriptor desc) {
        return CompareFilePropertiesViewerPane.getTeamRepository(desc.getRepositoryId());
    }

    public static ITeamRepository getTeamRepository(UUID repositoryId) {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repositoryId.equals((Object)repository.getId())) {
                return repository;
            }
            ++n2;
        }
        return null;
    }

    private ScrolledComposite createRenderers(CompareConfiguration cc) {
        WidgetToolkit toolkit = WidgetToolkit.createFormToolkit();
        ScrolledComposite sc = new ScrolledComposite((Composite)this, 768);
        this.setContent((Control)sc);
        toolkit.adapt((Composite)sc);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        Composite composite = toolkit.createComposite((Composite)sc, 0);
        int columns = this.fileProperties.hasAncestor() ? 3 : 2;
        this.renderers = new ArrayList<AbstractPropertyRenderer>();
        if (this.fileProperties.isFile()) {
            this.renderers.add(new ExecutableBitRenderer());
            this.renderers.add(new ContentTypeRenderer());
            this.renderers.add(new LineDelimiterRenderer());
            this.renderers.add(new CharacterEncodingRenderer());
        } else if (this.fileProperties.isSymbolicLink()) {
            this.renderers.add(new LinkTargetRenderer());
            this.renderers.add(new LinkDirectoryTypeRenderer());
        }
        Set<String> properties = this.getPropertyNames();
        ArrayList<String> list = new ArrayList<String>(properties.size());
        list.addAll(properties);
        Collections.sort(list);
        PropertyNamespaceManager namespaceManager = PropertyNamespaceManager.getInstance();
        for (String propertyName : list) {
            if (namespaceManager.hasDisplayValue(propertyName)) {
                this.renderers.add(new DisplayPropertyRenderer(propertyName));
                continue;
            }
            this.renderers.add(new UserPropertyRenderer(propertyName));
        }
        if (this.anyExternalLinkDifferences()) {
            this.renderers.add(new ExternalLinksRenderer());
        }
        this.createFieldColumn(toolkit, composite, cc.getLeftLabel(null), this.renderers, LEFT, false);
        this.createFieldColumn(toolkit, composite, cc.getRightLabel(null), this.renderers, RIGHT, true);
        if (this.fileProperties.hasAncestor()) {
            this.createFieldColumn(toolkit, composite, cc.getAncestorLabel(null), this.renderers, ANCESTOR, true);
        }
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).numColumns(columns).equalWidth(true).applyTo(composite);
        sc.setContent((Control)composite);
        return sc;
    }

    void showPropertiesPane(ScrolledComposite sc, Twistie twistie, WidgetHeight sizer, boolean show) {
        this.setContent((Control)(show ? sc : null));
        twistie.setExpanded(show);
        if (show) {
            GridDataFactory.fillDefaults().grab(true, false).hint(-1, sizer.getHeight()).applyTo((Control)this);
        } else {
            GridDataFactory.fillDefaults().grab(true, false).hint(-1, -1).applyTo((Control)this);
        }
        this.getParent().layout();
    }

    private Set<String> getPropertyNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.fileProperties.hasLeft()) {
            result.addAll(this.fileProperties.getLeft().getProperties().keySet());
        }
        if (this.fileProperties.hasRight()) {
            result.addAll(this.fileProperties.getRight().getProperties().keySet());
        }
        return result;
    }

    private void listenForFilePropertyChanges() {
        final ComparePropertiesState.IChangeListener filePropertiesChangeListener = new ComparePropertiesState.IChangeListener(){

            public void handleChange(List<ComparePropertiesState.ChangeEvent> singletonList) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!CompareFilePropertiesViewerPane.this.isDisposed()) {
                            CompareFilePropertiesViewerPane.this.valueChanged(null);
                        }
                    }
                });
            }
        };
        this.fileProperties.addListener(filePropertiesChangeListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CompareFilePropertiesViewerPane.this.fileProperties.removeListener(filePropertiesChangeListener);
            }
        });
    }

    private boolean anyExternalLinkDifferences() {
        ExternalLinks rightLinks;
        if (!this.fileProperties.hasLeft()) {
            return this.fileProperties.hasRight() && !this.fileProperties.getRight().getExternalLinks().isEmpty();
        }
        if (!this.fileProperties.hasRight()) {
            return this.fileProperties.hasLeft() && !this.fileProperties.getLeft().getExternalLinks().isEmpty();
        }
        ExternalLinks leftLinks = this.fileProperties.getLeft().getExternalLinks();
        return !LinkUtils.areUnchanged((ExternalLinks)leftLinks, (ExternalLinks)(rightLinks = this.fileProperties.getRight().getExternalLinks()));
    }

    private IAction createCopyRightToLeftAction() {
        Action a = new Action(){

            public void run() {
                boolean isDirty = false;
                for (AbstractPropertyRenderer renderer : CompareFilePropertiesViewerPane.this.renderers) {
                    isDirty |= renderer.copyIncomingFromRightToLeft();
                }
                boolean oldDirty = CompareFilePropertiesViewerPane.this.propertiesDirty;
                CompareFilePropertiesViewerPane.this.propertiesDirty = isDirty;
                if (oldDirty != CompareFilePropertiesViewerPane.this.propertiesDirty) {
                    CompareFilePropertiesViewerPane.this.firePropertyChange(new PropertyChangeEvent((Object)this, "DIRTY_STATE", (Object)oldDirty, (Object)CompareFilePropertiesViewerPane.this.propertiesDirty));
                }
                this.setEnabled(false);
            }
        };
        Utilities.initAction((IAction)a, (ResourceBundle)ResourceBundle.getBundle("org.eclipse.compare.contentmergeviewer.TextMergeViewerResources"), (String)"action.CopyRightToLeft.");
        return a;
    }

    private void createFieldColumn(WidgetToolkit toolkit, Composite composite, String headerText, List<AbstractPropertyRenderer> renderers, int side, boolean hasSeparator) {
        Composite c;
        if (hasSeparator) {
            Composite column = toolkit.createComposite(composite, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)column);
            Label separator = toolkit.createSeparator(column, 512);
            GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)separator);
            c = toolkit.createComposite(column, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(column);
        } else {
            c = toolkit.createComposite(composite, 0);
        }
        Label header = toolkit.createLabel(c, headerText);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)header);
        for (AbstractPropertyRenderer renderer : renderers) {
            renderer.createField(toolkit, c, side);
        }
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(c);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)c);
    }

    protected void valueChanged(AbstractPropertyRenderer renderer) {
        boolean oldDirty = this.propertiesDirty;
        boolean isDirty = renderer != null && renderer.isDirty() ? true : this.isPropertiesDirty();
        this.propertiesDirty = isDirty;
        if (oldDirty != this.propertiesDirty) {
            this.firePropertyChange(new PropertyChangeEvent((Object)this, "DIRTY_STATE", (Object)oldDirty, (Object)this.propertiesDirty));
        }
    }

    private boolean isPropertiesDirty() {
        boolean isDirty = false;
        for (AbstractPropertyRenderer r : this.renderers) {
            isDirty |= r.isDirty();
        }
        return isDirty;
    }

    public boolean isDirty() {
        return this.propertiesDirty;
    }

    protected abstract void firePropertyChange(PropertyChangeEvent var1);

    public void flush(IProgressMonitor monitor) throws CoreException {
        if (!this.isDirty()) {
            return;
        }
        String newContentType = null;
        FileLineDelimiter newLineDelimiter = null;
        String linkTarget = null;
        boolean directoryLink = false;
        Boolean executable = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        for (AbstractPropertyRenderer renderer : this.renderers) {
            UserPropertyRenderer upr;
            AbstractPropertyRenderer ldr;
            if (renderer instanceof ExecutableBitRenderer) {
                ExecutableBitRenderer executableBitRenderer = (ExecutableBitRenderer)renderer;
                executable = executableBitRenderer.getValue();
                continue;
            }
            if (renderer instanceof LineDelimiterRenderer) {
                ldr = (LineDelimiterRenderer)renderer;
                newLineDelimiter = ((LineDelimiterRenderer)ldr).getValue();
                continue;
            }
            if (renderer instanceof ContentTypeRenderer) {
                ContentTypeRenderer ctr = (ContentTypeRenderer)renderer;
                newContentType = ctr.getValue();
                continue;
            }
            if (renderer instanceof CharacterEncodingRenderer) continue;
            if (renderer instanceof LinkTargetRenderer) {
                LinkTargetRenderer ltr = (LinkTargetRenderer)renderer;
                linkTarget = ltr.getValue();
                continue;
            }
            if (renderer instanceof LinkDirectoryTypeRenderer) {
                ldr = (LinkDirectoryTypeRenderer)renderer;
                directoryLink = ((LinkDirectoryTypeRenderer)ldr).getValue();
                continue;
            }
            if (!(renderer instanceof UserPropertyRenderer) || (upr = (UserPropertyRenderer)renderer).getValue() == null) continue;
            properties.put(upr.getName(), upr.getValue());
        }
        String contentType = newContentType;
        FileLineDelimiter lineDelimiter = newLineDelimiter;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CompareFilePropertiesViewerPane_13, (int)100);
        try {
            try {
                sub.beginTask(Messages.CompareFilePropertiesViewerPane_13, 100);
                WarnChangeFileProperties dilemmaHandler = new WarnChangeFileProperties(this.site.getShell(), Messages.CompareFilePropertiesViewerPane_14);
                this.fileProperties.updateState(executable, contentType, lineDelimiter, linkTarget, directoryLink, properties, (ChangePropertiesDilemmaHandler)dilemmaHandler, (IProgressMonitor)sub);
            }
            catch (TeamRepositoryException e) {
                throw new CoreException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
            }
        }
        finally {
            sub.done();
        }
    }

    private abstract class AbstractPropertyRenderer
    implements SelectionListener {
        protected Combo editableCombo;

        private AbstractPropertyRenderer() {
        }

        public Combo getEditableCombo() {
            return this.editableCombo;
        }

        public boolean copyIncomingFromRightToLeft() {
            if (!this.hasOutgoingChange() && this.hasIncomingChange() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight() && !this.isDirty()) {
                this.editableCombo.select(1);
                this.updateValueFromSelection();
                return true;
            }
            return false;
        }

        protected abstract void updateValueFromSelection();

        public void createField(WidgetToolkit toolkit, Composite composite, int side) {
            String fieldLabel = this.getFieldLabel();
            if (this.propertyPresent(side) || side == LEFT) {
                Label label = toolkit.createLabel(composite, fieldLabel);
                Color color = this.getColor(this.hasDifference(), this.isThreeWay(), this.hasIncomingChange(), this.hasOutgoingChange());
                if (color != null) {
                    label.setForeground(color);
                }
                if (fieldLabel.length() > 20) {
                    GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)label);
                    Label spacer = toolkit.createLabel(composite, null);
                    GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)spacer);
                } else {
                    GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
                }
                String defaultValue = this.getValueText(side);
                Combo combo = this.createCombo(toolkit, composite, defaultValue, this.getTooltip());
                combo.setEnabled(side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.isEditable());
                this.handleFieldCreated(combo, side);
                this.createDecoration(combo);
            } else {
                Label spacer1;
                if (fieldLabel.length() > 20) {
                    spacer1 = toolkit.createLabel(composite, null);
                    GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)spacer1);
                    Label spacer2 = toolkit.createLabel(composite, null);
                    GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)spacer2);
                } else {
                    spacer1 = toolkit.createLabel(composite, null);
                    GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)spacer1);
                }
                Combo combo = this.createCombo(toolkit, composite, "", "");
                combo.setEnabled(false);
                combo.setVisible(false);
            }
        }

        protected void createDecoration(Combo combo) {
        }

        protected boolean propertyPresent(int side) {
            return true;
        }

        protected Combo createCombo(WidgetToolkit toolkit, Composite composite, String firstItem, String tooltip) {
            Combo combo = new Combo(composite, 12);
            toolkit.adapt((Control)combo, false, false);
            combo.add(firstItem);
            combo.select(0);
            combo.setToolTipText(tooltip);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)combo);
            return combo;
        }

        protected void handleFieldCreated(Combo combo, int side) {
            if (side == LEFT) {
                this.editableCombo = combo;
                this.editableCombo.addSelectionListener((SelectionListener)this);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        protected abstract String getTooltip();

        protected abstract String getFieldLabel();

        protected final Color getColor(boolean hasDifference, boolean isThreeWay, boolean hasIncomingChange, boolean hasOutgoingChange) {
            Color RED = CompareFilePropertiesViewerPane.this.getDisplay().getSystemColor(3);
            Color BLUE = CompareFilePropertiesViewerPane.this.getDisplay().getSystemColor(9);
            Color BLACK = CompareFilePropertiesViewerPane.this.getDisplay().getSystemColor(2);
            Color GRAY = CompareFilePropertiesViewerPane.this.getDisplay().getSystemColor(15);
            if (!isThreeWay && hasDifference) {
                return BLACK;
            }
            if (isThreeWay) {
                if (hasIncomingChange && hasOutgoingChange) {
                    return RED;
                }
                if (hasIncomingChange) {
                    return BLUE;
                }
                if (hasOutgoingChange) {
                    return BLACK;
                }
            }
            return GRAY;
        }

        protected abstract String getValueText(int var1);

        protected boolean isThreeWay() {
            return CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor();
        }

        protected abstract boolean hasOutgoingChange();

        protected abstract boolean hasIncomingChange();

        protected abstract boolean hasDifference();

        public abstract boolean isDirty();
    }

    private class CharacterEncodingRenderer
    extends AbstractPropertyRenderer {
        private String fCharacterEncoding = "";

        private CharacterEncodingRenderer() {
        }

        public String getCharacterEncoding() {
            return this.fCharacterEncoding;
        }

        @Override
        protected void handleFieldCreated(Combo combo, int side) {
            super.handleFieldCreated(combo, side);
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                String leftEncoding;
                this.fCharacterEncoding = leftEncoding = CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getCharacterEncoding();
                combo.setData(this.getValueText(side), (Object)leftEncoding);
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasRight() && this.hasDifference()) {
                    String rightEncoding = CompareFilePropertiesViewerPane.this.fileProperties.getRight().getCharacterEncoding();
                    combo.add(rightEncoding);
                    combo.setData(rightEncoding, (Object)rightEncoding);
                }
                if (this.isThreeWay() && this.hasOutgoingChange()) {
                    String ancestorEncoding = CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getCharacterEncoding();
                    combo.add(ancestorEncoding);
                    combo.setData(ancestorEncoding, (Object)ancestorEncoding);
                }
            }
            combo.setEnabled(false);
        }

        @Override
        protected String getFieldLabel() {
            return Messages.CompareFilePropertiesViewerPane_CharacterEncodingRenderer_Label;
        }

        @Override
        protected String getTooltip() {
            return Messages.CompareFilePropertiesViewerPane_CharacterEncodingRenderer_Tooltip;
        }

        @Override
        protected String getValueText(int side) {
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getCharacterEncoding();
            }
            if (side == RIGHT && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getRight().getCharacterEncoding();
            }
            if (side == ANCESTOR && CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getCharacterEncoding();
            }
            return "";
        }

        @Override
        protected boolean hasOutgoingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasOriginal() && !CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getCharacterEncoding().equals(CompareFilePropertiesViewerPane.this.fileProperties.getOriginal().getCharacterEncoding()) || CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && !CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getCharacterEncoding().equals(CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getCharacterEncoding());
            }
            return false;
        }

        @Override
        protected boolean hasIncomingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return !CompareFilePropertiesViewerPane.this.fileProperties.getRight().getCharacterEncoding().equals(CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getCharacterEncoding());
            }
            return false;
        }

        @Override
        protected boolean hasDifference() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return !CompareFilePropertiesViewerPane.this.fileProperties.getRight().getCharacterEncoding().equals(CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getCharacterEncoding());
            }
            return false;
        }

        public void widgetSelected(SelectionEvent e) {
        }

        @Override
        public boolean isDirty() {
            return false;
        }

        @Override
        protected void updateValueFromSelection() {
            this.fCharacterEncoding = (String)this.getEditableCombo().getData(this.getEditableCombo().getText());
        }
    }

    private class ContentTypeRenderer
    extends AbstractPropertyRenderer {
        String value;

        private ContentTypeRenderer() {
        }

        @Override
        protected String getFieldLabel() {
            return Messages.CompareFilePropertiesViewerPane_4;
        }

        @Override
        protected String getTooltip() {
            return Messages.CompareFilePropertiesViewerPane_5;
        }

        @Override
        protected void handleFieldCreated(Combo combo, int side) {
            super.handleFieldCreated(combo, side);
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                String type;
                this.value = CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getContentType();
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasRight() && this.hasDifference() && (type = CompareFilePropertiesViewerPane.this.fileProperties.getRight().getContentType()) != null) {
                    combo.add(type);
                }
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && this.hasOutgoingChange() && (type = CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getContentType()) != null) {
                    combo.add(type);
                }
            }
        }

        private String getValueText(String string) {
            return string == null ? Messages.CompareFilePropertiesViewerPane_10 : string;
        }

        @Override
        protected String getValueText(int side) {
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getContentType());
            }
            if (side == RIGHT && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getRight().getContentType());
            }
            if (side == ANCESTOR && CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getContentType());
            }
            return this.getValueText(null);
        }

        @Override
        protected boolean hasOutgoingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasOriginal() && !NullUtil.equals((Object)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getContentType(), (Object)CompareFilePropertiesViewerPane.this.fileProperties.getOriginal().getContentType()) || CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && !NullUtil.equals((Object)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getContentType(), (Object)CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getContentType());
            }
            return false;
        }

        @Override
        protected boolean hasIncomingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return !NullUtil.equals((Object)CompareFilePropertiesViewerPane.this.fileProperties.getRight().getContentType(), (Object)CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getContentType());
            }
            return false;
        }

        @Override
        protected boolean hasDifference() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return !NullUtil.equals((Object)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getContentType(), (Object)CompareFilePropertiesViewerPane.this.fileProperties.getRight().getContentType());
            }
            return false;
        }

        public void widgetSelected(SelectionEvent e) {
            Combo editableCombo = this.getEditableCombo();
            this.value = editableCombo.getText().trim().toLowerCase();
            ControlDecoration decoration = (ControlDecoration)editableCombo.getData(CompareFilePropertiesViewerPane.VALIDATION_KEY);
            if (editableCombo.isEnabled() && !ChangePropertiesOperation.validMimeType((String)this.value)) {
                decoration.setDescriptionText(Messages.bind((String)Messages.CompareFilePropertiesViewerPane_24, (Object)this.value));
                decoration.show();
            } else {
                decoration.hide();
            }
            CompareFilePropertiesViewerPane.this.valueChanged(this);
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isDirty() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return !NullUtil.equals((Object)this.value, (Object)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getContentType());
            }
            return false;
        }

        @Override
        protected void updateValueFromSelection() {
            this.value = this.getEditableCombo().getText();
        }

        @Override
        protected void createDecoration(Combo combo) {
            String value = combo.getText().trim().toLowerCase();
            if (Messages.CompareFilePropertiesViewerPane_10.equals(value)) {
                return;
            }
            ControlDecoration decoration = new ControlDecoration((Control)combo, 16384);
            decoration.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            decoration.setShowHover(true);
            combo.setData(CompareFilePropertiesViewerPane.VALIDATION_KEY, (Object)decoration);
            decoration.hide();
            if (combo.isEnabled() && !ChangePropertiesOperation.validMimeType((String)value)) {
                decoration.setDescriptionText(Messages.bind((String)Messages.CompareFilePropertiesViewerPane_24, (Object)value));
                decoration.show();
            }
        }
    }

    private class DisplayPropertyRenderer
    extends UserPropertyRenderer {
        private Combo combo;

        public DisplayPropertyRenderer(String propertyName) {
            super(propertyName);
            this.combo = null;
        }

        public void populateDisplayValues(Map<String, String> displayValues) {
            Combo[] combos;
            Combo[] comboArray = combos = new Combo[]{this.getEditableCombo(), this.combo};
            int n = combos.length;
            int n2 = 0;
            while (n2 < n) {
                Combo c = comboArray[n2];
                if (c != null) {
                    String[] items;
                    String[] stringArray = items = c.getItems();
                    int n3 = items.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String item = stringArray[n4];
                        displayValues.put(item, item);
                        ++n4;
                    }
                }
                ++n2;
            }
        }

        public void updateDisplayValues(Map<String, String> displayValues) {
            Combo[] combos;
            Combo[] comboArray = combos = new Combo[]{this.getEditableCombo(), this.combo};
            int n = combos.length;
            int n2 = 0;
            while (n2 < n) {
                Combo c = comboArray[n2];
                String[] items = c.getItems();
                int i = 0;
                String[] stringArray = items;
                int n3 = items.length;
                int n4 = 0;
                while (n4 < n3) {
                    String item = stringArray[n4];
                    String displayValue = displayValues.get(item);
                    c.setData(displayValue, (Object)c.getItem(i));
                    c.setItem(i++, displayValue);
                    ++n4;
                }
                ++n2;
            }
        }

        @Override
        protected void handleFieldCreated(Combo combo, int side) {
            super.handleFieldCreated(combo, side);
            if (side == RIGHT && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                this.combo = combo;
            }
        }
    }

    private class ExecutableBitRenderer
    extends AbstractPropertyRenderer {
        boolean executable = false;
        int falseIndex = -1;
        int trueIndex = -1;

        private ExecutableBitRenderer() {
        }

        @Override
        protected void handleFieldCreated(Combo combo, int side) {
            super.handleFieldCreated(combo, side);
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                if (combo.getItem(0).equals(this.getValueText(true))) {
                    this.trueIndex = 0;
                    this.falseIndex = 1;
                    combo.add(this.getValueText(false));
                } else {
                    this.trueIndex = 1;
                    this.falseIndex = 0;
                    combo.add(this.getValueText(true));
                }
                combo.select(CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isExectuable() ? this.trueIndex : this.falseIndex);
            }
        }

        @Override
        protected String getValueText(int side) {
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isExectuable());
            }
            if (side == RIGHT && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getRight().isExectuable());
            }
            if (side == ANCESTOR && CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().isExectuable());
            }
            return this.getValueText(false);
        }

        private String getValueText(boolean isExecutable) {
            this.executable = isExecutable;
            return isExecutable ? Messages.CompareFilePropertiesViewerPane_8 : Messages.CompareFilePropertiesViewerPane_9;
        }

        private Boolean getValue() {
            return this.executable;
        }

        @Override
        protected String getFieldLabel() {
            return Messages.CompareFilePropertiesViewerPane_3;
        }

        @Override
        protected boolean hasOutgoingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasOriginal() && CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isExectuable() != CompareFilePropertiesViewerPane.this.fileProperties.getOriginal().isExectuable() || CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isExectuable() != CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().isExectuable();
            }
            return false;
        }

        @Override
        protected boolean hasIncomingChange() {
            if (this.isThreeWay() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getRight().isExectuable() ^ CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().isExectuable();
            }
            return false;
        }

        @Override
        protected boolean hasDifference() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getRight().isExectuable() ^ CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isExectuable();
            }
            return false;
        }

        @Override
        protected String getTooltip() {
            return Messages.CompareFilePropertiesViewerPane_1;
        }

        @Override
        protected void updateValueFromSelection() {
            this.executable = Messages.CompareFilePropertiesViewerPane_8.equals(this.getEditableCombo().getText());
        }

        @Override
        public boolean isDirty() {
            return CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isExectuable() != this.executable;
        }

        public void widgetSelected(SelectionEvent e) {
            this.executable = Messages.CompareFilePropertiesViewerPane_8.equals(this.getEditableCombo().getText());
            CompareFilePropertiesViewerPane.this.valueChanged(this);
        }
    }

    private class ExternalLinksRenderer
    extends AbstractPropertyRenderer {
        private ExternalLinksRenderer() {
        }

        public void widgetSelected(SelectionEvent event) {
        }

        @Override
        protected void updateValueFromSelection() {
            assert (false) : "Value cannot be changed";
        }

        @Override
        protected String getTooltip() {
            return Messages.CompareFilePropertiesViewerPane_RelatedArtifactsChangeToolTip;
        }

        @Override
        protected String getFieldLabel() {
            return Messages.CompareFilePropertiesViewerPane_RelatedArtifactsLabel;
        }

        @Override
        protected String getValueText(int side) {
            if (side == LEFT) {
                return Messages.CompareFilePropertiesViewerPane_RelatedArtifactsChangedMessage;
            }
            return "";
        }

        @Override
        protected boolean hasOutgoingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                ExternalLinks leftLinks = CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getExternalLinks();
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasOriginal()) {
                    ExternalLinks originalLinks = CompareFilePropertiesViewerPane.this.fileProperties.getOriginal().getExternalLinks();
                    return !LinkUtils.areUnchanged((ExternalLinks)leftLinks, (ExternalLinks)originalLinks);
                }
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor()) {
                    ExternalLinks ancestorLinks = CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getExternalLinks();
                    return !LinkUtils.areUnchanged((ExternalLinks)leftLinks, (ExternalLinks)ancestorLinks);
                }
            }
            return false;
        }

        @Override
        protected boolean hasIncomingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                ExternalLinks ancestorLinks;
                ExternalLinks rightLinks = CompareFilePropertiesViewerPane.this.fileProperties.getRight().getExternalLinks();
                return !LinkUtils.areUnchanged((ExternalLinks)rightLinks, (ExternalLinks)(ancestorLinks = CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getExternalLinks()));
            }
            return false;
        }

        @Override
        protected boolean hasDifference() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                ExternalLinks rightLinks;
                ExternalLinks leftLinks = CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getExternalLinks();
                return !LinkUtils.areUnchanged((ExternalLinks)leftLinks, (ExternalLinks)(rightLinks = CompareFilePropertiesViewerPane.this.fileProperties.getRight().getExternalLinks()));
            }
            return false;
        }

        @Override
        public boolean isDirty() {
            return false;
        }

        @Override
        protected boolean propertyPresent(int side) {
            return side == LEFT;
        }
    }

    private class LineDelimiterRenderer
    extends AbstractPropertyRenderer {
        private FileLineDelimiter value;

        private LineDelimiterRenderer() {
        }

        @Override
        protected void handleFieldCreated(Combo combo, int side) {
            super.handleFieldCreated(combo, side);
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                String text;
                this.value = CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getLineDelimiter();
                FileLineDelimiter lld = CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getLineDelimiter();
                combo.setData(this.getValueText(side), (Object)lld);
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasRight() && this.hasDifference()) {
                    FileLineDelimiter rld = CompareFilePropertiesViewerPane.this.fileProperties.getRight().getLineDelimiter();
                    text = this.getValueText(rld);
                    combo.add(text);
                    combo.setData(text, (Object)rld);
                }
                if (this.isThreeWay() && this.hasOutgoingChange()) {
                    FileLineDelimiter ald = CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getLineDelimiter();
                    text = this.getValueText(ald);
                    combo.add(text);
                    combo.setData(text, (Object)ald);
                }
            }
        }

        @Override
        protected String getFieldLabel() {
            return Messages.CompareFilePropertiesViewerPane_6;
        }

        @Override
        protected String getTooltip() {
            return Messages.CompareFilePropertiesViewerPane_7;
        }

        @Override
        protected String getValueText(int side) {
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getLineDelimiter());
            }
            if (side == RIGHT && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getRight().getLineDelimiter());
            }
            if (side == ANCESTOR && CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getLineDelimiter());
            }
            return this.getValueText(null);
        }

        private String getValueText(FileLineDelimiter delimiter) {
            return ChangeFilePropertiesUtil.delimiterToString(delimiter);
        }

        @Override
        protected boolean hasOutgoingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasOriginal() && CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getLineDelimiter() != CompareFilePropertiesViewerPane.this.fileProperties.getOriginal().getLineDelimiter() || CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getLineDelimiter() != CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getLineDelimiter();
            }
            return false;
        }

        @Override
        protected boolean hasIncomingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getRight().getLineDelimiter() != CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getLineDelimiter();
            }
            return false;
        }

        @Override
        protected boolean hasDifference() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getRight().getLineDelimiter() != CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getLineDelimiter();
            }
            return false;
        }

        public void widgetSelected(SelectionEvent e) {
            this.value = (FileLineDelimiter)this.getEditableCombo().getData(this.getEditableCombo().getText());
            CompareFilePropertiesViewerPane.this.valueChanged(this);
        }

        public FileLineDelimiter getValue() {
            return this.value;
        }

        @Override
        public boolean isDirty() {
            return CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && this.value != null && !CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getLineDelimiter().equals((Object)this.value);
        }

        @Override
        protected void updateValueFromSelection() {
            this.value = (FileLineDelimiter)this.getEditableCombo().getData(this.getEditableCombo().getText());
        }
    }

    private class LinkDirectoryTypeRenderer
    extends AbstractPropertyRenderer {
        boolean initialized = false;
        boolean value = false;

        private LinkDirectoryTypeRenderer() {
        }

        @Override
        protected void handleFieldCreated(Combo combo, int side) {
            super.handleFieldCreated(combo, side);
            if (side == LEFT) {
                this.value = CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isDirectoryLink();
                this.initialized = true;
                combo.add(this.getValueText(!CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isDirectoryLink()), 1);
                combo.select(0);
            }
        }

        @Override
        protected String getValueText(int side) {
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isDirectoryLink());
            }
            if (side == RIGHT && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getRight().isDirectoryLink());
            }
            if (side == ANCESTOR && CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor()) {
                return this.getValueText(CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().isDirectoryLink());
            }
            return this.getValueText(false);
        }

        private String getValueText(boolean isDirectoryLink) {
            return isDirectoryLink ? Messages.CompareFilePropertiesViewerPane_8 : Messages.CompareFilePropertiesViewerPane_9;
        }

        @Override
        protected String getFieldLabel() {
            return Messages.CompareFilePropertiesViewerPane_22;
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        protected boolean hasOutgoingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasOriginal() && CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isDirectoryLink() != CompareFilePropertiesViewerPane.this.fileProperties.getOriginal().isDirectoryLink() || CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isDirectoryLink() != CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().isDirectoryLink();
            }
            return false;
        }

        @Override
        protected boolean hasIncomingChange() {
            if (this.isThreeWay() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getRight().isDirectoryLink() ^ CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().isDirectoryLink();
            }
            return false;
        }

        @Override
        protected boolean hasDifference() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getRight().isDirectoryLink() ^ CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isDirectoryLink();
            }
            return false;
        }

        @Override
        protected String getTooltip() {
            return Messages.CompareFilePropertiesViewerPane_23;
        }

        public void widgetSelected(SelectionEvent e) {
            this.value = this.getEditableCombo().getSelectionIndex() == 0;
            CompareFilePropertiesViewerPane.this.valueChanged(this);
        }

        @Override
        public boolean isDirty() {
            return CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && this.initialized && CompareFilePropertiesViewerPane.this.fileProperties.getLeft().isDirectoryLink() != this.value;
        }

        @Override
        protected void updateValueFromSelection() {
            this.value = this.getEditableCombo().getSelectionIndex() == 0;
        }
    }

    private class LinkTargetRenderer
    extends AbstractPropertyRenderer {
        private String value;

        private LinkTargetRenderer() {
        }

        @Override
        protected void handleFieldCreated(Combo combo, int side) {
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                String target;
                this.value = CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getTarget();
                if (this.value != null) {
                    combo.setData(this.getValueText(LEFT), (Object)this.value);
                }
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasRight() && this.hasDifference()) {
                    target = CompareFilePropertiesViewerPane.this.fileProperties.getRight().getTarget();
                    combo.add(target);
                    combo.setData(target, (Object)target);
                }
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && this.hasOutgoingChange()) {
                    target = CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getTarget();
                    combo.add(target);
                    combo.setData(target, (Object)target);
                }
            }
            super.handleFieldCreated(combo, side);
        }

        public void widgetSelected(SelectionEvent e) {
            String text = this.getEditableCombo().getText();
            this.value = (String)this.getEditableCombo().getData(text);
            CompareFilePropertiesViewerPane.this.valueChanged(this);
        }

        @Override
        protected void updateValueFromSelection() {
            this.value = (String)this.getEditableCombo().getData(this.getEditableCombo().getText());
        }

        @Override
        protected String getTooltip() {
            return Messages.CompareFilePropertiesViewerPane_19;
        }

        @Override
        protected String getFieldLabel() {
            return Messages.CompareFilePropertiesViewerPane_20;
        }

        @Override
        protected String getValueText(int side) {
            if (side == LEFT) {
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                    return CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getTarget();
                }
            } else if (side == RIGHT) {
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                    return CompareFilePropertiesViewerPane.this.fileProperties.getRight().getTarget();
                }
            } else if (side == ANCESTOR && CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getTarget();
            }
            return "";
        }

        @Override
        protected boolean hasOutgoingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasOriginal() && !NullUtil.equals((Object)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getTarget(), (Object)CompareFilePropertiesViewerPane.this.fileProperties.getOriginal().getTarget()) || CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && !NullUtil.equals((Object)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getTarget(), (Object)CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getTarget());
            }
            return false;
        }

        @Override
        protected boolean hasIncomingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return !NullUtil.equals((Object)CompareFilePropertiesViewerPane.this.fileProperties.getRight().getTarget(), (Object)CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getTarget());
            }
            return false;
        }

        @Override
        protected boolean hasDifference() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return !NullUtil.equals((Object)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getTarget(), (Object)CompareFilePropertiesViewerPane.this.fileProperties.getRight().getTarget());
            }
            return false;
        }

        @Override
        public boolean isDirty() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return !NullUtil.equals((Object)this.value, (Object)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getTarget());
            }
            return false;
        }

        public String getValue() {
            return this.value;
        }
    }

    private class UserPropertyRenderer
    extends AbstractPropertyRenderer {
        protected String propertyName;
        private String value;

        public UserPropertyRenderer(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        protected String getTooltip() {
            return NLS.bind((String)Messages.CompareFilePropertiesViewerPane_2, (Object)this.propertyName);
        }

        @Override
        protected String getFieldLabel() {
            return NLS.bind((String)Messages.CompareFilePropertiesViewerPane_15, (Object)PropertyNamespaceManager.getInstance().getDisplayLabel(this.propertyName));
        }

        @Override
        protected void handleFieldCreated(Combo combo, int side) {
            super.handleFieldCreated(combo, side);
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                String va;
                String key;
                String vr;
                this.value = (String)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getProperties().get(this.propertyName);
                if (this.value != null) {
                    combo.setData(this.getValueText(LEFT), (Object)this.value);
                }
                boolean hasRightValue = false;
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasRight() && this.hasDifference() && (vr = (String)CompareFilePropertiesViewerPane.this.fileProperties.getRight().getProperties().get(this.propertyName)) != null) {
                    key = this.asShortText(vr);
                    combo.add(key);
                    combo.setData(key, (Object)vr);
                    hasRightValue = true;
                }
                if (!hasRightValue) {
                    combo.add(Messages.CompareFilePropertiesViewerPane_18);
                }
                if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && this.hasOutgoingChange() && (va = (String)CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getProperties().get(this.propertyName)) != null) {
                    key = this.asShortText(va);
                    combo.add(key);
                    combo.setData(key, (Object)va);
                }
                if (this.hasConflict() || this.hasDifference() && this.valueHasMultipleLines()) {
                    combo.add(this.getEditActionLabel());
                }
            }
        }

        private boolean valueHasMultipleLines() {
            return this.value != null && this.value.indexOf(10) != -1;
        }

        private boolean hasConflict() {
            return this.hasDifference() && this.hasOutgoingChange() && this.hasIncomingChange();
        }

        private String getEditActionLabel() {
            return Messages.CompareFilePropertiesViewerPane_17;
        }

        @Override
        protected String getValueText(int side) {
            if (side == LEFT && CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                String value = (String)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getProperties().get(this.propertyName);
                if (value == null) {
                    if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getProperties().get(this.propertyName) != null) {
                        return this.getDeletedValueIndicator();
                    }
                    return this.getEmptyValueIndicator();
                }
                return this.asShortText(value);
            }
            if (side == RIGHT && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                String value = (String)CompareFilePropertiesViewerPane.this.fileProperties.getRight().getProperties().get(this.propertyName);
                if (value == null) {
                    if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getProperties().get(this.propertyName) != null) {
                        return this.getDeletedValueIndicator();
                    }
                    return this.getEmptyValueIndicator();
                }
                return this.asShortText(value);
            }
            if (side == ANCESTOR && CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor()) {
                String value = (String)CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getProperties().get(this.propertyName);
                if (value == null) {
                    return this.getEmptyValueIndicator();
                }
                return this.asShortText(value);
            }
            return this.getEmptyValueIndicator();
        }

        private String getDeletedValueIndicator() {
            return Messages.CompareFilePropertiesViewerPane_21;
        }

        private String getEmptyValueIndicator() {
            return Messages.CompareFilePropertiesViewerPane_16;
        }

        protected String asShortText(String text) {
            return SCMPropertiesUtil.getShortValue(text, 32);
        }

        @Override
        protected boolean hasOutgoingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasOriginal() && !NullUtil.equals(CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getProperties().get(this.propertyName), CompareFilePropertiesViewerPane.this.fileProperties.getOriginal().getProperties().get(this.propertyName)) || CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && !NullUtil.equals(CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getProperties().get(this.propertyName), CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getProperties().get(this.propertyName));
            }
            return false;
        }

        @Override
        protected boolean hasIncomingChange() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return !NullUtil.equals(CompareFilePropertiesViewerPane.this.fileProperties.getRight().getProperties().get(this.propertyName), CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getProperties().get(this.propertyName));
            }
            return false;
        }

        @Override
        protected boolean hasDifference() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                return !NullUtil.equals(CompareFilePropertiesViewerPane.this.fileProperties.getRight().getProperties().get(this.propertyName), CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getProperties().get(this.propertyName));
            }
            return false;
        }

        public void widgetSelected(SelectionEvent e) {
            String text = this.getEditableCombo().getText();
            if (text.equals(this.getEditActionLabel())) {
                String newValue = this.openEditDialog();
                if (newValue == null) {
                    if (this.value == null) {
                        this.getEditableCombo().select(0);
                    } else {
                        this.getEditableCombo().setText(this.asShortText(this.value));
                    }
                } else {
                    String key = this.asShortText(newValue);
                    this.getEditableCombo().remove(text);
                    this.getEditableCombo().add(key);
                    this.getEditableCombo().setData(key, (Object)newValue);
                    this.getEditableCombo().setText(key);
                    this.getEditableCombo().add(text);
                    this.value = newValue;
                    CompareFilePropertiesViewerPane.this.valueChanged(this);
                }
            } else {
                this.value = (String)this.getEditableCombo().getData(text);
                CompareFilePropertiesViewerPane.this.valueChanged(this);
            }
        }

        private String openEditDialog() {
            String left = this.value;
            String right = null;
            String ancestor = null;
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasRight()) {
                right = (String)CompareFilePropertiesViewerPane.this.fileProperties.getRight().getProperties().get(this.propertyName);
            }
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor()) {
                ancestor = (String)CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getProperties().get(this.propertyName);
            }
            CompareConfiguration configuration = new CompareConfiguration();
            configuration.setLeftEditable(CompareFilePropertiesViewerPane.this.fileProperties.isEditable());
            configuration.setRightEditable(false);
            configuration.setLeftLabel(CompareFilePropertiesViewerPane.this.compareConfiguration.getLeftLabel(null));
            configuration.setRightLabel(CompareFilePropertiesViewerPane.this.compareConfiguration.getRightLabel(null));
            configuration.setAncestorLabel(CompareFilePropertiesViewerPane.this.compareConfiguration.getAncestorLabel(null));
            PropertyCompareEditorInput input = new PropertyCompareEditorInput(this.propertyName, left, right, ancestor, configuration);
            CompareUI.openCompareDialog((CompareEditorInput)input);
            return input.getResult();
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.propertyName;
        }

        @Override
        public boolean isDirty() {
            if (CompareFilePropertiesViewerPane.this.fileProperties.hasLeft()) {
                String leftValue = (String)CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getProperties().get(this.propertyName);
                return !NullUtil.equals((Object)this.value, (Object)leftValue);
            }
            return false;
        }

        @Override
        protected void updateValueFromSelection() {
            this.value = (String)this.getEditableCombo().getData(this.getEditableCombo().getText());
        }

        @Override
        protected boolean propertyPresent(int side) {
            if (side == LEFT) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasLeft() && CompareFilePropertiesViewerPane.this.fileProperties.getLeft().getProperties().get(this.propertyName) != null;
            }
            if (side == RIGHT) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasRight() && CompareFilePropertiesViewerPane.this.fileProperties.getRight().getProperties().get(this.propertyName) != null;
            }
            if (side == ANCESTOR) {
                return CompareFilePropertiesViewerPane.this.fileProperties.hasAncestor() && CompareFilePropertiesViewerPane.this.fileProperties.getAncestor().getProperties().get(this.propertyName) != null;
            }
            return super.propertyPresent(side);
        }
    }

    public class WidgetHeight
    implements Listener {
        private int fullSize;
        private int maxSize;
        private final boolean isFile;

        public WidgetHeight(boolean isFile, int fullSize) {
            this.isFile = isFile;
            this.maxSize = isFile ? 180 : 240;
            this.fullSize = fullSize;
        }

        public int getHeight() {
            return Math.min(this.getMaximumHeight(), this.fullSize);
        }

        protected int getMaximumHeight() {
            return this.maxSize;
        }

        public void handleEvent(Event event) {
            int available = ((Control)event.widget).getSize().y;
            available = this.isFile ? 180 : (available -= 30);
            this.maxSize = Math.max(180, available);
            this.update();
        }

        public void update() {
        }
    }
}

