/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.compare.ComparePropertiesState;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesViewerPane;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateComputer;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStorageTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FireChangeDiffNode;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FolderTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.ICompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.IDelegatingCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.InputStreamProviderTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.VersionableTypedElement;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IVersionable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCompareEditorInput
extends CompareEditorInput
implements ICompareEditorInput {
    private IWorkbenchPage page;
    private boolean saving = false;
    private boolean fileStreamChanges;
    protected ComparePropertiesState fileProperties;
    private CompareFilePropertiesViewerPane compareFilePropertiesViewerPane;
    private Composite top;
    private Shell shell;
    private boolean isExternal;
    private IDelegatingCompareEditorInput outerCompareEditor;
    private String rightLabelOverride = null;

    public AbstractCompareEditorInput(CompareConfiguration configuration, boolean isExternal) {
        super(configuration);
        this.isExternal = isExternal;
    }

    public void setOuterCompareEditor(IDelegatingCompareEditorInput outerCompareEditor) {
        this.outerCompareEditor = outerCompareEditor;
    }

    @Override
    public IWorkbenchPage getPage() {
        if (this.page == null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return this.page;
    }

    @Override
    public void setPage(IWorkbenchPage page) {
        this.page = page;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setRightLabel(String remoteName) {
        this.rightLabelOverride = remoteName;
    }

    public final Control createContents(Composite parent) {
        if (this.top != null && !this.top.isDisposed()) {
            return this.top;
        }
        this.top = new Composite(parent, 0);
        this.shell = this.top.getShell();
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(this.top);
        this.createContents2(this.top);
        return this.top;
    }

    protected void createContents2(Composite top) {
        if (!this.includeFileProperties()) {
            Control c = this.superCreateComposite(top);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(c);
            return;
        }
        this.compareFilePropertiesViewerPane = new CompareFilePropertiesViewerPane(top, this.getCompareConfiguration(), this.fileProperties, this.getWorkbenchPart().getSite(), this.fileStreamChanges){

            @Override
            protected void firePropertyChange(PropertyChangeEvent event) {
                AbstractCompareEditorInput.this.firePropertyChange(event);
            }
        };
        Object c = null;
        if (this.fileStreamChanges) {
            c = this.isExternal ? this.createNoStreamChangesLabel(top, Messages.FileChangeExternalCompareEditorInput_0) : this.superCreateComposite(top);
        } else {
            String message = this.fileProperties.isFolder() ? Messages.AbstractCompareEditorInput_0 : Messages.CompareFilePropertiesViewerPane_11;
            c = this.createNoStreamChangesLabel(top, message);
        }
        GridDataFactory.defaultsFor((Control)c).grab(true, true).applyTo(c);
        top.layout();
    }

    protected boolean includeFileProperties() {
        return !this.fileProperties.isEmpty();
    }

    private Composite createNoStreamChangesLabel(Composite parent, String msg) {
        Composite composite = new Composite(parent, 64);
        Label label = new Label(composite, 0);
        label.setText(msg);
        Point margins = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().margins(margins.x, 0).applyTo(composite);
        return composite;
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        if (this.outerCompareEditor != null) {
            this.outerCompareEditor.firePropertyChange(event);
        }
        super.firePropertyChange(event);
    }

    protected Control superCreateComposite(Composite top) {
        if (this.outerCompareEditor != null) {
            return this.outerCompareEditor.superCreateComposite(top);
        }
        return super.createContents(top);
    }

    public void contentsCreated() {
        super.contentsCreated();
    }

    protected boolean closeEditor(boolean checkForUnsavedChanges) {
        if (this.isSaveNeeded() && checkForUnsavedChanges) {
            return false;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IEditorPart part = AbstractCompareEditorInput.this.getPage().findEditor(AbstractCompareEditorInput.this.getEditorInput());
                AbstractCompareEditorInput.this.getPage().closeEditor(part, false);
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display display = this.getPage().getWorkbenchWindow().getShell().getDisplay();
            display.asyncExec(runnable);
        }
        return true;
    }

    protected IEditorInput getEditorInput() {
        if (this.outerCompareEditor != null) {
            return this.outerCompareEditor.getEditorInput();
        }
        return this;
    }

    public Object getCompareResult() {
        if (this.outerCompareEditor != null) {
            return this.outerCompareEditor.getCompareResult();
        }
        return super.getCompareResult();
    }

    public void handleDispose() {
        super.handleDispose();
        Object compareResult = this.getCompareResult();
        if (compareResult instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)compareResult;
            this.dispose(ci.getLeft());
            this.dispose(ci.getRight());
            this.dispose(ci.getAncestor());
        }
    }

    private void dispose(ITypedElement element) {
        Object adapter;
        if (element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(DisposableInputStreamProvider.class)) instanceof DisposableInputStreamProvider) {
            DisposableInputStreamProvider disp = (DisposableInputStreamProvider)adapter;
            try {
                disp.dispose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return this.prepareCompareInput(monitor);
    }

    public ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            CompareConfiguration cc = this.getCompareConfiguration();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            TypedElementAndData leftElement = this.computeLeft((IProgressMonitor)progress.newChild(1));
            ITypedElement left = leftElement.getElement();
            String leftLabel = leftElement.getLabel();
            if (left != null && left instanceof IContentChangeNotifier) {
                IContentChangeNotifier ccn = (IContentChangeNotifier)left;
                ccn.addContentChangeListener(new IContentChangeListener(){

                    public void contentChanged(IContentChangeNotifier source) {
                        try {
                            if (!AbstractCompareEditorInput.this.saving) {
                                AbstractCompareEditorInput.this.saveChanges((IProgressMonitor)TempHelper.MONITOR);
                            }
                        }
                        catch (CoreException e) {
                            StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.ui", (String)e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
            cc.setLeftLabel(leftLabel);
            this.getCompareConfiguration().setLeftEditable(leftElement.isEditable());
            TypedElementAndData rightElement = this.computeRight((IProgressMonitor)progress.newChild(1));
            ITypedElement right = rightElement.getElement();
            String rightLabel = rightElement.getLabel();
            if (this.rightLabelOverride != null) {
                cc.setRightLabel(this.rightLabelOverride);
            } else {
                cc.setRightLabel(rightLabel);
            }
            this.getCompareConfiguration().setRightEditable(rightElement.isEditable());
            TypedElementAndData ancestorElement = this.computeAncestor((IProgressMonitor)progress.newChild(1));
            ITypedElement ancestor = ancestorElement.getElement();
            String ancestorLabel = ancestorElement.getLabel();
            cc.setAncestorLabel(ancestorLabel);
            this.fileProperties = this.createFilePropertyState(leftElement, rightElement, ancestorElement, (IProgressMonitor)progress.newChild(1));
            Object result = null;
            if (this.fileProperties.isFile()) {
                Differencer d = new Differencer(){

                    protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                        return new FireChangeDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                    }
                };
                progress.setWorkRemaining(100);
                result = d.findDifferences(ancestor != null, (IProgressMonitor)progress.newChild(100), null, (Object)ancestor, (Object)left, (Object)right);
            }
            boolean bl = this.fileStreamChanges = result != null;
            if (result == null && this.fileProperties.hasDifference() && this.includeFileProperties()) {
                result = new FireChangeDiffNode(null, 7, ancestor, left, right);
            }
            progress.done();
            return (ICompareInput)result;
        }
        catch (TeamRepositoryException e) {
            throw new InvocationTargetException(e);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (RuntimeException e) {
            StatusUtil.log((Object)this, (Throwable)e);
            throw e;
        }
    }

    public void fireInputChange() {
        Object compareResult = this.getCompareResult();
        if (compareResult instanceof FireChangeDiffNode) {
            FireChangeDiffNode diffNode = (FireChangeDiffNode)((Object)compareResult);
            diffNode.fireChange();
        }
    }

    protected abstract ComparePropertiesState createFilePropertyState(TypedElementAndData var1, TypedElementAndData var2, TypedElementAndData var3, IProgressMonitor var4) throws FileSystemException;

    protected abstract TypedElementAndData computeLeft(IProgressMonitor var1) throws CoreException, TeamRepositoryException, IOException;

    protected abstract TypedElementAndData computeRight(IProgressMonitor var1) throws CoreException, TeamRepositoryException, IOException;

    protected abstract TypedElementAndData computeAncestor(IProgressMonitor var1) throws CoreException, TeamRepositoryException, IOException;

    protected ITypedElement createLeftElement(IShareable shareable, IProgressMonitor monitor) throws FileSystemException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ITypedElement element = null;
        if (shareable == null) {
            element = InputStreamProviderTypedElement.createTypedElement(FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null), (IProgressMonitor)progress.newChild(5));
        } else {
            ResourceType resourceType = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
            if (resourceType == null) {
                element = InputStreamProviderTypedElement.createTypedElement(FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null), (IProgressMonitor)progress.newChild(5));
            } else if (resourceType == ResourceType.FILE) {
                IResource resource = (IResource)shareable.getAdapter(IResource.class);
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    element = this.createLeftElement(file);
                }
            } else if (resourceType == ResourceType.FOLDER || resourceType == ResourceType.SYMBOLIC_LINK) {
                element = new FolderTypedElement(shareable.getLocalPath().getName());
            }
            if (element == null) {
                element = FileStorageTypedElement.create(shareable, monitor);
            }
        }
        return element;
    }

    protected ITypedElement createLeftElement(IFile localFile) throws FileSystemException {
        if (this.outerCompareEditor != null) {
            return this.outerCompareEditor.createLeftElement(localFile);
        }
        final String localEncoding = ResourceUtil.getEncoding((IFile)localFile);
        return new BufferedResourceNode((IResource)localFile){

            public String getCharset() {
                return localEncoding;
            }
        };
    }

    public boolean isSaveNeeded() {
        if (this.compareFilePropertiesViewerPane != null) {
            return this.compareFilePropertiesViewerPane.isDirty() || super.isSaveNeeded();
        }
        return super.isSaveNeeded();
    }

    public boolean isDirty() {
        if (this.outerCompareEditor != null) {
            return this.outerCompareEditor.isDirty();
        }
        return super.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        if (this.saving) {
            return;
        }
        AbstractCompareEditorInput abstractCompareEditorInput = this;
        synchronized (abstractCompareEditorInput) {
            this.saving = true;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.compareFilePropertiesViewerPane != null) {
            this.compareFilePropertiesViewerPane.flush((IProgressMonitor)progress.newChild(33));
        }
        this.superSaveChanges((IProgressMonitor)progress.newChild(33));
        try {
            this.saveRequested((IProgressMonitor)progress.newChild(34));
        }
        catch (FileSystemException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        this.setDirty(false);
        AbstractCompareEditorInput abstractCompareEditorInput2 = this;
        synchronized (abstractCompareEditorInput2) {
            this.saving = false;
        }
    }

    protected void superSaveChanges(IProgressMonitor monitor) throws CoreException {
        if (this.outerCompareEditor != null) {
            this.outerCompareEditor.superSaveChanges(monitor);
        }
        super.saveChanges(monitor);
    }

    protected void saveRequested(IProgressMonitor monitor) throws CoreException, FileSystemException {
        Object compareResult = this.getCompareResult();
        if (compareResult instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)compareResult;
            ITypedElement left = ci.getLeft();
            if (left instanceof BufferedResourceNode) {
                BufferedResourceNode node = (BufferedResourceNode)left;
                node.commit(monitor);
            } else if (left instanceof FileStorageTypedElement) {
                FileStorageTypedElement fste = (FileStorageTypedElement)left;
                fste.commit(monitor);
            } else if (left instanceof VersionableTypedElement) {
                VersionableTypedElement fste = (VersionableTypedElement)left;
                fste.commit(monitor);
            }
        }
    }

    public boolean canRunAsJob() {
        return false;
    }

    public Shell getShell() {
        return this.shell;
    }

    protected boolean isCreateOrDelete() {
        return !this.fileProperties.hasLeft() || !this.fileProperties.hasRight();
    }

    protected String getLabelWithVersion(FileState fileState, String labelName) {
        IPreferenceStore store = RcpUiPlugin.getDefault().getPreferenceStore();
        boolean showLongIdentifier = store.getBoolean("pref_show_version_identifiers_repository_id");
        String versionLabel = "";
        if (FileStateComputer.showVersionIdForCompare() && fileState != null && !(versionLabel = showLongIdentifier ? fileState.getLongVersionId() : fileState.getShortVersionId()).equals("")) {
            return NLS.bind((String)Messages.AbstractCompareEditorInput_LabelWithVersion, (Object)labelName, (Object)versionLabel);
        }
        return labelName;
    }

    protected static class TypedElementAndData {
        private ITypedElement element;
        private String label;
        private IShareable shareable;
        private FileState fileState;
        private IVersionable versionable;

        public TypedElementAndData() {
        }

        public TypedElementAndData(ITypedElement element, String label, IShareable shareable) {
            this.element = element;
            this.label = label;
            this.shareable = shareable;
        }

        public TypedElementAndData(ITypedElement element, String label, FileState fileState) {
            this.element = element;
            this.label = label;
            this.fileState = fileState;
        }

        public TypedElementAndData(ITypedElement element, String label, FileState fileState, IVersionable versionable) {
            this.element = element;
            this.label = label;
            this.fileState = fileState;
            this.versionable = versionable;
            if (!versionable.isWorkingCopy()) {
                throw new InvalidParameterException();
            }
        }

        public ITypedElement getElement() {
            return this.element;
        }

        public String getLabel() {
            boolean editable = false;
            if (this.element != null && this.element instanceof IEditableContent) {
                IEditableContent editableContent = (IEditableContent)this.element;
                editable = editableContent.isEditable();
            }
            if (editable) {
                return NLS.bind((String)Messages.LocalFileCompareEditorInput_0, (Object)this.label);
            }
            if (this.element instanceof FolderTypedElement) {
                return this.label;
            }
            return NLS.bind((String)Messages.LocalFileCompareEditorInput_2, (Object)this.label);
        }

        public IShareable getShareable() {
            return this.shareable;
        }

        public FileState getFileState() {
            return this.fileState;
        }

        public boolean isEditable() {
            if (this.element instanceof IEditableContent) {
                IEditableContent ec = (IEditableContent)this.element;
                return ec.isEditable();
            }
            return false;
        }

        public IVersionable getVersionable() {
            return this.versionable;
        }
    }
}

