/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SandboxPersistence
implements ICopyFileAreaListener {
    private static final String SANDBOX_LISTENING = "com.ibm.team.filesystem.rcp.core.SandboxListening";
    private static final String SANDBOX_PATHS = "com.ibm.team.filesystem.rcp.core.SandboxPaths";
    private Collection<ILocation> copyFileAreas;
    private boolean sandboxListening = false;

    public SandboxPersistence() {
        this.initialize();
    }

    private void initialize() {
        new Job(Messages.SandboxPersistence_0){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                ISharingManager sharingManager = FileSystemCore.getSharingManager();
                Collection paths = SandboxPersistence.this.getPersistedCopyFileAreas();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(paths.size() + 2));
                if (SandboxPersistence.this.sandboxListening) {
                    try {
                        sharingManager.enableSandboxListening((IProgressMonitor)progress.newChild(1));
                    }
                    catch (FileSystemException e) {
                        StatusUtil.log((Object)((Object)this), (Throwable)e);
                    }
                }
                ArrayList<ILocation> toRemove = new ArrayList<ILocation>();
                for (ILocation path : paths) {
                    if (this.ensureRegistererd(path, true, progress.newChild(1))) continue;
                    toRemove.add(path);
                }
                IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                this.ensureRegistererd((ILocation)new PathLocation(workspace), false, progress.newChild(1));
                Object object = this;
                synchronized (object) {
                    sharingManager.addListener((ICopyFileAreaListener)SandboxPersistence.this);
                    boolean needsWrite = false;
                    for (ISandbox s : sharingManager.getRegisteredSandboxes()) {
                        needsWrite |= SandboxPersistence.this.addCopyFileArea(s.getRoot());
                    }
                    for (ILocation path : toRemove) {
                        needsWrite |= SandboxPersistence.this.removeCopyFileArea(path);
                    }
                    if (needsWrite) {
                        SandboxPersistence.this.write();
                    }
                }
                progress.done();
                return Status.OK_STATUS;
            }

            private boolean ensureRegistererd(ILocation path, boolean logFailure, SubMonitor progress) {
                ISharingManager sharingManager = FileSystemCore.getSharingManager();
                boolean registered = true;
                ISandbox sandbox = sharingManager.getSandbox(path, true);
                if (sandbox == null) {
                    registered = false;
                    try {
                        sharingManager.register(sharingManager.getSandbox(path, false), true, (IProgressMonitor)progress);
                        registered = true;
                    }
                    catch (FileSystemException e) {
                        if (logFailure) {
                            StatusUtil.log((Object)((Object)this), (Throwable)e);
                        }
                    }
                    catch (RuntimeException e) {
                        StatusUtil.log((Object)((Object)this), (Throwable)e);
                    }
                }
                return registered;
            }
        }.schedule();
    }

    private synchronized Collection<ILocation> getPersistedCopyFileAreas() {
        if (this.copyFileAreas == null) {
            String paths = this.getPreferences().get(SANDBOX_PATHS, "");
            String isSandboxListening = this.getPreferences().get(SANDBOX_LISTENING, "");
            StringTokenizer tokenizer = new StringTokenizer(paths, "\n");
            this.copyFileAreas = new HashSet<ILocation>();
            while (tokenizer.hasMoreTokens()) {
                PathLocation toAdd;
                String pathStr = tokenizer.nextToken();
                if (pathStr.length() <= 0) continue;
                if (pathStr.startsWith("storageId:")) {
                    int storageBegin = pathStr.indexOf("storageId:") + "storageId:".length();
                    int storageEnd = pathStr.indexOf(47);
                    String storageId = pathStr.substring(storageBegin, storageEnd);
                    String restOfLocation = pathStr.substring(storageEnd + 1);
                    toAdd = SharingManager.getInstance().getStorageManager(storageId).createLocation(restOfLocation);
                } else {
                    IPath path = Path.fromPortableString((String)pathStr);
                    toAdd = new PathLocation(path);
                }
                if (toAdd == null) continue;
                this.copyFileAreas.add((ILocation)toAdd);
            }
            if ("true".equals(isSandboxListening)) {
                this.sandboxListening = true;
            }
        }
        return this.copyFileAreas;
    }

    public void dispose() {
        FileSystemCore.getSharingManager().removeListener((ICopyFileAreaListener)this);
    }

    public synchronized void change(ICopyFileAreaEvent[] events) {
        boolean needsWrite = false;
        ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
            if (event.getReason() == 9) {
                needsWrite |= this.addCopyFileArea(event.getCopyFileAreaRoot());
            } else if (event.getReason() == 10) {
                needsWrite |= this.removeCopyFileArea(event.getCopyFileAreaRoot());
            } else if (event.getReason() == 11) {
                needsWrite = !this.sandboxListening;
                this.sandboxListening = true;
            } else if (event.getReason() == 12) {
                needsWrite = this.sandboxListening;
                this.sandboxListening = false;
            }
            ++n2;
        }
        if (needsWrite) {
            this.write();
        }
    }

    private boolean removeCopyFileArea(ILocation copyFileAreaRoot) {
        if (this.copyFileAreas.contains(copyFileAreaRoot)) {
            this.copyFileAreas.remove(copyFileAreaRoot);
            return true;
        }
        return false;
    }

    private boolean addCopyFileArea(ILocation copyFileAreaRoot) {
        IPath copyFileAreaPath = (IPath)copyFileAreaRoot.getAdapter(IPath.class);
        if (copyFileAreaPath != null && copyFileAreaPath.equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation())) {
            return false;
        }
        if (!this.copyFileAreas.contains(copyFileAreaRoot)) {
            this.copyFileAreas.add(copyFileAreaRoot);
            return true;
        }
        return false;
    }

    private void write() {
        try {
            Preferences preferences = this.getPreferences();
            if (this.copyFileAreas.size() == 0) {
                preferences.remove(SANDBOX_PATHS);
            } else {
                StringBuffer buffer = new StringBuffer();
                for (ILocation cfa : this.copyFileAreas) {
                    if ("com.ibm.team.filesystem.hfs".equals(cfa.getStorageId())) {
                        IPath path = (IPath)cfa.getAdapter(IPath.class);
                        if (path == null) continue;
                        buffer.append(path.toPortableString());
                        buffer.append('\n');
                        continue;
                    }
                    buffer.append("storageId:");
                    buffer.append(cfa.getStorageId());
                    buffer.append('/');
                    buffer.append(cfa.toString());
                    buffer.append('\n');
                }
                preferences.put(SANDBOX_PATHS, buffer.toString());
            }
            if (!this.sandboxListening) {
                preferences.put(SANDBOX_LISTENING, "false");
            } else {
                preferences.put(SANDBOX_LISTENING, "true");
            }
            preferences.flush();
        }
        catch (BackingStoreException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }

    private Preferences getPreferences() {
        return new InstanceScope().getNode(FileSystemResourcesPlugin.getDefault().getBundle().getSymbolicName());
    }
}

