/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing.files;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.files.FileSharingWizardInput;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class SelectFilesToSharePage
extends WizardPage
implements IChangeListener {
    private CheckboxTableViewer fViewer;
    private Label fSelectedCountLabel;
    private final FileSharingWizardInput fInput;

    public SelectFilesToSharePage(String pageName, String title, ImageDescriptor titleImage, FileSharingWizardInput input) {
        super(pageName, title, titleImage);
        this.fInput = input;
        this.setDescription(Messages.SelectFilesToSharePage_PageDescription);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label l = new Label(composite, 0);
        l.setText(Messages.SelectFilesToSharePage_AvailableUnsharedFiles);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)l);
        this.fViewer = new CheckboxTableViewer(new Table(composite, 2850));
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ShareableLabelProvider());
        this.fViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.fViewer.setInput(this.fInput.getUnsharedFiles());
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IShareable) {
                    IShareable shareable = (IShareable)element;
                    if (event.getChecked()) {
                        SelectFilesToSharePage.this.fInput.getSelectedFiles().add((Object)shareable);
                    } else {
                        SelectFilesToSharePage.this.fInput.getSelectedFiles().remove((Object)shareable);
                    }
                }
            }
        });
        Composite buttonsComposite = new Composite(composite, 0);
        Button selectAllButton = new Button(buttonsComposite, 8);
        selectAllButton.setText(Messages.SelectFilesToSharePage_SelectAllButonText);
        selectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectFilesToSharePage.this.fInput.getSelectedFiles().addAll(SelectFilesToSharePage.this.fInput.getUnsharedFiles());
            }
        });
        Button deselectAllButton = new Button(buttonsComposite, 8);
        deselectAllButton.setText(Messages.SelectFilesToSharePage_DeselectAllButtonText);
        deselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectFilesToSharePage.this.fInput.getSelectedFiles().clear();
            }
        });
        this.fInput.getSelectedFiles().addChangeListener((IChangeListener)this);
        GridLayoutFactory.fillDefaults().generateLayout(buttonsComposite);
        this.fSelectedCountLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)l);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        this.setControl((Control)composite);
        this.updateCheckedFiles();
        this.updateEnablements();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_share_selectfiles");
    }

    private void updateCheckedFiles() {
        this.fViewer.setCheckedElements(this.fInput.getSelectedFiles().toArray(new Object[this.fInput.getSelectedFiles().size()]));
    }

    private void updateEnablements() {
        this.updateSelectedCountLabel();
        this.updatePageComplete();
    }

    private void updateSelectedCountLabel() {
        this.fSelectedCountLabel.setText(NLS.bind((String)Messages.SelectFilesToSharePage_SelectionCountLabel, (Object)this.fInput.getSelectedFiles().size(), (Object)this.fInput.getUnsharedFiles().size()));
    }

    private void updatePageComplete() {
        this.setPageComplete(this.fInput.getSelectedFiles().size() > 0);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fViewer.getControl().setFocus();
        }
    }

    public void handleChange(ChangeEvent event) {
        this.updateCheckedFiles();
        this.updateEnablements();
    }

    public void dispose() {
        this.fInput.getSelectedFiles().removeChangeListener((IChangeListener)this);
        super.dispose();
    }

    private class ShareableLabelProvider
    implements ILabelProvider {
        private ShareableLabelProvider() {
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public Image getImage(Object arg0) {
            return null;
        }

        public String getText(Object o) {
            if (o instanceof IShareable) {
                IShareable shareable = (IShareable)o;
                return shareable.getLocalPath().getName();
            }
            return null;
        }
    }
}

