/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing.files;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.properties.SharingDescriptorPane;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.files.FileSharingWizardInput;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class FilesAlreadySharedPage
extends WizardPage {
    private final FileSharingWizardInput fInput;

    protected FilesAlreadySharedPage(String pageName, FileSharingWizardInput input, ImageDescriptor titleImage) {
        super(pageName, Messages.AutoShareFilePage_PageTitle, titleImage);
        this.fInput = input;
        this.setDescription(Messages.AutoShareFilePage_PageDescription);
    }

    public void createControl(Composite parent) {
        int filesSharedInSandboxesCount;
        Composite composite = new Composite(parent, 0);
        Label l = new Label(composite, 64);
        boolean showDetails = true;
        if (this.fInput.isSharedInSandbox(this.fInput.getSeed())) {
            l.setText(NLS.bind((String)Messages.AutoShareFilePage_AlreadySharedDescription, (Object)this.fInput.getSeed().getFullPath().getName()));
        } else if (this.fInput.containsShare(this.fInput.getSeed())) {
            showDetails = false;
            l.setText(NLS.bind((String)Messages.AutoShareFilePage_ChildrenAreSharedDescription, (Object)this.fInput.getSeed().getFullPath().getName()));
        } else {
            l.setText(NLS.bind((String)Messages.AutoShareFilePage_ParentAlreadyShared, (Object)this.fInput.getSeed().getFullPath().getName()));
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(350, -1).span(2, 1).applyTo((Control)l);
        if (showDetails) {
            new SharingDescriptorPane(composite, this.fInput.getSeed(), new JobRunner(false));
        }
        if ((filesSharedInSandboxesCount = this.fInput.getUnsharedFiles().size()) > 1) {
            Label multiple = new Label(composite, 64);
            multiple.setText(NLS.bind((String)Messages.AutoShareFilePage_OtherSharedFilesPresent, (Object)filesSharedInSandboxesCount));
            GridDataFactory.fillDefaults().align(4, 0x1000000).hint(350, -1).span(2, 1).applyTo((Control)multiple);
        }
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_share_autoconnectfiles");
    }
}

