/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing.files;

import com.ibm.team.filesystem.client.CopyFileAreaLockedByOtherProcess;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.rcp.ui.internal.util.PropertyChangeNotifier;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.TeamAreaSelection;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class FileSharingWizardInput
extends PropertyChangeNotifier {
    private final IShareable fSeed;
    private Map<IShare, IAncestorReport> fSiblingShare;
    private final WritableSet fSelectedFiles = new WritableSet();
    private final Map<IShareable, FileDescription> fUnsharedFiles = new HashMap<IShareable, FileDescription>();

    public FileSharingWizardInput(Set<IShareable> shareablesToShare) throws InvocationTargetException {
        this.buildFileDescriptions(shareablesToShare);
        IShareable tempSeed = null;
        for (IShareable shareable : shareablesToShare) {
            this.fSelectedFiles.add((Object)shareable);
            if (tempSeed != null || this.isDescendantOfShare(shareable)) continue;
            tempSeed = shareable;
        }
        this.fSeed = tempSeed == null ? shareablesToShare.iterator().next() : tempSeed;
        this.calculateSiblingShare();
    }

    public void buildFileDescriptions(final Set<IShareable> shareables) throws InvocationTargetException {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        FileSharingWizardInput.this.buildFileDescriptions(shareables, monitor);
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            String message = this.getMessage(cause);
            ErrorDialog.openError(null, null, (String)message, (IStatus)StatusUtil.newStatus((Object)((Object)this), (String)cause.getMessage(), (Throwable)cause));
            throw e;
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    private void calculateSiblingShare() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block8: {
                        try {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            if (FileSharingWizardInput.this.fSeed == null) break block8;
                            ISandbox sandbox = FileSharingWizardInput.this.fSeed.getSandbox();
                            IShare[] allShares = null;
                            allShares = sandbox.allShares((IProgressMonitor)progress.newChild(25));
                            if (allShares == null || allShares.length <= 0) break block8;
                            int i = 0;
                            while (i < allShares.length) {
                                IShareable seedParentShareable = ((Shareable)FileSharingWizardInput.this.fSeed).getParent();
                                IRelativeLocation shareParent = allShares[i].getPath().getParent();
                                if (seedParentShareable == null && shareParent == null || seedParentShareable != null && shareParent != null && seedParentShareable.getFullPath().toOSString().equals(shareParent.toPath().toOSString())) {
                                    IContextHandle contextHandle;
                                    IShare share = allShares[i];
                                    IAncestorReport ancestors = null;
                                    ISharingDescriptor desc = share.getSharingDescriptor();
                                    ITeamRepository repo = RepositoryUtils.getTeamRepositoryById((UUID)desc.getRepositoryId());
                                    if (repo != null && (contextHandle = desc.getConnectionHandle()) instanceof IWorkspaceHandle) {
                                        IWorkspaceManager wsMan = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                                        try {
                                            IWorkspaceConnection connection = wsMan.getWorkspaceConnection((IWorkspaceHandle)contextHandle, (IProgressMonitor)progress.newChild(25));
                                            if (connection != null) {
                                                IVersionableHandle handle = share.getShareable().getVersionable((IProgressMonitor)progress.newChild(25));
                                                ancestors = (IAncestorReport)connection.configuration(desc.getComponent()).locateAncestors(Collections.singletonList(handle), (IProgressMonitor)progress.newChild(25)).get(0);
                                            }
                                        }
                                        catch (Exception e) {
                                            StatusUtil.log((Object)this, (Throwable)e);
                                        }
                                    }
                                    FileSharingWizardInput.this.fSiblingShare = new HashMap(1);
                                    FileSharingWizardInput.this.fSiblingShare.put(share, ancestors);
                                    break;
                                }
                                ++i;
                            }
                        }
                        catch (FileSystemException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            String message = this.getMessage(cause);
            ErrorDialog.openError(null, null, (String)message, (IStatus)StatusUtil.newStatus((Object)((Object)this), (String)cause.getMessage(), (Throwable)cause));
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    private String getMessage(Throwable cause) {
        if (cause instanceof CopyFileAreaLockedByOtherProcess) {
            return Messages.FileSharingWizardInput_SandboxInUseErrorMsg;
        }
        return null;
    }

    protected void buildFileDescriptions(Set<IShareable> seedShareables, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(seedShareables.size() * 3));
        for (IShareable shareable : seedShareables) {
            if (this.isUnshared(shareable)) {
                FileDescription desc = new FileDescription(shareable, progress.newChild(3));
                this.fUnsharedFiles.put(shareable, desc);
                continue;
            }
            progress.worked(3);
        }
    }

    public IShareable getSeed() {
        return this.fSeed;
    }

    public Map<IShare, IAncestorReport> getSiblingShare() {
        return this.fSiblingShare;
    }

    public WritableSet getSelectedFiles() {
        return this.fSelectedFiles;
    }

    public Collection<IShareable> getUnsharedFiles() {
        boolean descendantOfShare = this.isDescendantOfShare(this.getSeed());
        HashSet<IShareable> result = new HashSet<IShareable>();
        for (FileDescription desc : this.fUnsharedFiles.values()) {
            if (descendantOfShare && !desc.fIsDescendantOfShare) continue;
            result.add(desc.fShareable);
        }
        return result;
    }

    private boolean isUnshared(IShareable shareable) {
        return true;
    }

    public Collection<IShareable> getFilesToConnect() {
        ArrayList<IShareable> result = new ArrayList<IShareable>();
        for (IShareable shareable : this.fSelectedFiles) {
            if (!this.isDescendantOfShare(shareable) && !this.containsShare(shareable)) continue;
            result.add(shareable);
        }
        return result;
    }

    public List<IShareable> getFilesToShare() {
        ArrayList<IShareable> result = new ArrayList<IShareable>();
        for (IShareable shareable : this.fSelectedFiles) {
            if (this.isSharedInSandbox(shareable) || this.isDescendantOfShare(shareable) || this.containsShare(shareable)) continue;
            result.add(shareable);
        }
        return result;
    }

    public boolean isAutoconnect() {
        return this.isSharedInSandbox(this.getSeed()) || this.isDescendantOfShare(this.getSeed()) || this.containsShare(this.getSeed());
    }

    private boolean isDescendantOfShare(IShareable shareable) {
        FileDescription fileDescription = this.fUnsharedFiles.get(shareable);
        if (fileDescription != null) {
            return fileDescription.fIsDescendantOfShare;
        }
        return false;
    }

    public boolean isSharedInSandbox(IShareable shareable) {
        FileDescription fileDescription = this.fUnsharedFiles.get(shareable);
        if (fileDescription != null) {
            return fileDescription.fIsSharedInSandbox;
        }
        return false;
    }

    public boolean containsShare(IShareable shareable) {
        FileDescription fileDescription = this.fUnsharedFiles.get(shareable);
        if (fileDescription != null) {
            return fileDescription.fContainsShare;
        }
        return false;
    }

    public boolean hasMultipleCandidates() {
        return this.getUnsharedFiles().size() > 1;
    }

    private static class FileDescription {
        private boolean fIsDescendantOfShare;
        private IShareable fShareable;
        private boolean fIsSharedInSandbox;
        private boolean fContainsShare;

        public FileDescription(IShareable shareable, SubMonitor progress) throws FileSystemException {
            this.initialize(shareable, progress);
        }

        private void initialize(IShareable shareable, SubMonitor progress) throws FileSystemException {
            progress.setWorkRemaining(3);
            this.fShareable = shareable;
            if (this.fShareable == null) {
                Collection sandboxes = FileSystemCore.getSharingManager().getRegisteredSandboxes();
                ILocation fileLocation = shareable.getFullPath();
                if (fileLocation != null) {
                    for (ISandbox sandbox : sandboxes) {
                        ILocation sandboxRoot = sandbox.getRoot();
                        if (sandboxRoot == null || !fileLocation.isPrefixOf(sandboxRoot)) continue;
                        throw new FileSystemException(NLS.bind((String)Messages.FileSharingWizardInput_SandboxChildOfFileErrorMsg, (Object)sandboxRoot.toString(), (Object)fileLocation.getName()));
                    }
                }
            } else {
                if (this.fShareable.getLocalPath().isEmpty()) {
                    ILocation shareableLocation = this.fShareable.getFullPath();
                    throw new FileSystemException(NLS.bind((String)Messages.FileSharingWizardInput_SandboxChildOfFileErrorMsg, (Object)shareableLocation.toString(), (Object)shareableLocation.getName()));
                }
                this.fIsDescendantOfShare = this.isDescendantOfShare(this.fShareable, (IProgressMonitor)progress.newChild(1));
                this.fIsSharedInSandbox = this.isSharedInSandbox(this.fShareable, (IProgressMonitor)progress.newChild(1));
                if (!this.fIsDescendantOfShare && !this.fIsSharedInSandbox) {
                    this.fContainsShare = this.containsShare(this.fShareable, progress.newChild(1));
                }
            }
        }

        private boolean isSharedInSandbox(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
            return shareable != null && shareable.getRemote(monitor) != null;
        }

        private boolean isDescendantOfShare(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
            return shareable != null && shareable.getShare(monitor) != null;
        }

        private boolean containsShare(IShareable shareable, SubMonitor progress) throws FileSystemException {
            if (shareable != null) {
                IShare[] allShares;
                IShare[] iShareArray = allShares = shareable.getSandbox().allShares((IProgressMonitor)progress);
                int n = allShares.length;
                int n2 = 0;
                while (n2 < n) {
                    IShare share = iShareArray[n2];
                    if (shareable.getLocalPath().isPrefixOf(share.getPath())) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    public static class TargetWorkspaceConfiguration {
        private String fWorkspaceName;
        private boolean fCreatingNewWorkspace;
        private boolean fCollaborate;
        private TeamAreaSelection fTeamAreaSelection;
        private ITeamRepository fRepository;

        public String getWorkspaceName() {
            return this.fWorkspaceName;
        }

        public void setWorkspaceName(String workspaceName) {
            this.fWorkspaceName = workspaceName;
        }

        public boolean isCreatingNewWorkspace() {
            return this.fCreatingNewWorkspace;
        }

        public void setCreatingNewWorkspace(boolean creatingNewWorkspace) {
            this.fCreatingNewWorkspace = creatingNewWorkspace;
        }

        public boolean isCollaborate() {
            return this.fCollaborate;
        }

        public void setCollaborate(boolean collaborate) {
            this.fCollaborate = collaborate;
        }

        public TeamAreaSelection getTeamAreaSelection() {
            return this.fTeamAreaSelection;
        }

        public void setTeamAreaSelection(TeamAreaSelection teamAreaSelection) {
            this.fTeamAreaSelection = teamAreaSelection;
        }

        public ITeamRepository getRepository() {
            return this.fRepository;
        }

        public void setRepository(ITeamRepository repo) {
            this.fRepository = repo;
        }
    }
}

