/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing.files;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxShare;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.util.StatusDialog;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.SymbolicLinkDetailsDialog;
import com.ibm.team.internal.filesystem.ui.util.WarnShareUser;
import com.ibm.team.internal.filesystem.ui.wizards.TeamAreaSelectionPage;
import com.ibm.team.internal.filesystem.ui.wizards.TeamPlaceSelectionPage;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.SharingWizardInput;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.files.ConfigureIgnoresForShareFilesPage;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.files.FileSharingWizardInput;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.files.FilesAlreadySharedPage;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.files.SelectFilesToSharePage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.wizards.ChainedWizard;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class FileSharingWizard
extends ChainedWizard {
    private FileSharingWizardInput fInput;
    private TeamPlaceSelectionPage fTeamPlaceSelectionPage;
    private TeamAreaSelectionPage fTeamAreaSelectionPage;
    private SelectFilesToSharePage fFileSelectionPage;
    private ConfigureIgnoresForShareFilesPage fConfigureIgnoresPage;
    private FilesAlreadySharedPage fAlreadySharedPage;

    public FileSharingWizard(FileSharingWizardInput input) {
        this.fInput = input;
    }

    public void addPages() {
        ImageDescriptor banner = ImagePool.WIZ_SHARING;
        this.setWindowTitle(Messages.FileSharingWizard_WindowTitle);
        if (this.fInput.isAutoconnect()) {
            this.fAlreadySharedPage = new FilesAlreadySharedPage("AlreadySharedPage", this.fInput, banner);
            this.addPage((IWizardPage)this.fAlreadySharedPage);
        } else {
            this.fTeamPlaceSelectionPage = new TeamPlaceSelectionPage("TeamPlacePage", Messages.FileSharingWizard_SelectFolderPageTitle, banner, true, "com.ibm.team.filesystem.ide.ui.page_teamplaceselection_filesharing", this.fInput.getSiblingShare());
            this.fTeamPlaceSelectionPage.setDescription(Messages.FileSharingWizard_SelectComponentPageDescription);
            this.addPage((IWizardPage)this.fTeamPlaceSelectionPage);
            this.fTeamAreaSelectionPage = new TeamAreaSelectionPage(this.fTeamPlaceSelectionPage);
            this.addPage((IWizardPage)this.fTeamAreaSelectionPage);
        }
        this.fFileSelectionPage = new SelectFilesToSharePage("UnsharedFilesPage", Messages.FileSharingWizard_SelectFilesPageTitle, banner, this.fInput);
        this.addPage((IWizardPage)this.fFileSelectionPage);
    }

    public List<IWizardPage> getPageOrder() {
        ArrayList result = NewCollection.arrayList();
        if (this.fInput.isAutoconnect()) {
            result.add(this.fAlreadySharedPage);
            if (this.fInput.hasMultipleCandidates()) {
                result.add(this.fFileSelectionPage);
            }
        } else {
            result.add(this.fTeamPlaceSelectionPage);
            if (this.fTeamPlaceSelectionPage.creatingNewWorkspace()) {
                this.fTeamAreaSelectionPage.setRepo(this.fTeamPlaceSelectionPage);
                result.add(this.fTeamAreaSelectionPage);
            }
            if (this.fInput.hasMultipleCandidates()) {
                result.add(this.fFileSelectionPage);
            }
        }
        return result;
    }

    public boolean performCancel() {
        try {
            boolean bl = super.performCancel();
            return bl;
        }
        finally {
            if (this.fConfigureIgnoresPage != null) {
                this.fConfigureIgnoresPage.performCancel();
            }
        }
    }

    public boolean performFinish() {
        SharingWizardInput.TargetWorkspaceConfiguration twc;
        if (this.fInput.getFilesToShare().isEmpty()) {
            twc = null;
        } else {
            twc = new SharingWizardInput.TargetWorkspaceConfiguration();
            twc.setWorkspaceName(this.fTeamPlaceSelectionPage.getWorkspaceName());
            twc.setCreatingNewWorkspace(this.fTeamPlaceSelectionPage.creatingNewWorkspace());
            twc.setCollaborate(!this.fTeamAreaSelectionPage.dontCollaborate());
            twc.setTeamAreaSelection(twc.isCreatingNewWorkspace() ? (twc.isCollaborate() ? this.fTeamAreaSelectionPage.getTeamAreaSelection() : null) : this.fTeamPlaceSelectionPage.getTeamSelection());
            twc.setRepository(this.fTeamPlaceSelectionPage.getRepository());
        }
        this.performShare(twc);
        return true;
    }

    private void performShare(final SharingWizardInput.TargetWorkspaceConfiguration twc) {
        HashSet<ITeamRepository> repos = new HashSet<ITeamRepository>();
        if (twc != null) {
            repos.add(twc.getRepository());
        }
        final List<IShareable> filesToShare = this.fInput.getFilesToShare();
        JobRunner.enqueue((String)Messages.FileSharingWizard_SharingFilesJobName, (boolean)true, (Operation)new RepositoryOperation(repos){

            public void repositoryRun(IProgressMonitor progress, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                ILocation sandboxPath;
                PathLocation workspacePath;
                ISandbox sandbox;
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)101);
                if (!filesToShare.isEmpty() && (sandbox = this.findSandbox((ILocation)(workspacePath = new PathLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation())))) != null && !(sandboxPath = sandbox.getRoot()).equals((Object)workspacePath) && sandboxPath.isPrefixOf((ILocation)workspacePath)) {
                    throw new FileSystemStatusException(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.FileSharingWizard_WorkspaceInSandboxErrorMsg, (Object)workspacePath.toOSString(), (Object)sandboxPath.toOSString())));
                }
                if (twc == null) {
                    return;
                }
                monitor.setTaskName(Messages.FileSharingWizard_InitializeRepoWorkspaceJobName);
                WorkspaceComponentWrapper componentWrapper = null;
                IFolderHandle parentFolder = null;
                String[] path = null;
                if (twc.isCreatingNewWorkspace()) {
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)twc.getRepository());
                    IWorkspaceConnection workspace = wm.createWorkspace((IContributorHandle)twc.getRepository().loggedInContributor(), twc.getWorkspaceName(), "", (IProgressMonitor)monitor.newChild(10));
                    if (twc.isCollaborate()) {
                        WorkspaceComponentWrapper componentInStream = twc.getTeamAreaSelection().getComponent();
                        if (componentInStream == null) {
                            componentInStream = twc.getTeamAreaSelection().getComponent(twc.getRepository(), (IProgressMonitor)monitor.newChild(5));
                        }
                        IWorkspaceConnection streamConnection = ConnectionUtil.getConnection((ITeamRepository)twc.getRepository(), (IWorkspace)twc.getTeamAreaSelection().getPlace().getWorkspace(), (IProgressMonitor)monitor.newChild(5));
                        List components = streamConnection.getComponents();
                        ArrayList addComponents = new ArrayList();
                        for (IComponentHandle next : components) {
                            addComponents.add(workspace.componentOpFactory().addComponent(next, (IConnection)streamConnection, false));
                        }
                        workspace.applyComponentOperations((List)addComponents, (IProgressMonitor)monitor.newChild(5));
                        FlowTableUtil.addCollaboration((IWorkspaceConnection)workspace, (IWorkspaceConnection)streamConnection, (IProgressMonitor)monitor.newChild(5));
                        componentWrapper = WorkspaceComponentWrapper.newWrapper(workspace, componentInStream.getComponent());
                        parentFolder = twc.getTeamAreaSelection().getParentFolder();
                        path = twc.getTeamAreaSelection().getPath();
                    } else {
                        IComponent newComponent = wm.createComponent(twc.getWorkspaceName(), (IAuditableHandle)twc.getRepository().loggedInContributor(), (IProgressMonitor)monitor.newChild(5));
                        ArrayList<IFlowNodeConnection.IComponentAdditionOp> addOps = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
                        addOps.add(workspace.componentOpFactory().addComponent((IComponentHandle)newComponent, false));
                        workspace.applyComponentOperations(addOps, (IProgressMonitor)monitor.newChild(5));
                        componentWrapper = WorkspaceComponentWrapper.newWrapper(workspace, newComponent);
                        parentFolder = newComponent.getRootFolder();
                        path = new String[]{};
                    }
                } else {
                    componentWrapper = twc.getTeamAreaSelection().getComponent();
                    if (componentWrapper == null) {
                        componentWrapper = twc.getTeamAreaSelection().getComponent(twc.getRepository(), (IProgressMonitor)monitor.newChild(15));
                    }
                    parentFolder = twc.getTeamAreaSelection().getParentFolder();
                    path = twc.getTeamAreaSelection().getPath();
                }
                monitor.setWorkRemaining(100);
                IWorkspaceConnection connection = componentWrapper.getWorkspaceConnection();
                final IComponent component = componentWrapper.getComponent();
                FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)connection.getResolvedWorkspace());
                LocalWorkspaceChangesView.requestShowPendingView();
                ArrayList<ILocation> pathsToShare = new ArrayList<ILocation>(filesToShare.size());
                HashSet nestedFiles = new HashSet();
                for (IShareable shareable : filesToShare) {
                    if (nestedFiles.contains(shareable)) continue;
                    ILocation fileLocation = shareable.getFullPath();
                    pathsToShare.add(fileLocation);
                }
                WarnShareUser handler = new WarnShareUser(null, Messages.FileSharingWizard_ShareFilesHandlerTitle){

                    public int multipleSandboxesForConfigurations(final Collection<? extends IMultipleSandboxShare> shares) {
                        final int[] result = new int[]{1};
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                IStatus status = this.createStatus(shares);
                                StatusDialog dialog = new StatusDialog(null, Messages.FileSharingWizard_MultiSandboxShareDialogTitle, NLS.bind((String)Messages.FileSharingWizard_MultiSandboxShareDialogDescription, (Object)component.getName()), null, status, 7);
                                if (dialog.open() == 0) {
                                    result[0] = 0;
                                }
                            }
                        });
                        return result[0];
                    }

                    IStatus createStatus(Collection<? extends IMultipleSandboxShare> shares) {
                        ArrayList<IStatus> info = new ArrayList<IStatus>();
                        for (IMultipleSandboxShare iMultipleSandboxShare : shares) {
                            this.accumulateStatus(iMultipleSandboxShare, info);
                        }
                        if (info.size() == 1) {
                            return (IStatus)info.get(0);
                        }
                        return StatusUtil.newStatus((Object)((Object)this), (String)Messages.FileSharingWizard_MultiFilesSharingToMultiSandboxesErrorMsg, info);
                    }

                    private void accumulateStatus(IMultipleSandboxShare share, List<IStatus> info) {
                        Collection sandboxes = share.getSandboxes();
                        Collection shareables = share.getShareables();
                        String componentName = component.getName();
                        for (IShareable shareable : shareables) {
                            Collection<ISandbox> otherSandboxes = this.getOtherSandboxes(shareable, sandboxes);
                            for (ISandbox other : otherSandboxes) {
                                info.add(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.FileSharingWizard_MultipleSandboxSharesErrorMsg, (Object[])new Object[]{shareable.getFullPath().toOSString(), componentName, other.getRoot().toOSString()})));
                            }
                        }
                    }

                    private Collection<ISandbox> getOtherSandboxes(IShareable shareable, Collection<ISandbox> sandboxes) {
                        ArrayList<ISandbox> result = new ArrayList<ISandbox>(sandboxes.size());
                        for (ISandbox sandbox : sandboxes) {
                            if (sandbox.equals(shareable.getSandbox())) continue;
                            result.add(sandbox);
                        }
                        return result;
                    }

                    public void linkWarnings(boolean anyBrokenLinks, boolean anyNonInteroperableLinks, final IShareable[] shareables, final String[] targets, final Boolean[] directoryLinks, final Boolean[] broken, final Boolean[] nonInteroperable) {
                        if (PlatformUI.isWorkbenchRunning()) {
                            boolean promptForNonInteroperable;
                            DialogUtil.pauseIfNeededBeforeShowingDialog();
                            final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                            boolean promptForBroken = store.getInt("checkinLinkWarnings") == 0 || store.getInt("checkinLinkWarnings") == 1;
                            boolean bl = promptForNonInteroperable = store.getInt("checkinLinkWarnings") == 0;
                            if (anyBrokenLinks && promptForBroken || anyNonInteroperableLinks && promptForNonInteroperable) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        SymbolicLinkDetailsDialog dialog = new SymbolicLinkDetailsDialog(null, promptForNonInteroperable, shareables, targets, directoryLinks, broken, nonInteroperable);
                                        dialog.open();
                                        if (!dialog.shouldPromptAgain()) {
                                            store.setValue("checkinLinkWarnings", 2);
                                        }
                                    }
                                });
                            }
                        }
                    }
                };
                IShareOperation shareOp = IOperationFactory.instance.getShareOperation((ShareDilemmaHandler)handler);
                shareOp.share(connection, null, (IComponentHandle)component, parentFolder, path, pathsToShare, true, (IProgressMonitor)monitor.newChild(1));
                shareOp.run((IProgressMonitor)monitor.newChild(99));
                if (nestedFiles.size() > 0) {
                    FileSharingWizard.this.fInput.buildFileDescriptions(new HashSet<IShareable>(nestedFiles), (IProgressMonitor)monitor.newChild(1));
                }
            }

            private ISandbox findSandbox(ILocation location) {
                if (location.isEmpty()) {
                    return null;
                }
                ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(location, false);
                if (sandbox.isExistingSandbox()) {
                    return sandbox;
                }
                return this.findSandbox(location.getParent());
            }
        });
    }
}

