/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing.files;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoredItemSet;
import com.ibm.team.filesystem.client.internal.ignore.ReadThroughFilesystemAbstraction;
import com.ibm.team.internal.filesystem.ui.IgnorePatternDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.ignore.IgnoredResourceLabelProvider;
import com.ibm.team.internal.filesystem.ui.ignore.IgnoresPatternQuery;
import com.ibm.team.internal.filesystem.ui.ignore.ProjectTreeFilter;
import com.ibm.team.internal.filesystem.ui.ignore.ResourceComparator;
import com.ibm.team.internal.filesystem.ui.ignore.ResourceTreeProvider;
import com.ibm.team.internal.filesystem.ui.util.ShareablesUtil;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.files.FileSharingWizardInput;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.Team;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

public class ConfigureIgnoresForShareFilesPage
extends WizardPage
implements IChangeListener {
    final int[] opCount = new int[1];
    private SimpleTreeViewer projectTree;
    private final ProjectTreeFilter projectTreeFilter = new ProjectTreeFilter();
    private SimpleTableViewer<IgnoreRule> patterns;
    private List<IShareable> currentFiles;
    private IgnoreManager ignoreManager;
    private DefaultIgnoreProvider ignoresProvider;
    private Link importTeamIgnoresLink;
    private Button addPatternButton;
    private Button removePatternButton;
    private Label statusBar;
    private Button filterButton;
    private Job ignoreFileLocatorJob;
    private Job findIgnoreSetJob;
    private final Job startJob;
    private FileSharingWizardInput input;
    private boolean needsRefresh = true;

    public ConfigureIgnoresForShareFilesPage(FileSharingWizardInput input) {
        super(Messages.ConfigureIgnoresPage_0, Messages.ConfigureIgnoresPage_1, null);
        this.input = input;
        this.setMessage(Messages.ConfigureIgnoresPage_2);
        this.setPageComplete(true);
        this.startJob = new Job(Messages.ConfigureIgnoresPage_INITIALIZE_JOB_TITLE){

            protected IStatus run(IProgressMonitor monitor) {
                ConfigureIgnoresForShareFilesPage.this.initializeIgnoreProvider(SubMonitor.convert((IProgressMonitor)monitor, (int)1).newChild(1));
                ConfigureIgnoresForShareFilesPage.this.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ConfigureIgnoresForShareFilesPage.this.needsRefresh) {
                            ConfigureIgnoresForShareFilesPage.this.needsRefresh = false;
                            ConfigureIgnoresForShareFilesPage.this.refresh();
                            ConfigureIgnoresForShareFilesPage.this.projectTree.getControl().setFocus();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.startJob.setSystem(true);
        this.startJob.setPriority(10);
    }

    private void updateResourceFilter() {
        if (this.filterButton.getSelection()) {
            this.projectTree.removeFilter((IFilter)this.projectTreeFilter);
        } else {
            this.projectTree.addFilter((IFilter)this.projectTreeFilter);
        }
    }

    private void importTeamIgnores() {
        RuleUpdateJob job = new RuleUpdateJob(this, Messages.ConfigureIgnoresPage_3){

            @Override
            protected void internalRun(IProgressMonitor progress) {
                IIgnoreInfo[] teamIgnores = Team.getAllIgnores();
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.ConfigureIgnoresPage_3, (int)teamIgnores.length);
                IIgnoreInfo[] iIgnoreInfoArray = teamIgnores;
                int n = teamIgnores.length;
                int n2 = 0;
                while (n2 < n) {
                    IIgnoreInfo info = iIgnoreInfoArray[n2];
                    if (info.getEnabled()) {
                        List rules = ignoresProvider.getIgnoreRulesFor(info.getPattern(), currentFiles, true);
                        try {
                            ignoresProvider.addIgnoreRules((Collection)rules, (IProgressMonitor)mon.newChild(1));
                        }
                        catch (FileSystemException e) {
                            StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)("Could not add pattern " + info.getPattern() + " to projects " + currentFiles), (Throwable)e);
                        }
                    } else {
                        mon.worked(1);
                    }
                    ++n2;
                }
            }
        };
        job.schedule();
    }

    private void addPattern() throws FileSystemException {
        final Collection<IgnoreRule> rules = this.displayIgnorePatternDialog();
        new RuleUpdateJob(this, Messages.ConfigureIgnoresPage_3){

            @Override
            protected void internalRun(IProgressMonitor progress) {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
                monitor.beginTask("", rules.size());
                for (IgnoreRule rule : rules) {
                    monitor.subTask(NLS.bind((String)Messages.ConfigureIgnoresPage_31, (Object)rule.getMatcher().getPattern()));
                    try {
                        ignoresProvider.addIgnoreRule((IIgnoreProvider.IIgnoreRule)rule, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (FileSystemException e) {
                        StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (int)4, (String)("Could not install ignore rule " + rule), (Throwable)e);
                    }
                }
            }
        }.schedule();
    }

    private void removePattern() {
        final IStructuredSelection selection = this.patterns.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.statusBar.setText(Messages.ConfigureIgnoresPage_7);
        new RuleUpdateJob(this, Messages.ConfigureIgnoresPage_7){

            @Override
            protected void internalRun(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selection.size());
                for (IgnoreRule rule : selection) {
                    try {
                        ignoresProvider.removeIgnoreRule((IIgnoreProvider.IIgnoreRule)rule, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (FileSystemException e) {
                        StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (int)4, (String)("Could not remove ignore rule " + rule), (Throwable)e);
                    }
                }
            }
        }.schedule();
    }

    private Collection<IgnoreRule> displayIgnorePatternDialog() throws FileSystemException {
        IgnorePatternDialog[] toQuery = new IgnorePatternDialog[1];
        int[] result = new int[]{-1};
        FileSystemException[] exception = new FileSystemException[1];
        ITreeSelection selection = this.projectTree.getSelection();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(selection.size());
        for (IResource resource : selection) {
            IShareable shareable = ShareablesUtil.getShareableWithoutSandbox(resource);
            shareables.add(shareable);
        }
        IgnorePatternDialog dialog = new IgnorePatternDialog(this.getShell(), shareables, (IIgnoreManager)this.ignoreManager, this.ignoresProvider);
        dialog.setBlockOnOpen(true);
        result[0] = dialog.open();
        toQuery[0] = dialog;
        if (exception[0] != null) {
            throw exception[0];
        }
        if (result[0] != 0) {
            throw new OperationCanceledException();
        }
        return toQuery[0].getRules();
    }

    private void setStatus(final String message) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ConfigureIgnoresForShareFilesPage.this.statusBar == null) {
                    return;
                }
                ConfigureIgnoresForShareFilesPage.this.statusBar.setText(message);
            }
        });
    }

    private void createAddPatternButtons(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        this.filterButton = new Button(buttonBar, 32);
        this.filterButton.setText(Messages.ConfigureIgnoresPage_11);
        this.filterButton.setSelection(false);
        this.filterButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigureIgnoresForShareFilesPage.this.updateResourceFilter();
            }
        });
        this.addPatternButton = new Button(buttonBar, 0);
        this.addPatternButton.setText(Messages.ConfigureIgnoresPage_12);
        this.addPatternButton.setToolTipText(Messages.ConfigureIgnoresPage_13);
        this.addPatternButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ConfigureIgnoresForShareFilesPage.this.addPattern();
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (FileSystemException e) {
                    StatusUtil.log((IStatus)FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)Messages.ConfigureIgnoresPage_14, (Throwable)e));
                    MessageDialog.openError((Shell)ConfigureIgnoresForShareFilesPage.this.getShell(), (String)Messages.ConfigureIgnoresPage_15, (String)Messages.ConfigureIgnoresPage_16);
                }
            }
        });
        this.addPatternButton.setEnabled(false);
        this.projectTree.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection selection = ConfigureIgnoresForShareFilesPage.this.projectTree.getSelection();
                for (Object item : selection.toList()) {
                    IResource resource = (IResource)item;
                    if (resource.getType() == 1 || resource.getType() == 2) continue;
                    ConfigureIgnoresForShareFilesPage.this.addPatternButton.setEnabled(false);
                    return;
                }
                ConfigureIgnoresForShareFilesPage.this.addPatternButton.setEnabled(ConfigureIgnoresForShareFilesPage.this.projectTree.getSelection().size() > 0);
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(buttonBar);
    }

    private Composite createRemovePatternButtons(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        this.importTeamIgnoresLink = new Link(buttonBar, 66);
        this.importTeamIgnoresLink.setText(Messages.ConfigureIgnoresPage_17);
        this.importTeamIgnoresLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigureIgnoresForShareFilesPage.this.importTeamIgnores();
            }
        });
        this.removePatternButton = new Button(buttonBar, 0);
        this.removePatternButton.setText(Messages.ConfigureIgnoresPage_18);
        this.removePatternButton.setToolTipText(Messages.ConfigureIgnoresPage_19);
        this.removePatternButton.setEnabled(false);
        this.removePatternButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigureIgnoresForShareFilesPage.this.removePattern();
            }
        });
        this.patterns.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigureIgnoresForShareFilesPage.this.removePatternButton.setEnabled(ConfigureIgnoresForShareFilesPage.this.patterns.getSelection().size() > 0);
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)this.importTeamIgnoresLink);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(buttonBar);
        return buttonBar;
    }

    public void createControl(Composite parent) {
        WidgetToolkit toolkit = WidgetToolkit.createSwtToolkit();
        GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getGroupMargins());
        Composite page = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)page);
        SashForm sash = new SashForm(page, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sash);
        Group groupProjects = new Group((Composite)sash, 0);
        groupProjects.setText(Messages.ConfigureIgnoresPage_20);
        Tree tree = toolkit.createTree((Composite)groupProjects, 2050);
        IgnoredResourceLabelProvider projectTreeLabelProvider = new IgnoredResourceLabelProvider(null, this.getShell().getDisplay().getSystemColor(9));
        this.projectTree = new SimpleTreeViewer(tree, (ITreeProvider)new ResourceTreeProvider((IOperationRunner)new JobRunner(Messages.ConfigureIgnoresPage_21, false)));
        this.projectTree.setInput(this.input.getFilesToShare());
        this.projectTree.setSorter((Comparator)ResourceComparator.getInstance());
        this.projectTree.setLabelProvider((IViewerLabelProvider)projectTreeLabelProvider);
        this.projectTree.addFilter((IFilter)this.projectTreeFilter);
        this.projectTree.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigureIgnoresForShareFilesPage.this.projectTreeSelectionChanged(event);
            }
        });
        this.input.getSelectedFiles().addChangeListener((IChangeListener)this);
        this.createAddPatternButtons((Composite)groupProjects);
        this.statusBar = new Label((Composite)groupProjects, 0x1000000);
        this.statusBar.setText(Messages.ConfigureIgnoresPage_22);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, this.guessItemHeightFor((Control)tree) * 4).applyTo((Control)tree);
        layoutFactory.copy().numColumns(2).generateLayout((Composite)groupProjects);
        Group groupPatterns = new Group((Composite)sash, 0);
        groupPatterns.setText(Messages.ConfigureIgnoresPage_23);
        Table table = new Table((Composite)groupPatterns, 68354);
        table.setHeaderVisible(true);
        this.patterns = new SimpleTableViewer(table, (Preferences)this.getConfigPrefs(), null);
        new LabelColumn(this.patterns, Messages.ConfigureIgnoresPage_24, 200, (IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                label.setText(((IgnoreRule)element).getMatcher().getPattern());
            }
        });
        new LabelColumn(this.patterns, Messages.ConfigureIgnoresPage_25, 75, (IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                label.setText(((IgnoreRule)element).isRecursive() ? Messages.ConfigureIgnoresPage_26 : Messages.ConfigureIgnoresPage_27);
            }
        });
        new LabelColumn(this.patterns, Messages.ConfigureIgnoresPage_28, 200, (IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                label.setText(((IgnoreRule)element).getRootShareableLocalPath().toString());
            }
        });
        this.createRemovePatternButtons((Composite)groupPatterns);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, this.guessItemHeightFor((Control)table) * 4).applyTo((Control)table);
        layoutFactory.generateLayout((Composite)groupPatterns);
        GridLayoutFactory.fillDefaults().numColumns(1).generateLayout(page);
        Dialog.applyDialogFont((Control)page);
        this.setControl((Control)page);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)page, "com.ibm.team.filesystem.ide.ui.wizard_share_configureignores");
    }

    public void dispose() {
        this.input.getSelectedFiles().removeChangeListener((IChangeListener)this);
        super.dispose();
    }

    private int guessItemHeightFor(Control control) {
        FontData[] data = control.getFont().getFontData();
        int maxHeight = -1;
        FontData[] fontDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData datum = fontDataArray[n2];
            maxHeight = Math.max(datum.getHeight(), maxHeight);
            ++n2;
        }
        return maxHeight;
    }

    private void projectTreeSelectionChanged(SelectionChangedEvent event) {
        ITreeSelection selection = this.projectTree.getSelection();
        final HashSet ignoreRules = new HashSet();
        for (Object item : selection.toList()) {
            IResource resource = (IResource)item;
            IShareable shareable = ShareablesUtil.getShareableWithoutSandbox(resource);
            IIgnoreManager.IIgnoreReason reason = this.ignoreManager.findIgnoreReasons(shareable, (IProgressMonitor)TempHelper.MONITOR);
            if (reason == null) continue;
            ignoreRules.addAll(reason.getRules());
        }
        if (ignoreRules.size() <= 0) {
            return;
        }
        this.patterns.setSelectionCriteria(new IFilter(){

            public boolean select(Object toTest) {
                return ignoreRules.contains(toTest);
            }
        });
        this.patterns.reveal(ignoreRules.iterator().next());
    }

    private void refresh() {
        IgnoresPatternQuery query;
        this.currentFiles = this.input.getFilesToShare();
        final Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        try {
            query = new IgnoresPatternQuery(shell.getDisplay(), this.ignoreManager, this.ignoresProvider);
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return;
        }
        this.projectTree.setInput(this.currentFiles);
        if (this.ignoreFileLocatorJob != null) {
            this.ignoreFileLocatorJob.cancel();
        }
        this.ignoreFileLocatorJob = new Job(Messages.ConfigureIgnoresPage_29){

            protected IStatus run(IProgressMonitor monitor) {
                query.init(null);
                ConfigureIgnoresForShareFilesPage.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ConfigureIgnoresForShareFilesPage.this.patterns == null) {
                            return;
                        }
                        ConfigureIgnoresForShareFilesPage.this.patterns.setInput((ISetWithListeners)query);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.ignoreFileLocatorJob.schedule();
        if (this.findIgnoreSetJob != null) {
            this.findIgnoreSetJob.cancel();
        }
        this.findIgnoreSetJob = new Job(Messages.ConfigureIgnoresPage_30){

            protected IStatus run(IProgressMonitor monitor) {
                final IgnoredItemSet ignoredItems = new IgnoredItemSet((IIgnoreManager)ConfigureIgnoresForShareFilesPage.this.ignoreManager);
                ignoredItems.addGenericListener((Object)"progress", new IListener(){

                    public void handleEvents(List events) {
                        for (IEvent genericEvent : events) {
                            IgnoredItemSet.IgnoredItemSetProgressEvent event = (IgnoredItemSet.IgnoredItemSetProgressEvent)genericEvent;
                            ConfigureIgnoresForShareFilesPage.this.setStatus(NLS.bind((String)Messages.ConfigureIgnoresPage_33, (Object)event.getIgnoreCount()));
                        }
                    }
                });
                ignoredItems.addGenericListener((Object)"complete", new IListener(){

                    public void handleEvents(List events) {
                        ConfigureIgnoresForShareFilesPage.this.setStatus(NLS.bind((String)Messages.ConfigureIgnoresPage_35, (Object)ignoredItems.getTotalIgnored()));
                    }
                });
                try {
                    ignoredItems.populateFrom((Collection)ConfigureIgnoresForShareFilesPage.this.currentFiles, monitor);
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
                boolean ran = ConfigureIgnoresForShareFilesPage.this.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ConfigureIgnoresForShareFilesPage.this.projectTree == null || ConfigureIgnoresForShareFilesPage.this.projectTree.getControl().isDisposed()) {
                            return;
                        }
                        ConfigureIgnoresForShareFilesPage.this.projectTreeFilter.setIgnoreItemSet(ignoredItems);
                        IgnoredResourceLabelProvider provider = new IgnoredResourceLabelProvider(ignoredItems, shell.getDisplay().getSystemColor(9));
                        provider.setIgnoreManager((IIgnoreManager)ConfigureIgnoresForShareFilesPage.this.ignoreManager);
                        ConfigureIgnoresForShareFilesPage.this.projectTree.setLabelProvider((IViewerLabelProvider)provider);
                        ConfigureIgnoresForShareFilesPage.this.projectTree.refresh();
                        ConfigureIgnoresForShareFilesPage.this.statusBar.setText(NLS.bind((String)Messages.ConfigureIgnoresPage_36, (Object)ignoredItems.getTotalIgnored()));
                    }
                });
                if (!ran) {
                    return Status.OK_STATUS;
                }
                ignoredItems.addGenericListener((Object[])IIgnoreEvent.ALL_EVENTS, new IListener(){

                    public void handleEvents(List events) {
                        ConfigureIgnoresForShareFilesPage.this.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (ConfigureIgnoresForShareFilesPage.this.projectTree == null || ConfigureIgnoresForShareFilesPage.this.projectTree.getControl().isDisposed()) {
                                    return;
                                }
                                ConfigureIgnoresForShareFilesPage.this.projectTree.refresh();
                                ConfigureIgnoresForShareFilesPage.this.statusBar.setText(NLS.bind((String)Messages.ConfigureIgnoresPage_38, (Object)ignoredItems.getTotalIgnored()));
                            }
                        });
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.findIgnoreSetJob.schedule();
    }

    private boolean syncExec(final Runnable r) {
        if (Display.getCurrent() != null) {
            r.run();
            return true;
        }
        final boolean[] result = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = ConfigureIgnoresForShareFilesPage.this.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                r.run();
                result[0] = true;
            }
        });
        return result[0];
    }

    private void asyncExec(final Runnable r) {
        if (Display.getCurrent() != null) {
            r.run();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = ConfigureIgnoresForShareFilesPage.this.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                r.run();
            }
        });
    }

    private void initializeIgnoreProvider(SubMonitor monitor) {
        this.ignoreManager = (IgnoreManager)IgnoreManager.getInstance().createCopy(Collections.singleton(new DefaultIgnoreProvider.IDefaultIgnoreProviderCopyReason(){

            public DefaultIgnoreProvider.IFilesystemAbstraction useFilesystemAbstraction(DefaultIgnoreProvider.IFilesystemAbstraction abs) {
                return new ReadThroughFilesystemAbstraction();
            }
        }), (IProgressMonitor)monitor.newChild(1));
        this.ignoresProvider = (DefaultIgnoreProvider)this.ignoreManager.getIgnoreProvider("default", (IProgressMonitor)monitor.newChild(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFinish(IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)4);
        int[] nArray = this.opCount;
        synchronized (this.opCount) {
            while (this.opCount[0] > 0) {
                try {
                    this.opCount.wait(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!progress.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (this.needsRefresh) {
                this.initializeIgnoreProvider(monitor.newChild(2));
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ConfigureIgnoresForShareFilesPage.this.needsRefresh = false;
                        ConfigureIgnoresForShareFilesPage.this.refresh();
                    }
                });
            }
            monitor.setWorkRemaining(1);
            ((ReadThroughFilesystemAbstraction)this.ignoresProvider.getFilesystem()).copyToDisk((IProgressMonitor)monitor.newChild(1));
            this.done();
            return;
        }
    }

    protected IEclipsePreferences getConfigPrefs() {
        return new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
    }

    public void performCancel() {
        this.done();
    }

    private void done() {
        if (this.ignoreManager != null) {
            this.ignoreManager.deallocate();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.startJob.schedule();
        }
    }

    public void handleChange(ChangeEvent event) {
        this.needsRefresh = true;
    }

    private abstract class RuleUpdateJob
    extends Job {
        public RuleUpdateJob(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean shouldSchedule() {
            boolean shouldSchedule = super.shouldSchedule();
            if (!shouldSchedule) return shouldSchedule;
            int[] nArray = ConfigureIgnoresForShareFilesPage.this.opCount;
            synchronized (ConfigureIgnoresForShareFilesPage.this.opCount) {
                ConfigureIgnoresForShareFilesPage.this.opCount[0] = ConfigureIgnoresForShareFilesPage.this.opCount[0] + 1;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return shouldSchedule;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final IStatus run(IProgressMonitor monitor) {
            try {
                this.internalRun(monitor);
            }
            catch (Throwable throwable) {
                int[] nArray = ConfigureIgnoresForShareFilesPage.this.opCount;
                synchronized (ConfigureIgnoresForShareFilesPage.this.opCount) {
                    ConfigureIgnoresForShareFilesPage.this.opCount[0] = ConfigureIgnoresForShareFilesPage.this.opCount[0] - 1;
                    ConfigureIgnoresForShareFilesPage.this.opCount.notifyAll();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    throw throwable;
                }
            }
            int[] nArray = ConfigureIgnoresForShareFilesPage.this.opCount;
            synchronized (ConfigureIgnoresForShareFilesPage.this.opCount) {
                ConfigureIgnoresForShareFilesPage.this.opCount[0] = ConfigureIgnoresForShareFilesPage.this.opCount[0] - 1;
                ConfigureIgnoresForShareFilesPage.this.opCount.notifyAll();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return Status.OK_STATUS;
            }
        }

        protected abstract void internalRun(IProgressMonitor var1);
    }
}

