/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.SharingWizardInput;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class UnsharedProjectSelectionPage
extends WizardPage
implements IChangeListener {
    private CheckboxTableViewer viewer;
    private Label selectedCountLabel;
    private final SharingWizardInput input;

    public UnsharedProjectSelectionPage(String pageName, String title, ImageDescriptor titleImage, SharingWizardInput input) {
        super(pageName, title, titleImage);
        this.input = input;
        this.setDescription(Messages.UnsharedProjectSelectionPage_pageDescription);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label l = new Label(composite, 0);
        l.setText(Messages.UnsharedProjectSelectionPage_availableUnsharedProjects);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)l);
        this.viewer = new CheckboxTableViewer(new Table(composite, 2850));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.viewer.setInput(this.input.getUnsharedProjects());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    if (event.getChecked()) {
                        UnsharedProjectSelectionPage.this.input.getSelectedProjects().add((Object)project);
                    } else {
                        UnsharedProjectSelectionPage.this.input.getSelectedProjects().remove((Object)project);
                    }
                }
            }
        });
        Composite buttonsComposite = new Composite(composite, 0);
        Button selectAllButton = new Button(buttonsComposite, 8);
        selectAllButton.setText(Messages.UnsharedProjectSelectionPage_selectAll);
        selectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnsharedProjectSelectionPage.this.input.getSelectedProjects().addAll(UnsharedProjectSelectionPage.this.input.getUnsharedProjects());
            }
        });
        Button deselectAllButton = new Button(buttonsComposite, 8);
        deselectAllButton.setText(Messages.UnsharedProjectSelectionPage_deselectAll);
        deselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnsharedProjectSelectionPage.this.input.getSelectedProjects().clear();
            }
        });
        this.input.getSelectedProjects().addChangeListener((IChangeListener)this);
        GridLayoutFactory.fillDefaults().generateLayout(buttonsComposite);
        this.selectedCountLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)l);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        this.setControl((Control)composite);
        this.updateCheckedProjects();
        this.updateEnablements();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_share_selectprojects");
    }

    private void updateCheckedProjects() {
        this.viewer.setCheckedElements(this.input.getSelectedProjects().toArray(new Object[this.input.getSelectedProjects().size()]));
    }

    private void updateEnablements() {
        this.updateSelectedCountLabel();
        this.updatePageComplete();
    }

    private void updateSelectedCountLabel() {
        this.selectedCountLabel.setText(NLS.bind((String)Messages.UnsharedProjectSelectionPage_selectionCountLabelFormat, (Object)this.input.getSelectedProjects().size(), (Object)this.input.getUnsharedProjects().size()));
    }

    private void updatePageComplete() {
        this.setPageComplete(this.input.getSelectedProjects().size() > 0);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.viewer.getControl().setFocus();
        }
    }

    public void handleChange(ChangeEvent event) {
        this.updateCheckedProjects();
        this.updateEnablements();
    }

    public void dispose() {
        this.input.getSelectedProjects().removeChangeListener((IChangeListener)this);
        super.dispose();
    }
}

