/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.filesystem.ui.views.IFilteredTreeProvider;
import com.ibm.team.filesystem.ui.views.PlaceHoldersTreeProvider;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.ComponentShortLabelProvider;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.TeamAreaSelection;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.FilteredSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class TeamAreaSelectionPart {
    private Composite composite;
    private AbstractRepositoryTreeProvider treeProvider;
    private IOperationRunner runner;
    private Text fFilter;
    private Runnable timerRunnable;
    private CLabel filterStatus;
    private PlaceHoldersTreeProvider placeHoldersProvider;
    private SimpleTreeViewer stv;
    private Button newComponent;
    private Button newFolder;
    private boolean folderSelection;
    private AbstractPlaceWrapper componentParent;
    private WorkspaceComponentWrapper component;
    private Object selection;
    private GridData tableData;
    private Tree errorTable;
    private GridData errorTableData;
    private volatile Display display;
    private IListener loginListener = new IListener(){

        public void handleEvents(List events) {
            SWTUtil.runOnce((Display)TeamAreaSelectionPart.this.display, (Runnable)TeamAreaSelectionPart.this.updateRunnable);
        }
    };
    private Runnable updateRunnable = new Runnable(){

        @Override
        public void run() {
            if (TeamAreaSelectionPart.this.stv.getControl().isDisposed()) {
                return;
            }
            TeamAreaSelectionPart.this.updateErrorMessage();
        }
    };

    public TeamAreaSelectionPart(Composite parent, WidgetFactoryContext context, AbstractRepositoryTreeProvider treeProvider, boolean folderSelection, boolean hideBaselineNames) {
        this.folderSelection = folderSelection;
        this.treeProvider = treeProvider;
        this.runner = context.getBackgroundOperationRunner();
        this.display = Display.getCurrent();
        WidgetToolkit toolkit = context.getToolkit();
        MnemonicGenerator mnemonics = context.getMnemonics();
        this.composite = toolkit.createComposite(parent);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TeamAreaSelectionPart.this.dispose();
            }
        });
        toolkit.createLabel(this.composite, mnemonics.generate(Messages.PlaceSearchCriteriaPart_workspaceNameFieldLabel));
        this.createFilter(this.composite, treeProvider, toolkit);
        this.placeHoldersProvider = new PlaceHoldersTreeProvider(treeProvider, this.runner, folderSelection);
        this.stv = new SimpleTreeViewer(this.composite, (ITreeProvider)this.placeHoldersProvider, 2820);
        MixedTypeLabelProvider mixedTypeLabelProvider = new MixedTypeLabelProvider();
        if (hideBaselineNames) {
            ComponentShortLabelProvider componentLabelProvider = new ComponentShortLabelProvider((ISetWithListeners)FilteredSetWithListeners.createTypeFilter((ISetWithListeners)this.stv.getKnownElements(), ComponentWrapper.class), this.runner);
            mixedTypeLabelProvider.put(WorkspaceComponentWrapper.class, (IViewerLabelProvider)componentLabelProvider);
        }
        mixedTypeLabelProvider.put(PlaceHoldersTreeProvider.PlaceHolder.class, (IViewerLabelProvider)new PlaceHoldersTreeProvider.PlaceHolderLabelProvider());
        mixedTypeLabelProvider.put(Object.class, LabelProviders.create((ISetWithListeners)this.stv.getKnownElements()));
        this.stv.setLabelProvider((IViewerLabelProvider)mixedTypeLabelProvider);
        GridDataFactory tableDataFactory = GridDataFactory.defaultsFor((Control)this.stv.getControl());
        this.tableData = tableDataFactory.create();
        this.stv.getControl().setLayoutData((Object)this.tableData);
        this.errorTable = new Tree(this.composite, this.stv.getControl().getStyle());
        TreeItem item = new TreeItem(this.errorTable, 0);
        item.setText(Messages.TeamAreaSelectionPart_0);
        this.errorTable.setBackground(this.stv.getControl().getBackground());
        this.errorTable.setFont(this.stv.getControl().getFont());
        this.errorTable.setVisible(false);
        this.errorTableData = tableDataFactory.create();
        this.errorTableData.exclude = true;
        this.errorTable.setLayoutData((Object)this.errorTableData);
        Composite buttons = new Composite(this.composite, 0);
        this.newComponent = new Button(buttons, 8);
        this.newComponent.setText(mnemonics.generate(Messages.TeamAreaSelectionPart_newComponentButton));
        this.newComponent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TeamAreaSelectionPart.this.componentParent == null) {
                    return;
                }
                InputDialog inputDialog = new InputDialog(TeamAreaSelectionPart.this.composite.getShell(), Messages.TeamAreaSelectionPart_newComponentDialogTitle, Messages.TeamAreaSelectionPart_newComponentDialogText, Messages.TeamAreaSelectionPart_newComponentDialogDefaultComponentName, new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.equals("")) {
                            return Messages.TeamAreaSelectionPart_newComponentDialogBlankNameError;
                        }
                        return null;
                    }
                });
                if (inputDialog.open() == 0) {
                    String name = inputDialog.getValue();
                    final Display display = TeamAreaSelectionPart.this.newComponent.getDisplay();
                    Tree control = TeamAreaSelectionPart.this.stv.getTree();
                    TeamAreaSelectionPart.this.runner.enqueue("", (Operation)new RepositoryOperation((Control)control, name){
                        private final /* synthetic */ Control val$control;
                        private final /* synthetic */ String val$name;
                        {
                            this.val$control = control;
                            this.val$name = string;
                        }

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                            SWTUtil.greedyExec((Display)display, (Control)this.val$control, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TreePath parentPath = (TreePath)TeamAreaSelectionPart.this.stv.getPathsInSelection((ISelection)TeamAreaSelectionPart.this.stv.getSelection()).get(0);
                                    while (parentPath.getLastSegment() != TeamAreaSelectionPart.this.componentParent) {
                                        parentPath = parentPath.getParentPath();
                                    }
                                    PlaceHoldersTreeProvider.PlaceHolder placeHolder = TeamAreaSelectionPart.this.placeHoldersProvider.addPlaceHolder((Object)TeamAreaSelectionPart.this.componentParent, val$name);
                                    TreePath path = parentPath.createChildPath((Object)placeHolder);
                                    TeamAreaSelectionPart.this.stv.selectAndReveal((ITreeSelection)new TreeSelection(path));
                                }
                            });
                        }
                    });
                }
            }
        });
        if (folderSelection) {
            this.newFolder = new Button(buttons, 8);
            this.newFolder.setText(mnemonics.generate(Messages.TeamAreaSelectionPart_newFolderButton));
            this.newFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (TeamAreaSelectionPart.this.componentParent == null) {
                        return;
                    }
                    final Object parent = TeamAreaSelectionPart.this.getSelection();
                    final boolean windows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
                    InputDialog inputDialog = new InputDialog(TeamAreaSelectionPart.this.composite.getShell(), Messages.TeamAreaSelectionPart_newFolderDialogTitle, Messages.TeamAreaSelectionPart_newFolderDialogText, Messages.TeamAreaSelectionPart_newFolderDialogDefaultFolderName, new IInputValidator(){

                        public String isValid(String newText) {
                            IStatus status = ResourcesPlugin.getWorkspace().validateName(newText, 2);
                            if (!status.isOK()) {
                                return status.getMessage();
                            }
                            ISetWithListeners siblings = TeamAreaSelectionPart.this.stv.getKnownChildren(parent);
                            for (Object sibling : siblings.toCollection()) {
                                FolderItemWrapper folderWrapper;
                                String name;
                                if (!(sibling instanceof FolderItemWrapper) || !(name = (folderWrapper = (FolderItemWrapper)((Object)sibling)).getName()).equals(newText) && (!windows || !name.equalsIgnoreCase(newText))) continue;
                                return NLS.bind((String)Messages.TeamAreaSelectionPart_fileAlreadyExistsErrorMessage, (Object)newText);
                            }
                            return null;
                        }
                    });
                    if (inputDialog.open() == 0) {
                        String name = inputDialog.getValue();
                        PlaceHoldersTreeProvider.PlaceHolder placeHolder = TeamAreaSelectionPart.this.placeHoldersProvider.addPlaceHolder(parent, name);
                        TreePath path = ((TreePath)TeamAreaSelectionPart.this.stv.getPathsInSelection((ISelection)TeamAreaSelectionPart.this.stv.getSelection()).get(0)).createChildPath((Object)placeHolder);
                        TeamAreaSelectionPart.this.stv.selectAndReveal((ITreeSelection)new TreeSelection(path));
                    }
                }
            });
        }
        this.addStatusListener(this.composite, this.stv, treeProvider);
        Dialog.applyDialogFont((Control)this.composite);
        GridLayoutFactory.fillDefaults().generateLayout(buttons);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(this.composite);
    }

    private void createFilter(Composite parent, AbstractRepositoryTreeProvider treeProvider, WidgetToolkit toolkit) {
        if (!(treeProvider instanceof IFilteredTreeProvider)) {
            return;
        }
        this.fFilter = toolkit.createText(parent, "");
        this.fFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fFilter.addModifyListener(this::patternChanged);
    }

    private void patternChanged(final ModifyEvent event) {
        if (this.timerRunnable == null) {
            this.timerRunnable = new Runnable(){

                @Override
                public void run() {
                    Text text = (Text)event.widget;
                    if (!text.isDisposed() && TeamAreaSelectionPart.this.placeHoldersProvider != null && TeamAreaSelectionPart.this.stv != null) {
                        ((IFilteredTreeProvider)((Object)TeamAreaSelectionPart.this.treeProvider)).setFilterText(text.getText());
                        TeamAreaSelectionPart.this.placeHoldersProvider = new PlaceHoldersTreeProvider(TeamAreaSelectionPart.this.treeProvider, TeamAreaSelectionPart.this.runner, TeamAreaSelectionPart.this.folderSelection);
                        TeamAreaSelectionPart.this.stv.setTreeProvider((ITreeProvider)TeamAreaSelectionPart.this.placeHoldersProvider);
                    }
                }
            };
        }
        event.widget.getDisplay().timerExec(500, this.timerRunnable);
    }

    private void addStatusListener(Composite parent, SimpleTreeViewer stv, AbstractRepositoryTreeProvider treeProvider) {
        if (!(treeProvider instanceof IFilteredTreeProvider)) {
            return;
        }
        this.filterStatus = new CLabel(parent, 0);
        this.filterStatus.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        this.filterStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.filterStatus.setText(NLS.bind((String)Messages.PlaceSearchCriteriaPart_refineSearch, (Object)512));
        this.filterStatus.setVisible(false);
        ((GridData)this.filterStatus.getLayoutData()).exclude = true;
        ((IFilteredTreeProvider)((Object)treeProvider)).setMaxResults(512);
        stv.addListener(e -> {
            if (!this.filterStatus.isDisposed()) {
                boolean hideInfo;
                ((GridData)this.filterStatus.getLayoutData()).exclude = hideInfo = e.getObservableSet().size() < 512;
                this.filterStatus.setVisible(!hideInfo);
                this.filterStatus.getParent().layout();
            }
        });
    }

    protected void dispose() {
        this.setInput(null);
    }

    public Object getSelection() {
        Object element = this.stv.getSelection().getFirstElement();
        this.selection = element instanceof WorkspaceComponentWrapper || element instanceof FolderItemWrapper || element instanceof PlaceHoldersTreeProvider.PlaceHolder ? element : null;
        return this.selection;
    }

    public List<TreePath> getTreePaths() {
        return this.stv.getPathsInSelection((ISelection)this.stv.getSelection());
    }

    public <T> List<T> getSelection(Class<T> cls) {
        return JFaceUtils.getSelected((ITreeSelection)this.stv.getSelection(), cls);
    }

    public void setDoubleClickHandler(ITreePathRunnable runnable) {
        this.stv.setDoubleClickHandler(runnable);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.stv.getSelectionProvider().addSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.stv.getSelectionProvider().setSelection(selection);
    }

    public void expandMatching(IFilter elementFilter) {
        this.stv.expandMatching(elementFilter);
    }

    public void setFocus() {
        this.stv.getTree().setFocus();
    }

    public void setInput(ITeamRepository input) {
        ITeamRepository oldInput = this.getRepository();
        if (oldInput == input) {
            return;
        }
        if (oldInput != null) {
            oldInput.removeGenericListener((Object)"state", this.loginListener);
        }
        this.stv.setInput((Object)input);
        if (input != null) {
            input.addGenericListener((Object)"state", this.loginListener);
        }
        this.updateErrorMessage();
    }

    private ITeamRepository getRepository() {
        ITeamRepository oldInput = (ITeamRepository)this.stv.getInput();
        return oldInput;
    }

    private void updateErrorMessage() {
        boolean loggedIn;
        ITeamRepository repo = this.getRepository();
        boolean bl = loggedIn = repo != null && repo.loggedIn();
        if (loggedIn == this.errorTableData.exclude) {
            return;
        }
        this.errorTableData.exclude = loggedIn;
        this.tableData.exclude = !loggedIn;
        this.stv.getTree().setVisible(loggedIn);
        this.errorTable.setVisible(!loggedIn);
        this.composite.layout(true);
    }

    public ITeamRepository getInput() {
        return (ITeamRepository)this.stv.getInput();
    }

    public void toggleExpandedState(TreePath element) {
        this.stv.toggleExpandedState(element);
    }

    public void setSorter(Comparator comparator) {
        this.stv.setSorter(comparator);
    }

    public void setEnabled(boolean enabled) {
        this.composite.setEnabled(enabled);
        if (this.fFilter != null) {
            this.fFilter.setEnabled(enabled);
        }
        this.stv.getControl().setEnabled(enabled);
        if (enabled) {
            this.selection = this.getSelection();
            List<AbstractPlaceWrapper> places = this.getSelection(AbstractPlaceWrapper.class);
            this.componentParent = places.size() == 1 ? places.get(0) : null;
            List<WorkspaceComponentWrapper> components = this.getSelection(WorkspaceComponentWrapper.class);
            this.component = components.size() == 1 ? components.get(0) : null;
            this.newComponent.setEnabled(this.componentParent != null);
            if (this.folderSelection) {
                this.newFolder.setEnabled(this.selection != null);
            }
        } else {
            this.newComponent.setEnabled(false);
            if (this.folderSelection) {
                this.newFolder.setEnabled(false);
            }
        }
    }

    public TeamAreaSelection getTeamAreaSelection() {
        if (this.selection instanceof PlaceHoldersTreeProvider.PlaceHolder && this.placeHoldersProvider.getRootParent() == this.componentParent) {
            return new TeamAreaSelection(this.componentParent, this.getPath());
        }
        return new TeamAreaSelection(this.componentParent, this.component, this.getParentFolder(), this.getPath());
    }

    private IFolderHandle getParentFolder() {
        if (this.selection instanceof PlaceHoldersTreeProvider.PlaceHolder) {
            return this.getParentFolder(this.placeHoldersProvider.getRootParent());
        }
        return this.getParentFolder(this.selection);
    }

    private IFolderHandle getParentFolder(Object element) {
        if (element instanceof FolderItemWrapper) {
            FolderItemWrapper wrapper = (FolderItemWrapper)((Object)element);
            return (IFolderHandle)wrapper.getItem().toHandle();
        }
        if (element instanceof WorkspaceComponentWrapper) {
            WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)element;
            return wrapper.getComponent().getRootFolder();
        }
        throw new IllegalStateException();
    }

    private String[] getPath() {
        if (this.selection instanceof PlaceHoldersTreeProvider.PlaceHolder) {
            ArrayList<String> path = new ArrayList<String>();
            PlaceHoldersTreeProvider.PlaceHolder[] placeHolderArray = this.placeHoldersProvider.getPlaceHolders();
            int n = placeHolderArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlaceHoldersTreeProvider.PlaceHolder placeHolder = placeHolderArray[n2];
                path.add(placeHolder.toString());
                if (placeHolder == this.selection) break;
                ++n2;
            }
            return path.toArray(new String[path.size()]);
        }
        return new String[0];
    }
}

