/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing;

import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class TeamAreaSelection {
    private AbstractPlaceWrapper place;
    private WorkspaceComponentWrapper component;
    private String componentName;
    private IFolderHandle parentFolder;
    private String[] path;

    public TeamAreaSelection(AbstractPlaceWrapper place, String[] path) {
        this(place, null, null, path);
    }

    public TeamAreaSelection(AbstractPlaceWrapper place, WorkspaceComponentWrapper component, IFolderHandle parentFolder, String[] path) {
        this.place = place;
        this.component = component;
        this.parentFolder = parentFolder;
        if (component == null) {
            this.componentName = path[0];
            this.path = new String[path.length - 1];
            if (this.path.length > 0) {
                System.arraycopy(path, 1, this.path, 0, this.path.length);
            }
        } else {
            this.componentName = component.getComponent().getName();
            this.path = path;
        }
    }

    public AbstractPlaceWrapper getPlace() {
        return this.place;
    }

    public WorkspaceComponentWrapper getComponent() {
        return this.component;
    }

    public WorkspaceComponentWrapper getComponent(ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.component != null) {
            return this.component;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.TeamAreaSelectionPart_newFolderDialogProgressString, (int)30);
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceConnection workspace = this.place.getWorkspaceConnection((IProgressMonitor)sub.newChild(10));
        IComponent createdComponent = mgr.createComponent(this.componentName, (IAuditableHandle)repo.loggedInContributor(), (IProgressMonitor)sub.newChild(10));
        workspace.addComponent((IComponentHandle)createdComponent, false, (IProgressMonitor)sub.newChild(10));
        this.component = WorkspaceComponentWrapper.newWrapper(workspace, createdComponent);
        if (this.parentFolder == null) {
            this.parentFolder = createdComponent.getRootFolder();
        }
        return this.component;
    }

    public IFolderHandle getParentFolder() {
        if (this.parentFolder == null) {
            throw new IllegalStateException();
        }
        return this.parentFolder;
    }

    public String[] getPath() {
        return this.path;
    }

    public String getComponentName() {
        return this.componentName;
    }
}

