/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing;

import com.ibm.team.filesystem.client.CopyFileAreaLockedByOtherProcess;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.rcp.core.internal.resources.ApoRepositoryProvider;
import com.ibm.team.filesystem.rcp.ui.internal.util.PropertyChangeNotifier;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.TeamAreaSelection;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;

public class SharingWizardInput
extends PropertyChangeNotifier {
    private final IProject seedProject;
    private final WritableSet selectedProjects = new WritableSet();
    private final Map<IProject, ProjectDescription> unsharedProjects = new HashMap<IProject, ProjectDescription>();

    public SharingWizardInput(IProject seedProject) {
        this(new IProject[]{seedProject});
    }

    public SharingWizardInput(IProject[] projects) {
        this.buildProjectDescriptions(projects);
        IProject tempSeed = null;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.selectedProjects.add((Object)project);
            if (tempSeed == null && !this.isDescendantOfShare(project)) {
                tempSeed = project;
            }
            ++n2;
        }
        this.seedProject = tempSeed == null ? projects[0] : tempSeed;
    }

    public void buildProjectDescriptions(final IProject[] projects) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SharingWizardInput.this.buildProjectDescriptions(projects, monitor);
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            String message = this.getMessage(cause);
            ErrorDialog.openError(null, null, (String)message, (IStatus)StatusUtil.newStatus((Object)((Object)this), (String)cause.getMessage(), (Throwable)cause));
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    private String getMessage(Throwable cause) {
        if (cause instanceof CopyFileAreaLockedByOtherProcess) {
            return Messages.SharingWizardInput_SandboxInUse;
        }
        return null;
    }

    protected void buildProjectDescriptions(IProject[] seedProjects, IProgressMonitor monitor) throws FileSystemException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(projects.length * 3));
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (this.isUnshared(project)) {
                try {
                    ProjectDescription desc = new ProjectDescription(project, progress.newChild(3));
                    this.unsharedProjects.put(project, desc);
                }
                catch (FileSystemException e) {
                    if (this.isSeedProject(seedProjects, project)) {
                        throw e;
                    }
                    StatusUtil.log((IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                }
            } else {
                progress.worked(3);
            }
            ++i;
        }
    }

    private boolean isSeedProject(IProject[] seedProjects, IProject project) {
        IProject[] iProjectArray = seedProjects;
        int n = seedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject sp = iProjectArray[n2];
            if (sp.equals((Object)project)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IProject getSeedProject() {
        return this.seedProject;
    }

    public WritableSet getSelectedProjects() {
        return this.selectedProjects;
    }

    public Collection<IProject> getUnsharedProjects() {
        boolean descendantOfShare = this.isDescendantOfShare(this.getSeedProject());
        HashSet<IProject> result = new HashSet<IProject>();
        for (ProjectDescription desc : this.unsharedProjects.values()) {
            if (descendantOfShare && !desc.isDescendantOfShare) continue;
            result.add(desc.project);
        }
        return result;
    }

    private boolean isUnshared(IProject project) {
        return project.isOpen() && project.getLocation() != null && RepositoryProvider.getProvider((IProject)project) == null;
    }

    public Collection<IProject> getProjectsToConnect() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IProject project : this.selectedProjects) {
            if (!this.isDescendantOfShare(project) && !this.containsShare(project)) continue;
            result.add(project);
        }
        return result;
    }

    public void autoconnectProjects(final Collection<IProject> projectsToConnect, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        try {
            final TeamRepositoryException[] exception = new TeamRepositoryException[1];
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    HashMap groupedByCfa = SharingWizardInput.this.groupByCFA(projectsToConnect);
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)groupedByCfa.size());
                    try {
                        for (Map.Entry entry : groupedByCfa.entrySet()) {
                            Collection errors = ApoRepositoryProvider.map((ILocation)((ILocation)entry.getKey()), (Collection)((Collection)entry.getValue()), (IProgressMonitor)progress.newChild(1));
                            if (errors.isEmpty()) continue;
                            throw new FileSystemStatusException(StatusUtil.newStatus((Object)this, (String)Messages.SharingWizardInput_AutoconnectErrorMessage, (Collection)errors));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        exception[0] = e;
                    }
                }
            }, monitor);
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (CoreException e) {
            this.asFileSystemStatusException(e);
        }
    }

    private void asFileSystemStatusException(CoreException e) throws FileSystemException {
        throw FileSystemStatusException.fromCoreException(null, (CoreException)e);
    }

    private HashMap<ILocation, Collection<IProject>> groupByCFA(Collection<IProject> projectsToConnect) {
        HashMap<ILocation, Collection<IProject>> result = new HashMap<ILocation, Collection<IProject>>();
        for (IProject project : projectsToConnect) {
            IShareable shareable = this.getShareable(project);
            if (shareable == null) continue;
            ILocation cfaPath = shareable.getSandbox().getRoot();
            Collection<IProject> cfaProjects = result.get(cfaPath);
            if (cfaProjects == null) {
                cfaProjects = new ArrayList<IProject>();
                result.put(cfaPath, cfaProjects);
            }
            cfaProjects.add(project);
        }
        return result;
    }

    public List<IProject> getProjectsToShare() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IProject project : this.selectedProjects) {
            if (this.isSharedInSandbox(project) || this.isDescendantOfShare(project) || this.containsShare(project)) continue;
            result.add(project);
        }
        return result;
    }

    public boolean isAutoconnect() {
        return this.isSharedInSandbox(this.getSeedProject()) || this.isDescendantOfShare(this.getSeedProject()) || this.containsShare(this.getSeedProject());
    }

    public IShareable getShareable(IProject project) {
        ProjectDescription projectDescription = this.unsharedProjects.get(project);
        return projectDescription.shareable;
    }

    private boolean isDescendantOfShare(IProject project) {
        ProjectDescription projectDescription = this.unsharedProjects.get(project);
        if (projectDescription != null) {
            return projectDescription.isDescendantOfShare;
        }
        return false;
    }

    public boolean isSharedInSandbox(IProject project) {
        ProjectDescription projectDescription = this.unsharedProjects.get(project);
        if (projectDescription != null) {
            return projectDescription.isSharedInSandbox;
        }
        return false;
    }

    public boolean containsShare(IProject project) {
        ProjectDescription projectDescription = this.unsharedProjects.get(project);
        if (projectDescription != null) {
            return projectDescription.containsShare;
        }
        return false;
    }

    public boolean hasMultipleCandidates() {
        return this.getUnsharedProjects().size() > 1;
    }

    private static class ProjectDescription {
        private IProject project;
        private boolean isDescendantOfShare;
        private IShareable shareable;
        private boolean isSharedInSandbox;
        private boolean containsShare;

        public ProjectDescription(IProject project, SubMonitor progress) throws FileSystemException {
            this.initialize(project, progress);
        }

        private void initialize(IProject project, SubMonitor progress) throws FileSystemException {
            progress.setWorkRemaining(3);
            this.project = project;
            this.shareable = this.getShareable(project, (IProgressMonitor)progress.newChild(1));
            if (this.shareable == null) {
                Collection sandboxes = FileSystemCore.getSharingManager().getRegisteredSandboxes();
                IPath projectPath = project.getLocation();
                if (projectPath != null) {
                    for (ISandbox sandbox : sandboxes) {
                        IPath sandboxPath = (IPath)sandbox.getRoot().getAdapter(IPath.class);
                        if (sandboxPath == null || !projectPath.isPrefixOf(sandboxPath)) continue;
                        throw new FileSystemException(NLS.bind((String)Messages.SharingWizardInput_ProjectContainsSandbox, (Object)project.getName(), (Object)sandboxPath.toString()));
                    }
                }
            } else {
                if (this.shareable.getLocalPath().isEmpty()) {
                    throw new FileSystemException(NLS.bind((String)Messages.SharingWizardInput_ProjectContainsSandbox, (Object)project.getName(), (Object)project.getLocation().toString()));
                }
                this.isDescendantOfShare = this.isDescendantOfShare(this.shareable, (IProgressMonitor)progress.newChild(1));
                this.isSharedInSandbox = this.isSharedInSandbox(this.shareable, (IProgressMonitor)progress.newChild(1));
                if (!this.isDescendantOfShare && !this.isSharedInSandbox) {
                    this.containsShare = this.containsShare(this.shareable, progress.newChild(1));
                }
            }
        }

        private IShareable getShareable(IProject project, IProgressMonitor monitor) throws FileSystemException {
            PathLocation projectLocation;
            ISandbox sandbox;
            IShareable shareable = this.findShareable(project);
            if (shareable != null) {
                return shareable;
            }
            IPath projectPath = project.getLocation();
            if (projectPath != null && (sandbox = this.findSandbox((ILocation)(projectLocation = new PathLocation(projectPath.removeLastSegments(1))))) != null) {
                FileSystemCore.getSharingManager().register(sandbox, true, monitor);
                return this.findShareable(project);
            }
            return null;
        }

        private IShareable findShareable(IProject project) {
            Object adapter = project.getAdapter(IShareable.class);
            if (adapter instanceof IShareable) {
                IShareable shareable = (IShareable)adapter;
                return shareable;
            }
            return null;
        }

        private ISandbox findSandbox(ILocation location) {
            if (location.isEmpty()) {
                return null;
            }
            ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(location, false);
            if (sandbox.isExistingSandbox()) {
                return sandbox;
            }
            return this.findSandbox(location.getParent());
        }

        private boolean isSharedInSandbox(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
            return shareable != null && shareable.getRemote(monitor) != null;
        }

        private boolean isDescendantOfShare(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
            return shareable != null && shareable.getShare(monitor) != null;
        }

        private boolean containsShare(IShareable shareable, SubMonitor progress) throws FileSystemException {
            if (shareable != null) {
                IShare[] allShares;
                IShare[] iShareArray = allShares = shareable.getSandbox().allShares((IProgressMonitor)progress);
                int n = allShares.length;
                int n2 = 0;
                while (n2 < n) {
                    IShare share = iShareArray[n2];
                    if (shareable.getLocalPath().isPrefixOf(share.getPath())) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    public static class TargetWorkspaceConfiguration {
        private String workspaceName;
        private boolean creatingNewWorkspace;
        private boolean collaborate;
        private TeamAreaSelection teamAreaSelection;
        private ITeamRepository repository;

        public String getWorkspaceName() {
            return this.workspaceName;
        }

        public void setWorkspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        public boolean isCreatingNewWorkspace() {
            return this.creatingNewWorkspace;
        }

        public void setCreatingNewWorkspace(boolean creatingNewWorkspace) {
            this.creatingNewWorkspace = creatingNewWorkspace;
        }

        public boolean isCollaborate() {
            return this.collaborate;
        }

        public void setCollaborate(boolean collaborate) {
            this.collaborate = collaborate;
        }

        public TeamAreaSelection getTeamAreaSelection() {
            return this.teamAreaSelection;
        }

        public void setTeamAreaSelection(TeamAreaSelection teamAreaSelection) {
            this.teamAreaSelection = teamAreaSelection;
        }

        public ITeamRepository getRepository() {
            return this.repository;
        }

        public void setRepository(ITeamRepository repo) {
            this.repository = repo;
        }
    }
}

