/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxShare;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.util.StatusDialog;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.ignore.ConfigureIgnoresPage;
import com.ibm.team.internal.filesystem.ui.util.SymbolicLinkDetailsDialog;
import com.ibm.team.internal.filesystem.ui.util.WarnShareUser;
import com.ibm.team.internal.filesystem.ui.wizards.TeamAreaSelectionPage;
import com.ibm.team.internal.filesystem.ui.wizards.TeamPlaceSelectionPage;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.AutoconnectProjectPage;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.SharingWizardInput;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.UnsharedProjectSelectionPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.repository.rcp.ui.wizards.ChainedWizard;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.IConfigurationWizardExtension;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SharingWizard
extends ChainedWizard
implements IConfigurationWizard,
IAdaptable {
    private TeamPlaceSelectionPage teamPlacePage;
    private TeamAreaSelectionPage teamAreaPickerPage;
    private AutoconnectProjectPage autoConnectPage;
    private UnsharedProjectSelectionPage projectSelectionPage;
    private ConfigureIgnoresPage configureIgnoresPage;
    private SharingWizardInput input;
    private IWizardPage tempPage = new BaseWizardPage("temp", "temp", null){

        protected void createBody(Composite parent) {
            SharingWizard.this.initialized();
        }
    };

    public void addPages() {
        ImageDescriptor banner = ImagePool.WIZ_SHARING;
        this.setWindowTitle(Messages.SharingWizard_shareProjectsWindowTitle);
        if (this.input.isAutoconnect()) {
            this.autoConnectPage = new AutoconnectProjectPage("AutoconnectPage", this.input, banner);
            this.addPage((IWizardPage)this.autoConnectPage);
        } else {
            this.teamPlacePage = new TeamPlaceSelectionPage("TeamPlacePage", Messages.SharingWizard_selectComponentPageName, banner, true, "com.ibm.team.filesystem.ide.ui.page_teamplaceselection_sharing");
            this.teamPlacePage.setDescription(Messages.SharingWizard_selectComponentPageDescription);
            this.addPage((IWizardPage)this.teamPlacePage);
            this.teamAreaPickerPage = new TeamAreaSelectionPage(this.teamPlacePage);
            this.addPage((IWizardPage)this.teamAreaPickerPage);
            this.configureIgnoresPage = new ConfigureIgnoresPage(this.input);
            this.addPage((IWizardPage)this.configureIgnoresPage);
        }
        this.projectSelectionPage = new UnsharedProjectSelectionPage("UnsharedProjectsPage", Messages.SharingWizard_unsharedProjectsPageName, banner, this.input);
        this.addPage((IWizardPage)this.projectSelectionPage);
        super.addPages();
        this.addPage(this.tempPage);
    }

    public boolean performCancel() {
        try {
            boolean bl = super.performCancel();
            return bl;
        }
        finally {
            if (this.configureIgnoresPage != null) {
                this.configureIgnoresPage.performCancel();
            }
        }
    }

    public boolean performFinish() {
        SharingWizardInput.TargetWorkspaceConfiguration twc;
        if (this.input.getProjectsToShare().isEmpty()) {
            twc = null;
        } else {
            twc = new SharingWizardInput.TargetWorkspaceConfiguration();
            twc.setWorkspaceName(this.teamPlacePage.getWorkspaceName());
            twc.setCreatingNewWorkspace(this.teamPlacePage.creatingNewWorkspace());
            twc.setCollaborate(!this.teamAreaPickerPage.dontCollaborate());
            twc.setTeamAreaSelection(twc.isCreatingNewWorkspace() ? (twc.isCollaborate() ? this.teamAreaPickerPage.getTeamAreaSelection() : null) : this.teamPlacePage.getTeamSelection());
            twc.setRepository(this.teamPlacePage.getRepository());
        }
        this.performShare(twc);
        return true;
    }

    private void performShare(final SharingWizardInput.TargetWorkspaceConfiguration twc) {
        HashSet<ITeamRepository> repos = new HashSet<ITeamRepository>();
        if (twc != null) {
            repos.add(twc.getRepository());
        }
        final List<IProject> projectsToShare = this.input.getProjectsToShare();
        final Collection<IProject> projectsToConnect = this.input.getProjectsToConnect();
        JobRunner.enqueue((String)Messages.SharingWizard_shareProjectsJobName, (boolean)true, (Operation)new RepositoryOperation(repos){

            public void repositoryRun(IProgressMonitor progress, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)101);
                if (!projectsToShare.isEmpty()) {
                    for (IProject project : projectsToShare) {
                        PathLocation workspacePath;
                        ISandbox sandbox;
                        if (!this.isInWorkspace(project) || (sandbox = this.findSandbox((ILocation)(workspacePath = new PathLocation(project.getParent().getLocation())))) == null) continue;
                        ILocation sandboxPath = sandbox.getRoot();
                        if (sandboxPath.equals((Object)workspacePath) || !sandboxPath.isPrefixOf((ILocation)workspacePath)) break;
                        throw new FileSystemStatusException(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.SharingWizard_0, (Object)workspacePath.toOSString(), (Object)sandboxPath.toOSString())));
                    }
                    SharingWizard.this.configureIgnoresPage.performFinish((IProgressMonitor)monitor.newChild(1));
                }
                if (projectsToConnect.size() > 0) {
                    if (twc == null) {
                        monitor.setWorkRemaining(5);
                    }
                    SharingWizard.this.input.autoconnectProjects(projectsToConnect, (IProgressMonitor)monitor.newChild(5));
                }
                if (twc == null) {
                    return;
                }
                monitor.setTaskName(Messages.SharingWizard_GETTING_REMOTE_WORKSPACE_PROGRESS);
                WorkspaceComponentWrapper componentWrapper = null;
                boolean updateComponents = false;
                IFolderHandle parentFolder = null;
                String[] path = null;
                if (twc.isCreatingNewWorkspace()) {
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)twc.getRepository());
                    IWorkspaceConnection workspace = wm.createWorkspace((IContributorHandle)twc.getRepository().loggedInContributor(), twc.getWorkspaceName(), "", (IProgressMonitor)monitor.newChild(10));
                    if (twc.isCollaborate()) {
                        WorkspaceComponentWrapper componentInStream = twc.getTeamAreaSelection().getComponent();
                        if (componentInStream == null) {
                            componentInStream = twc.getTeamAreaSelection().getComponent(twc.getRepository(), (IProgressMonitor)monitor.newChild(5));
                        }
                        IWorkspaceConnection streamConnection = ConnectionUtil.getConnection((ITeamRepository)twc.getRepository(), (IWorkspace)twc.getTeamAreaSelection().getPlace().getWorkspace(), (IProgressMonitor)monitor.newChild(5));
                        List components = streamConnection.getComponents();
                        ArrayList addComponents = new ArrayList();
                        for (IComponentHandle next : components) {
                            addComponents.add(workspace.componentOpFactory().addComponent(next, (IConnection)streamConnection, false));
                        }
                        workspace.applyComponentOperations((List)addComponents, (IProgressMonitor)monitor.newChild(5));
                        FlowTableUtil.addCollaboration((IWorkspaceConnection)workspace, (IWorkspaceConnection)streamConnection, (IProgressMonitor)monitor.newChild(5));
                        componentWrapper = WorkspaceComponentWrapper.newWrapper(workspace, componentInStream.getComponent());
                        parentFolder = twc.getTeamAreaSelection().getParentFolder();
                        path = twc.getTeamAreaSelection().getPath();
                    } else {
                        IComponent newComponent = wm.createComponent(twc.getWorkspaceName(), (IAuditableHandle)twc.getRepository().loggedInContributor(), (IProgressMonitor)monitor.newChild(5));
                        workspace.addComponent((IComponentHandle)newComponent, false, (IProgressMonitor)monitor.newChild(5));
                        componentWrapper = WorkspaceComponentWrapper.newWrapper(workspace, newComponent);
                        parentFolder = newComponent.getRootFolder();
                        path = new String[]{};
                    }
                } else {
                    componentWrapper = twc.getTeamAreaSelection().getComponent();
                    if (componentWrapper == null) {
                        componentWrapper = twc.getTeamAreaSelection().getComponent(twc.getRepository(), (IProgressMonitor)monitor.newChild(15));
                        updateComponents = true;
                    }
                    parentFolder = twc.getTeamAreaSelection().getParentFolder();
                    path = twc.getTeamAreaSelection().getPath();
                }
                monitor.setWorkRemaining(100);
                IWorkspaceConnection connection = componentWrapper.getWorkspaceConnection();
                final IComponent component = componentWrapper.getComponent();
                FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)connection.getResolvedWorkspace());
                if (updateComponents) {
                    FileSystemResourcesPlugin.getComponentSyncModel().getUpdateManager().requestModelUpdate((Object)"COMPONENT_SYNC_MANAGER_UPDATE_OPERATION");
                }
                LocalWorkspaceChangesView.requestShowPendingView();
                ArrayList<PathLocation> pathsToShare = new ArrayList<PathLocation>(projectsToShare.size());
                Set<IProject> nestedProjects = this.findNestedProjects(projectsToShare);
                for (IProject project : projectsToShare) {
                    if (nestedProjects.contains(project)) continue;
                    IPath projectPath = project.getLocation();
                    if (projectPath != null) {
                        pathsToShare.add(new PathLocation(projectPath));
                        continue;
                    }
                    problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.SharingWizard_UnableToShareProjectDueToLocationMissing, (Object)project.getName())));
                }
                WarnShareUser handler = new WarnShareUser(null, Messages.SharingWizard_shareProjectsHandlerTitle){

                    public int multipleSandboxesForConfigurations(final Collection<? extends IMultipleSandboxShare> shares) {
                        final int[] result = new int[]{1};
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                IStatus status = this.createStatus(shares);
                                StatusDialog dialog = new StatusDialog(null, Messages.SharingWizard_MultiSandboxShareTitle, NLS.bind((String)Messages.SharingWizard_MultiSandboxShareMessage, (Object)component.getName()), null, status, 7);
                                if (dialog.open() == 0) {
                                    result[0] = 0;
                                }
                            }
                        });
                        return result[0];
                    }

                    IStatus createStatus(Collection<? extends IMultipleSandboxShare> shares) {
                        ArrayList<IStatus> info = new ArrayList<IStatus>();
                        for (IMultipleSandboxShare iMultipleSandboxShare : shares) {
                            this.accumulateStatus(iMultipleSandboxShare, info);
                        }
                        if (info.size() == 1) {
                            return (IStatus)info.get(0);
                        }
                        return StatusUtil.newStatus((Object)((Object)this), (String)Messages.SharingWizard_MultipleSandboxSharesMultiStatus, info);
                    }

                    private void accumulateStatus(IMultipleSandboxShare share, List<IStatus> info) {
                        Collection sandboxes = share.getSandboxes();
                        Collection shareables = share.getShareables();
                        String componentName = component.getName();
                        for (IShareable shareable : shareables) {
                            Collection<ISandbox> otherSandboxes = this.getOtherSandboxes(shareable, sandboxes);
                            for (ISandbox other : otherSandboxes) {
                                info.add(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.SharingWizard_MultipleSandboxSharesStatus, (Object[])new Object[]{shareable.getFullPath().toOSString(), componentName, other.getRoot().toOSString()})));
                            }
                        }
                    }

                    private Collection<ISandbox> getOtherSandboxes(IShareable shareable, Collection<ISandbox> sandboxes) {
                        ArrayList<ISandbox> result = new ArrayList<ISandbox>(sandboxes.size());
                        for (ISandbox sandbox : sandboxes) {
                            if (sandbox.equals(shareable.getSandbox())) continue;
                            result.add(sandbox);
                        }
                        return result;
                    }

                    public void linkWarnings(boolean anyBrokenLinks, boolean anyNonInteroperableLinks, final IShareable[] shareables, final String[] targets, final Boolean[] directoryLinks, final Boolean[] broken, final Boolean[] nonInteroperable) {
                        if (PlatformUI.isWorkbenchRunning()) {
                            boolean promptForNonInteroperable;
                            DialogUtil.pauseIfNeededBeforeShowingDialog();
                            final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                            boolean promptForBroken = store.getInt("checkinLinkWarnings") == 0 || store.getInt("checkinLinkWarnings") == 1;
                            boolean bl = promptForNonInteroperable = store.getInt("checkinLinkWarnings") == 0;
                            if (anyBrokenLinks && promptForBroken || anyNonInteroperableLinks && promptForNonInteroperable) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        SymbolicLinkDetailsDialog dialog = new SymbolicLinkDetailsDialog(null, promptForNonInteroperable, shareables, targets, directoryLinks, broken, nonInteroperable);
                                        dialog.open();
                                        if (!dialog.shouldPromptAgain()) {
                                            store.setValue("checkinLinkWarnings", 2);
                                        }
                                    }
                                });
                            }
                        }
                    }
                };
                IShareOperation shareOp = IOperationFactory.instance.getShareOperation((ShareDilemmaHandler)handler);
                shareOp.share(connection, null, (IComponentHandle)component, parentFolder, path, pathsToShare, true, (IProgressMonitor)monitor.newChild(1));
                shareOp.run((IProgressMonitor)monitor.newChild(99));
                if (nestedProjects.size() > 0) {
                    SharingWizard.this.input.buildProjectDescriptions(nestedProjects.toArray(new IProject[nestedProjects.size()]), (IProgressMonitor)monitor.newChild(1));
                    SharingWizard.this.input.autoconnectProjects(nestedProjects, (IProgressMonitor)monitor.newChild(1));
                }
            }

            private Set<IProject> findNestedProjects(List<IProject> projectsToShare2) {
                HashSet<IProject> nestedProjects = new HashSet<IProject>();
                int i = 0;
                while (i < projectsToShare2.size()) {
                    IProject p1 = projectsToShare2.get(i);
                    if (!nestedProjects.contains(p1)) {
                        IPath path1 = p1.getLocation();
                        int j = i + 1;
                        while (j < projectsToShare2.size()) {
                            IProject p2 = projectsToShare2.get(j);
                            IPath path2 = p2.getLocation();
                            if (path2.isPrefixOf(path1)) {
                                nestedProjects.add(p1);
                                break;
                            }
                            if (path1.isPrefixOf(path2)) {
                                nestedProjects.add(p2);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return nestedProjects;
            }

            private ISandbox findSandbox(ILocation location) {
                if (location.isEmpty()) {
                    return null;
                }
                ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(location, false);
                if (sandbox.isExistingSandbox()) {
                    return sandbox;
                }
                return this.findSandbox(location.getParent());
            }

            private boolean isInWorkspace(IProject project) {
                IPath pl;
                IPath location = project.getLocation();
                if (location != null && (pl = project.getParent().getLocation()) != null) {
                    return pl.isPrefixOf(location);
                }
                return false;
            }
        });
    }

    public void init(IWorkbench workbench, IProject project) {
        this.input = new SharingWizardInput(project);
    }

    public List<IWizardPage> getPageOrder() {
        ArrayList result = NewCollection.arrayList();
        if (this.input.isAutoconnect()) {
            result.add(this.autoConnectPage);
            if (this.input.hasMultipleCandidates()) {
                result.add(this.projectSelectionPage);
            }
        } else {
            result.add(this.teamPlacePage);
            if (this.teamPlacePage.creatingNewWorkspace()) {
                this.teamAreaPickerPage.setRepo(this.teamPlacePage);
                result.add(this.teamAreaPickerPage);
            }
            if (this.input.hasMultipleCandidates()) {
                result.add(this.projectSelectionPage);
            }
            result.add(this.configureIgnoresPage);
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IConfigurationWizardExtension.class) {
            return new IConfigurationWizardExtension(){

                public void init(IWorkbench workbench, IProject[] projects) {
                    SharingWizard.this.input = new SharingWizardInput(projects);
                }
            };
        }
        return null;
    }
}

