/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.ITeamRepositoryFactory;
import com.ibm.team.process.rcp.ui.RepositoryCreationPage;
import com.ibm.team.process.rcp.ui.RepositorySelectionPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.wizards.PageChain;
import com.ibm.team.repository.rcp.ui.wizards.PageChainSite;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class PickRepositoryChain
extends PageChain
implements ITeamRepositoryFactory {
    private RepositoryCreationPage repositoryCreationPage;
    private RepositorySelectionPage repositorySelectionPage;
    private boolean createOnly = false;

    public void init(PageChainSite site) {
        super.init(site);
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        this.repositoryCreationPage = new RepositoryCreationPage("Jazz Repository", Messages.PickRepositoryChain_createRepositoryPageDescription);
        this.repositorySelectionPage = new RepositorySelectionPage("Jazz Repository", Messages.PickRepositoryChain_selectJazzRepositoryConnection);
        site.addPage((IWizardPage)this.repositoryCreationPage);
        site.addPage((IWizardPage)this.repositorySelectionPage);
        this.createOnly = repos.length == 0;
    }

    public List<IWizardPage> getPageOrder() {
        if (this.createOnly) {
            return Collections.singletonList(this.repositoryCreationPage);
        }
        ITeamRepository repo = null;
        if (this.repositorySelectionPage.getControl() != null) {
            repo = this.repositorySelectionPage.getTeamRepository();
        }
        if (repo == null) {
            ArrayList result = NewCollection.arrayList();
            result.add(this.repositorySelectionPage);
            result.add(this.repositoryCreationPage);
            return result;
        }
        return Collections.singletonList(this.repositorySelectionPage);
    }

    @Override
    public ITeamRepository createRepository(IProgressMonitor monitor) {
        if (this.repositorySelectionPage.getControl() == null) {
            return null;
        }
        ITeamRepository result = this.repositorySelectionPage.getTeamRepository();
        if (result != null) {
            return result;
        }
        if (!this.repositoryCreationPage.isPageComplete() || !this.repositoryCreationPage.canFlipToNextPage()) {
            return null;
        }
        try {
            this.repositoryCreationPage.create();
            ITeamRepository repo = this.repositoryCreationPage.getTeamRepository();
            return repo;
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            StatusUtil.log((Object)this, (Throwable)t);
            return null;
        }
    }
}

