/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.sharing;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.properties.SharingDescriptorPane;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.SharingWizardInput;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class AutoconnectProjectPage
extends WizardPage {
    private final SharingWizardInput input;

    protected AutoconnectProjectPage(String pageName, SharingWizardInput input, ImageDescriptor titleImage) {
        super(pageName, Messages.AutoconnectProjectPage_PageTitle, titleImage);
        this.input = input;
        this.setDescription(Messages.AutoconnectProjectPage_PageDescription);
    }

    public void createControl(Composite parent) {
        int projectsSharedInSandboxesCount;
        Composite composite = new Composite(parent, 0);
        Label l = new Label(composite, 64);
        boolean showDetails = true;
        if (this.input.isSharedInSandbox(this.input.getSeedProject())) {
            l.setText(NLS.bind((String)Messages.AutoconnectProjectPage_LongDescription, (Object)this.input.getSeedProject().getName()));
        } else if (this.input.containsShare(this.input.getSeedProject())) {
            showDetails = false;
            l.setText(NLS.bind((String)Messages.AutoconnectProjectPage_LongDescriptionForParentOfShares, (Object)this.input.getSeedProject().getName()));
        } else {
            l.setText(NLS.bind((String)Messages.AutoconnectProjectPage_LongDescriptionForChildOfShare, (Object)this.input.getSeedProject().getName()));
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(350, -1).span(2, 1).applyTo((Control)l);
        if (showDetails) {
            new SharingDescriptorPane(composite, this.input.getShareable(this.input.getSeedProject()), new JobRunner(false));
        }
        if ((projectsSharedInSandboxesCount = this.input.getUnsharedProjects().size()) > 1) {
            Label multiple = new Label(composite, 64);
            multiple.setText(NLS.bind((String)Messages.AutoconnectProjectPage_OtherSharedProjectsPresent, (Object)projectsSharedInSandboxesCount));
            GridDataFactory.fillDefaults().align(4, 0x1000000).hint(350, -1).span(2, 1).applyTo((Control)multiple);
        }
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_share_autoconnect");
    }
}

