/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.newworkspace;

import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.wizards.join.NewWorkspaceSeedData;
import com.ibm.team.internal.filesystem.ui.wizards.newworkspace.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class SelectRepositoryPage
extends BaseWizardPage {
    private static final int MAX_REPO_NAME_LENGTH = 20;
    private ITeamRepository initialRepo;
    private Button selectCurrentRepo;
    private Button selectOtherRepo;
    private RepositoryCombo combo;
    private Composite repoPickerPageBody;

    public SelectRepositoryPage(ITeamRepository initialRepo) {
        super("selectRepositoryPage", Messages.SelectRepositoryPage_0, null);
        this.initialRepo = initialRepo;
        this.setDescription(Messages.SelectRepositoryPage_4);
    }

    protected void createBody(Composite parent) {
        this.repoPickerPageBody = new Composite(parent, 0);
        this.selectCurrentRepo = new Button(this.repoPickerPageBody, 16);
        this.selectOtherRepo = new Button(this.repoPickerPageBody, 16);
        Label otherRepoDescription = new Label(this.repoPickerPageBody, 64);
        this.combo = new RepositoryCombo(this.repoPickerPageBody, WidgetFactoryContext.forDialogBox());
        this.selectCurrentRepo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectRepositoryPage.this.combo.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.selectOtherRepo.setText(Messages.SelectRepositoryPage_2);
        this.selectOtherRepo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectRepositoryPage.this.combo.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        otherRepoDescription.setText(Messages.SelectRepositoryPage_1);
        this.selectCurrentRepo.setSelection(true);
        this.combo.setEnabled(false);
        this.combo.setSelectedElement(this.initialRepo);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.repoPickerPageBody);
        GridDataFactory.fillDefaults().grab(false, false).hint(250, -1).applyTo((Control)this.selectCurrentRepo);
        GridDataFactory.fillDefaults().grab(false, false).hint(250, -1).applyTo((Control)this.selectOtherRepo);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(250, -1).applyTo((Control)otherRepoDescription);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(250, -1).applyTo(this.combo.getControl());
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo(this.repoPickerPageBody);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpId());
    }

    public ITeamRepository getRepository() {
        if (this.selectCurrentRepo.getSelection()) {
            return this.initialRepo;
        }
        return this.combo.getRepository();
    }

    public void setInputs(NewWorkspaceSeedData seedData) {
        String repoName;
        this.initialRepo = seedData.getTeamRepository();
        if (this.combo.getRepository() == null) {
            this.combo.setSelectedElement(this.initialRepo);
        }
        if ((repoName = RepositoryUtils.getLabel(this.initialRepo)).length() > 20) {
            repoName = String.valueOf(repoName.substring(0, 20)) + "...";
        }
        String message = NLS.bind((String)Messages.SelectRepositoryPage_3, (Object)(String.valueOf(this.initialRepo.getUserId()) + "@" + repoName));
        this.selectCurrentRepo.setText(message);
        this.selectCurrentRepo.setToolTipText(NLS.bind((String)Messages.SelectRepositoryPage_3, (Object)repoName));
        this.repoPickerPageBody.layout();
    }

    protected String getHelpId() {
        return "com.ibm.team.filesystem.ide.ui.wizard_newworkspace_selectrepository";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpId());
    }
}

