/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.newworkspace;

import com.ibm.team.filesystem.ui.views.StreamsInTeamAreaTreeProvider;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.ToolkitUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewWizardTeamAreaPickerPage
extends BaseWizardPage {
    private RepositoryCombo repoCombo;
    private SimpleTreeViewer stv;
    private JobRunner operationRunner = new JobRunner(false);
    private AbstractPlaceWrapper area;
    public static final Object RADIO_CREATE = new String("Create");
    public static final Object RADIO_REUSE = new String("Reuse");
    private WritableValue radioValue = new WritableValue(RADIO_CREATE);
    private CombinedStatus validationStatus = new CombinedStatus();
    private Control justBackUpRadio;
    private Control streamRadio;
    private boolean forceRepo = false;
    private ITeamRepository repo;
    private ISetListener tableElementListener = new ISetListener<Object>(){

        public void changed(SetDiff<Object> diff) {
            NewWizardTeamAreaPickerPage.this.tableChanged();
        }
    };

    public NewWizardTeamAreaPickerPage(ITeamRepository initialRepo) {
        this(initialRepo, false);
    }

    public NewWizardTeamAreaPickerPage(ITeamRepository initialRepo, boolean forceRepo) {
        super("Select Stream", Messages.NewWizardTeamAreaPickerPage_pageTitle, null);
        this.setDescription(Messages.NewWizardTeamAreaPickerPage_pageDescription);
        this.setPageComplete(false);
        this.repo = initialRepo;
        this.forceRepo = forceRepo;
    }

    protected IEclipsePreferences getConfigPrefs() {
        return new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
    }

    protected void createBody(Composite composite) {
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        WidgetToolkit toolkit = context.getToolkit();
        ITeamRepository input = null;
        MnemonicGenerator mnemonics = context.getMnemonics();
        if (!this.forceRepo) {
            toolkit.createLabel(composite, mnemonics.generate(Messages.NewWizardTeamAreaPickerPage_repositoryLabel));
            this.repoCombo = new RepositoryCombo(composite, this.getConfigPrefs().node("repo"), context);
            if (this.repo != null) {
                this.repoCombo.setSelectedElement(this.repo);
            }
            this.validationStatus.addStatus(this.repoCombo.getValidationStatus());
        }
        input = this.forceRepo && this.repo != null ? this.repo : (this.repo = this.repoCombo.getRepository());
        Composite buttonsComposite = new Composite(composite, 16);
        GridLayoutFactory.fillDefaults().margins(0, 0).generateLayout(buttonsComposite);
        this.justBackUpRadio = ToolkitUtil.createRadio((Composite)buttonsComposite, (WidgetFactoryContext)context, (String)Messages.NewWizardTeamAreaPickerPage_dontShareCombo, (Object)RADIO_CREATE, (WritableValue)this.radioValue);
        this.streamRadio = ToolkitUtil.createRadio((Composite)buttonsComposite, (WidgetFactoryContext)context, (String)Messages.NewWizardTeamAreaPickerPage_flowToStreamCombo, (Object)RADIO_REUSE, (WritableValue)this.radioValue);
        this.justBackUpRadio.setEnabled(true);
        this.radioValue.addListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                if (NewWizardTeamAreaPickerPage.this.radioValue.getValue() == RADIO_CREATE) {
                    NewWizardTeamAreaPickerPage.this.stv.getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
                }
                NewWizardTeamAreaPickerPage.this.updateArea();
            }
        });
        StreamsInTeamAreaTreeProvider treeProvider = null;
        treeProvider = new StreamsInTeamAreaTreeProvider((IOperationRunner)this.operationRunner);
        this.stv = new SimpleTreeViewer(toolkit.createTree(composite, 2052), (ITreeProvider)treeProvider);
        this.stv.setSorter(new Comparator(){

            public int compare(Object e1, Object e2) {
                if (e1 instanceof AbstractPlaceWrapper && e2 instanceof AbstractPlaceWrapper) {
                    AbstractPlaceWrapper apw1 = (AbstractPlaceWrapper)((Object)e1);
                    AbstractPlaceWrapper apw2 = (AbstractPlaceWrapper)((Object)e2);
                    return apw1.getWorkspace().getName().compareToIgnoreCase(apw2.getWorkspace().getName());
                }
                if (e1 instanceof IProcessArea && e2 instanceof IProcessArea) {
                    IProcessArea ta1 = (IProcessArea)e1;
                    IProcessArea ta2 = (IProcessArea)e2;
                    return ta1.getName().compareToIgnoreCase(ta2.getName());
                }
                if (e1 instanceof AbstractPlaceWrapper) {
                    return 1;
                }
                if (e2 instanceof AbstractPlaceWrapper) {
                    return -1;
                }
                return 0;
            }
        });
        this.stv.setDoubleClickHandler(new ITreePathRunnable(){

            public void run(TreePath selectedObject, Shell targetShell) {
                if (NewWizardTeamAreaPickerPage.this.getStream() != null) {
                    AdvanceableWizard.advance(NewWizardTeamAreaPickerPage.this.getWizard());
                } else {
                    NewWizardTeamAreaPickerPage.this.stv.toggleExpandedState(selectedObject);
                }
            }
        });
        this.stv.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    NewWizardTeamAreaPickerPage.this.radioValue.setValue(RADIO_REUSE);
                }
                NewWizardTeamAreaPickerPage.this.updateArea();
            }
        });
        this.stv.setInput((Object)input);
        this.stv.getKnownElements().addListener(this.tableElementListener);
        this.stv.getTree().getAccessible().addAccessibleListener(new AccessibleListener(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.NewWizardTeamAreaPickerPage_flowToStreamCombo;
                }
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
            }

            public void getHelp(AccessibleEvent e) {
            }

            public void getDescription(AccessibleEvent e) {
                e.result = Messages.NewWizardTeamAreaPickerPage_accessibleTreeViewerDescription;
            }
        });
        if (!this.forceRepo) {
            this.repoCombo.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    NewWizardTeamAreaPickerPage.this.repo = NewWizardTeamAreaPickerPage.this.repoCombo.getRepository();
                    NewWizardTeamAreaPickerPage.this.stv.setInput((Object)NewWizardTeamAreaPickerPage.this.repo);
                    NewWizardTeamAreaPickerPage.this.stv.setTreeProvider((ITreeProvider)new StreamsInTeamAreaTreeProvider((IOperationRunner)NewWizardTeamAreaPickerPage.this.operationRunner));
                    NewWizardTeamAreaPickerPage.this.setPageComplete(NewWizardTeamAreaPickerPage.this.isPageComplete());
                    NewWizardTeamAreaPickerPage.this.getContainer().updateButtons();
                }
            });
            this.repo = this.repoCombo.getRepository();
        }
        Dialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        this.tableChanged();
        this.updateArea();
        DatabindingUtil.bindMessage((DialogPage)this, (IObservableValue)this.validationStatus);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getHelpId());
    }

    private void tableChanged() {
        if (this.streamRadio.isDisposed()) {
            return;
        }
        Collection elements = this.stv.getKnownElements().toCollection();
        boolean enabled = false;
        for (Object next : elements) {
            if (!(next instanceof IProcessAreaHandle)) continue;
            enabled = true;
            break;
        }
        this.stv.getControl().setEnabled(enabled);
        this.streamRadio.setEnabled(enabled);
        if (!enabled) {
            this.radioValue.setValue(RADIO_CREATE);
        }
    }

    protected void updateArea() {
        this.area = null;
        Object selection = this.stv.getSelection().getFirstElement();
        if (selection instanceof AbstractPlaceWrapper) {
            this.area = (AbstractPlaceWrapper)((Object)selection);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        return (this.dontCollaborate() || this.area != null) && this.getRepository() != null && this.getRepository().loggedIn();
    }

    public void dispose() {
        this.stv.getKnownElements().removeListener(this.tableElementListener);
        super.dispose();
    }

    public boolean dontCollaborate() {
        return this.radioValue.getValue() == RADIO_CREATE;
    }

    public AbstractPlaceWrapper getStream() {
        if (this.dontCollaborate()) {
            return null;
        }
        return this.area;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    protected String getHelpId() {
        return "com.ibm.team.filesystem.ide.ui.wizard_newworkspace_selectteamarea";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpId());
    }
}

