/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.join;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.INewWorkspaceConfigurationData;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class NewWorkspaceSeedData {
    private ITeamRepository repository;
    private ITeamRepository workspaceRepository;
    private IWorkspace stream;
    private IReadScope readScope;
    protected List<WorkspaceComponentWrapper> availableComponents = null;
    private Set<String> existingWorkspaceNames = null;
    private INewWorkspaceConfigurationData configurationData;

    public NewWorkspaceSeedData(ITeamRepository teamRepository, IWorkspace stream, IReadScope readScope) {
        this.repository = teamRepository;
        this.stream = stream;
        this.readScope = readScope;
        this.workspaceRepository = teamRepository;
    }

    public ITeamRepository getTeamRepository() {
        return this.repository;
    }

    public IWorkspace getStream() {
        return this.stream;
    }

    public String getSuggestedWorkspaceName() {
        if (this.getStream() == null) {
            return Messages.JoinWorkspaceNamePage_defaultWorkspaceName;
        }
        if (this.configurationData != null) {
            return this.configurationData.getProposedName();
        }
        return NewWorkspaceSeedData.getDefaultWorkspaceName(this.getStream().getName());
    }

    public IReadScope getReadScope() {
        return this.readScope;
    }

    public Set<String> getExistingWorkspaceNames() {
        return this.existingWorkspaceNames;
    }

    public static String getDefaultWorkspaceName(String name) {
        return NLS.bind((String)Messages.JoinOperation_0, (Object)name);
    }

    public void initialize(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.stream != null && this.availableComponents == null) {
            IWorkspaceConnection streamConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository).getWorkspaceConnection((IWorkspaceHandle)this.stream, (IProgressMonitor)progress.newChild(30));
            this.availableComponents = WorkspaceUtil.getComponentWrappers(streamConnection, (IProgressMonitor)progress.newChild(40));
            this.configurationData = streamConnection.getNewWorkspaceConfigurationData((IProgressMonitor)progress.newChild(30));
            if (this.configurationData.getReadScope() != null) {
                this.readScope = this.configurationData.getReadScope();
            }
        } else {
            this.availableComponents = null;
        }
        if (this.workspaceRepository != null) {
            this.existingWorkspaceNames = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workspaceRepository).findAllWorkspaceNames((IAuditableHandle)this.workspaceRepository.loggedInContributor(), (IProgressMonitor)progress.newChild(30));
        }
    }

    public List<WorkspaceComponentWrapper> getAvailableComponents() {
        return this.availableComponents;
    }

    public boolean sameAs(IWorkspace newStream, ITeamRepository teamRepository) {
        if (this.stream == null && newStream == null) {
            return teamRepository == this.repository;
        }
        if (this.stream != null && newStream == null) {
            return false;
        }
        if (newStream != null && this.stream == null) {
            return false;
        }
        return this.stream.sameItemId((IItemHandle)newStream);
    }

    public boolean checkExistingWorkspaceName(String workspaceName, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.workspaceRepository);
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance();
        criteria.setExactName(workspaceName);
        criteria.getFilterByOwnerOptional().add(this.workspaceRepository.loggedInContributor());
        List workspaces = workspaceManager.findWorkspaces(criteria, 1, monitor);
        return !workspaces.isEmpty();
    }
}

