/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.join;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.internal.filesystem.ui.wizards.join.JoinWizard;
import com.ibm.team.internal.filesystem.ui.wizards.join.NewWorkspaceSeedData;
import com.ibm.team.internal.filesystem.ui.wizards.newworkspace.NewWizardTeamAreaPickerPage;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.repository.rcp.ui.wizards.ProxyPage;
import com.ibm.team.scm.common.IWorkspace;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class JoinWorkspaceNamePage
extends BaseWizardPage {
    private Text workspaceNameText;
    private Text descriptionText;
    private String workspaceName = "";
    private String workspaceDescription = "";
    private Set<String> existingWorkspaceNames = new HashSet<String>();
    private boolean userModified = false;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            JoinWorkspaceNamePage.this.userModified = true;
            JoinWorkspaceNamePage.this.onChange();
        }
    };
    private String defaultName = "";
    private volatile boolean dirty = true;
    private Button createDefaultComponentButton;
    private boolean shouldCreateDefaultComponent = false;
    private Text defaultComponentText;
    private String componentName;
    private Composite defaultComponentSection;
    private Composite defaultComponentTextSection;
    private NewWorkspaceSeedData seedData;

    public JoinWorkspaceNamePage() {
        super("newWorkspaceName", Messages.JoinWorkspaceNamePage_pageTitle, null);
        this.setDescriptionBasedOnContext();
    }

    private void setDescriptionBasedOnContext() {
        if (this.getWizard() instanceof JoinWizard) {
            this.setDescription(Messages.JoinWorkspaceNamePage_pageDescriptionForJoinWizard);
        } else {
            this.setDescription(Messages.JoinWorkspaceNamePage_pageDescriptionForNewWorkspaceWizard);
        }
    }

    protected IEclipsePreferences getConfigPrefs() {
        return new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
    }

    protected void createBody(Composite composite) {
        Composite body = new Composite(composite, 0);
        Label label = new Label(body, 0);
        label.setText(Messages.JoinWorkspaceNamePage_workspaceNameLabel);
        this.workspaceNameText = new Text(body, 2048);
        this.workspaceNameText.addModifyListener(this.listener);
        label = new Label(body, 0);
        label.setText(Messages.JoinWorkspaceNamePage_descriptionFieldLabel);
        GridDataFactory.fillDefaults().align(1, 128).applyTo((Control)label);
        this.descriptionText = new Text(body, 2626);
        this.descriptionText.setTextLimit(32768);
        this.descriptionText.addModifyListener(this.listener);
        AdvanceableWizard.advanceOnCtrlEnter((Control)this.descriptionText, this.getWizard());
        this.defaultComponentSection = new Composite(composite, 0);
        this.createDefaultComponentButton = new Button(this.defaultComponentSection, 32);
        this.createDefaultComponentButton.setText(Messages.JoinWorkspaceNamePage_createDefaultComponentButtonText);
        this.createDefaultComponentButton.setSelection(this.shouldCreateDefaultComponent);
        this.createDefaultComponentButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JoinWorkspaceNamePage.this.shouldCreateDefaultComponent = JoinWorkspaceNamePage.this.createDefaultComponentButton.getSelection();
                JoinWorkspaceNamePage.this.defaultComponentText.setEnabled(JoinWorkspaceNamePage.this.shouldCreateDefaultComponent);
                JoinWorkspaceNamePage.this.onChange();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.defaultComponentTextSection = new Composite(composite, 0);
        label = new Label(this.defaultComponentTextSection, 0);
        label.setText(Messages.JoinWorkspaceNamePage_defaultComponentNameLabel);
        this.defaultComponentText = new Text(this.defaultComponentTextSection, 2048);
        this.defaultComponentText.addModifyListener(this.listener);
        this.defaultComponentText.setEnabled(this.shouldCreateDefaultComponent);
        AdvanceableWizard.advanceOnCtrlEnter((Control)this.defaultComponentText, this.getWizard());
        GridLayoutFactory.fillDefaults().generateLayout(this.defaultComponentSection);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).numColumns(1).generateLayout(composite);
        GridLayoutFactory.fillDefaults().generateLayout(body);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).numColumns(2).generateLayout(this.defaultComponentTextSection);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getHelpId());
    }

    public void setInputs(NewWorkspaceSeedData seedData) {
        if (this.seedData == seedData) {
            return;
        }
        this.seedData = seedData;
        this.setSuggestedWorkspaceName(seedData.getSuggestedWorkspaceName());
        this.dirty = true;
    }

    public List<WorkspaceComponentWrapper> getAvailableComponents() {
        return this.seedData.getAvailableComponents();
    }

    private void setSuggestedWorkspaceName(String suggestedWorkspaceName) {
        if (!this.defaultName.equals(suggestedWorkspaceName)) {
            this.defaultName = suggestedWorkspaceName;
            this.setWorkspaceNameToDefault();
            this.onChange();
        }
    }

    private void setWorkspaceNameToDefault() {
        String newText = this.defaultName;
        if (this.existingWorkspaceNames.contains(newText)) {
            int workspaceNumber = 2;
            while (this.existingWorkspaceNames.contains(newText = String.valueOf(this.defaultName) + workspaceNumber++)) {
            }
        }
        if (!this.workspaceNameText.getText().equals(newText)) {
            this.workspaceNameText.setText(newText);
            this.userModified = false;
        }
    }

    private void setExistingWorkspaceNames(Set<String> existingWorkspaceNames) {
        this.existingWorkspaceNames.addAll(existingWorkspaceNames);
        if (!this.userModified) {
            this.setWorkspaceNameToDefault();
        }
        this.onChange();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            NewWizardTeamAreaPickerPage previousPage = null;
            IWizardPage page = this.getPreviousPage();
            if (page instanceof ProxyPage) {
                page = ((ProxyPage)page).getRealPage();
            }
            if (page instanceof NewWizardTeamAreaPickerPage) {
                previousPage = (NewWizardTeamAreaPickerPage)page;
            }
            if (previousPage != null && previousPage.dontCollaborate()) {
                this.defaultComponentSection.setVisible(true);
                this.defaultComponentTextSection.setVisible(true);
            } else {
                this.defaultComponentSection.setVisible(false);
                this.defaultComponentTextSection.setVisible(false);
                this.createDefaultComponentButton.setSelection(false);
                this.defaultComponentText.setEnabled(false);
            }
            this.workspaceNameText.setFocus();
            if (this.dirty) {
                final Display display = Display.getCurrent();
                this.getUserOperationRunner().enqueue(Messages.JoinWorkspaceNamePage_initPageJobName, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        JoinWorkspaceNamePage.this.seedData.initialize(monitor);
                        SWTUtil.greedyExec((Display)display, (Control)JoinWorkspaceNamePage.this.workspaceNameText, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                JoinWorkspaceNamePage.this.dirty = false;
                                JoinWorkspaceNamePage.this.setExistingWorkspaceNames(JoinWorkspaceNamePage.this.seedData.getExistingWorkspaceNames());
                                JoinWorkspaceNamePage.this.setSuggestedWorkspaceName(JoinWorkspaceNamePage.this.seedData.getSuggestedWorkspaceName());
                            }
                        });
                    }
                });
            }
        }
    }

    private void onChange() {
        String specifiedWorkspaceName = this.workspaceNameText.getText().trim();
        String specifiedComponentName = this.defaultComponentText.getText().trim();
        if (specifiedWorkspaceName.equals("")) {
            this.workspaceName = "";
            this.setErrorMessage(Messages.JoinWorkspaceNamePage_noNameErrorMessage);
            this.setMessage(null);
            this.setPageComplete(false);
        } else if (this.existingWorkspaceNames != null && this.existingWorkspaceNames.contains(specifiedWorkspaceName)) {
            this.workspaceName = specifiedWorkspaceName;
            this.workspaceDescription = this.descriptionText.getText();
            this.componentName = specifiedComponentName;
            this.setErrorMessage(null);
            this.setMessage(NLS.bind((String)Messages.JoinWorkspaceNamePage_duplicateNameError, (Object)this.workspaceName), 2);
            this.setPageComplete(true);
        } else {
            this.workspaceName = specifiedWorkspaceName;
            this.workspaceDescription = this.descriptionText.getText();
            this.componentName = specifiedComponentName;
            this.checkForExistingName(this.workspaceName);
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setPageComplete(true);
        }
        this.shouldCreateDefaultComponent = this.createDefaultComponentButton.getSelection();
        if (this.shouldCreateDefaultComponent && specifiedComponentName.equals("")) {
            this.setErrorMessage(Messages.JoinWorkspaceNamePage_defaultComponentError);
            this.setMessage(null);
            this.setPageComplete(false);
        }
    }

    private void checkForExistingName(final String workspaceName) {
        final Display display = Display.getCurrent();
        this.getUserOperationRunner().enqueue(Messages.JoinWorkspaceNamePage_initPageJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                if (JoinWorkspaceNamePage.this.seedData.checkExistingWorkspaceName(workspaceName, monitor)) {
                    JoinWorkspaceNamePage.this.existingWorkspaceNames.add(workspaceName);
                    SWTUtil.greedyExec((Display)display, (Control)JoinWorkspaceNamePage.this.workspaceNameText, () -> JoinWorkspaceNamePage.this.setMessage(NLS.bind((String)Messages.JoinWorkspaceNamePage_duplicateNameError, (Object)workspaceName), 2));
                }
            }
        });
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getDefaultComponentName() {
        return this.componentName;
    }

    public String getWorkspaceDescription() {
        return this.workspaceDescription;
    }

    public boolean shouldCreateDefaultComponent() {
        return this.shouldCreateDefaultComponent;
    }

    public IWorkspace getStream() {
        return this.seedData.getStream();
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        this.setDescriptionBasedOnContext();
    }

    protected String getHelpId() {
        return "com.ibm.team.filesystem.ide.ui.wizard_newworkspace_entername";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpId());
    }
}

