/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.join;

import com.ibm.team.filesystem.ui.operations.JoinOperation;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.wizards.join.JoinComponentsToAddPage;
import com.ibm.team.internal.filesystem.ui.wizards.join.JoinWorkspaceNamePage;
import com.ibm.team.internal.filesystem.ui.wizards.join.NewWorkspaceSeedData;
import com.ibm.team.internal.filesystem.ui.wizards.newworkspace.NewWorkspaceVisibilityPage;
import com.ibm.team.internal.filesystem.ui.wizards.newworkspace.SelectRepositoryPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.wizards.PageChain;
import com.ibm.team.repository.rcp.ui.wizards.PageChainSite;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class JoinStreamChain
extends PageChain {
    private JoinWorkspaceNamePage workspaceNamePage;
    private JoinComponentsToAddPage componentsToAddPage;
    private SelectRepositoryPage selectRepositoryPage;
    private NewWorkspaceSeedData seedData;
    private ITeamRepository initialRepo;
    private boolean loadWorkspace = true;
    private NewWorkspaceVisibilityPage visibilityPage;
    private boolean forceRepo;
    private IReadScope defaultScope;
    private boolean collaborate;

    public JoinStreamChain(ITeamRepository initialRepo, boolean loadWorkspace, boolean forceRepo, IReadScope defaultScope) {
        this.initialRepo = initialRepo;
        this.loadWorkspace = loadWorkspace;
        this.forceRepo = forceRepo;
        this.defaultScope = defaultScope;
    }

    public void init(PageChainSite site) {
        this.workspaceNamePage = new JoinWorkspaceNamePage();
        site.addPage((IWizardPage)this.workspaceNamePage);
        this.selectRepositoryPage = new SelectRepositoryPage(this.initialRepo);
        site.addPage((IWizardPage)this.selectRepositoryPage);
        this.visibilityPage = new NewWorkspaceVisibilityPage(this.initialRepo, this.defaultScope);
        site.addPage((IWizardPage)this.visibilityPage);
        this.componentsToAddPage = new JoinComponentsToAddPage();
        this.componentsToAddPage.setLoadWorkspace(this.loadWorkspace);
        site.addPage((IWizardPage)this.componentsToAddPage);
        super.init(site);
    }

    public List<IWizardPage> getPageOrder() {
        ITeamRepository selectRepository;
        ArrayList result = NewCollection.arrayList();
        this.workspaceNamePage.setInputs(this.seedData);
        result.add(this.workspaceNamePage);
        if (!this.forceRepo && this.collaborate) {
            this.selectRepositoryPage.setInputs(this.seedData);
            result.add(this.selectRepositoryPage);
        }
        if ((selectRepository = this.getRepository()) != null) {
            this.visibilityPage.setInput(selectRepository, this.seedData.getReadScope());
        }
        result.add(this.visibilityPage);
        List<WorkspaceComponentWrapper> wcw = this.workspaceNamePage.getAvailableComponents();
        if (wcw != null) {
            this.componentsToAddPage.setAvailableComponents(wcw);
            result.add(this.componentsToAddPage);
        }
        return result;
    }

    public void setInputs(NewWorkspaceSeedData seedData, boolean collaborate) {
        this.seedData = seedData;
        this.collaborate = collaborate;
    }

    public JoinOperation getJoinOperation(UIContext context) {
        if (this.workspaceNamePage.getStream() != null) {
            return new JoinOperation(context.getShell(), this.selectRepositoryPage.getRepository(), this.seedData.getTeamRepository(), (ItemId<IWorkspace>)ItemId.forItem((IItem)this.workspaceNamePage.getStream()), this.workspaceNamePage.getWorkspaceName(), this.workspaceNamePage.getWorkspaceDescription(), this.visibilityPage.getReadScope(), WorkspaceUtil.getItems(this.componentsToAddPage.getComponentsToAdd()), this.componentsToAddPage.isAllComponentsChosen(), this.componentsToAddPage.getLoadWorkspace());
        }
        throw new IllegalStateException();
    }

    public String getWorkspaceName() {
        return this.workspaceNamePage.getWorkspaceName();
    }

    public String getWorkspaceDescription() {
        return this.workspaceNamePage.getWorkspaceDescription();
    }

    public String getDefaultComponentName() {
        return this.workspaceNamePage.getDefaultComponentName();
    }

    public boolean shouldCreateDefaultComponent() {
        return this.workspaceNamePage.shouldCreateDefaultComponent();
    }

    public ITeamRepository getRepository() {
        ITeamRepository repository = this.selectRepositoryPage.getRepository();
        if (repository != null) {
            return repository;
        }
        return this.seedData.getTeamRepository();
    }

    public IReadScope getReadScope() {
        return this.visibilityPage.getReadScope();
    }
}

