/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.join;

import com.ibm.team.filesystem.ui.views.TeamPlaceViewSorter;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComparatorSorter;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class JoinComponentsToAddPage
extends BaseWizardPage {
    private CheckboxTableViewer componentsViewer;
    private Button loadButton;
    private List<WorkspaceComponentWrapper> availableComponents = Collections.emptyList();
    private boolean loadWorkspace = true;

    public JoinComponentsToAddPage() {
        super("componentsToAdd", Messages.JoinComponentsToAddPage_pageTitle, null);
        this.setMessage(Messages.JoinComponentsToAddPage_pageDescription);
    }

    protected void createBody(Composite container) {
        Label l = new Label(container, 0);
        l.setText(Messages.JoinComponentsToAddPage_availableComponentsText);
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(2, 1).applyTo((Control)l);
        this.componentsViewer = new CheckboxTableViewer(new Table(container, 2850));
        this.componentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.componentsViewer.setLabelProvider((IBaseLabelProvider)LabelProviders.create((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.componentsViewer.setSorter((ViewerSorter)new ComparatorSorter((Comparator)((Object)new TeamPlaceViewSorter())));
        Composite buttonsComposite = new Composite(container, 0);
        Button selectAllButton = new Button(buttonsComposite, 8);
        selectAllButton.setText(Messages.JoinComponentsToAddPage_selectAllButton);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JoinComponentsToAddPage.this.componentsViewer.setAllChecked(true);
            }
        });
        Button deselectAllButton = new Button(buttonsComposite, 8);
        deselectAllButton.setText(Messages.JoinComponentsToAddPage_deselectAllButton);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JoinComponentsToAddPage.this.componentsViewer.setAllChecked(false);
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(buttonsComposite);
        this.loadButton = new Button(container, 32);
        this.loadButton.setText(Messages.JoinComponentsToAddPage_loadAfterCreationCheckbox);
        this.loadButton.setSelection(this.loadWorkspace);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).numColumns(2).generateLayout(container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, this.getHelpId());
    }

    public void setAvailableComponents(List<WorkspaceComponentWrapper> availableComponents) {
        if (this.availableComponents == null || !this.availableComponents.equals(availableComponents)) {
            this.availableComponents = availableComponents;
            this.componentsViewer.setInput(availableComponents);
            this.componentsViewer.setAllChecked(true);
        }
    }

    public List getComponentsToAdd() {
        Object[] elements = this.componentsViewer.getCheckedElements();
        return Arrays.asList(elements);
    }

    public boolean getLoadWorkspace() {
        this.loadWorkspace = this.loadButton.getSelection();
        return this.loadWorkspace;
    }

    public boolean isAllComponentsChosen() {
        return this.getComponentsToAdd().size() == this.availableComponents.size();
    }

    public void setLoadWorkspace(boolean load) {
        this.loadWorkspace = load;
        if (this.loadButton != null && !this.loadButton.isDisposed()) {
            this.loadButton.setSelection(this.loadWorkspace);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.componentsViewer.getControl().setFocus();
        }
    }

    protected String getHelpId() {
        return "com.ibm.team.filesystem.ide.ui.wizard_newworkspace_selectcomponents";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpId());
    }
}

