/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionPart;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.StatusCollectorAdapter;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class WorkspacePickerPage
extends BaseWizardPage {
    private final ITeamRepository repository;
    private final IWorkspaceHandle toIgnore;
    private WORKSPACES_OR_STREAMS showWorkpaces;
    private ComponentConfigurationPickerWizard.ConfigurationPickerInput componentConfigurationPickerInput;
    private WorkspaceAndStreamSelectionPart selectionPart;
    private AbstractPlaceWrapper pendingSelection;
    private AbstractPlaceWrapper actualSelection = null;
    private AbstractPlaceWrapper defaultSelection;
    private boolean replaceSubcomponents = false;
    private Button replaceSubcomponentsButton;
    private ItemId<IComponent> desiredComponent = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
    private Display display;
    boolean errorInPicker = false;
    private Job statusJob = new Job(Messages.AddComponentFromWorkspacePage1_validatingJobName){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            AbstractPlaceWrapper toValidate;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            WorkspacePickerPage workspacePickerPage = WorkspacePickerPage.this;
            synchronized (workspacePickerPage) {
                toValidate = WorkspacePickerPage.this.pendingSelection;
            }
            boolean isValid = false;
            String message = "";
            if (toValidate != null) {
                try {
                    IWorkspaceConnection connection = toValidate.getWorkspaceConnection((IProgressMonitor)progress.newChild(100));
                    List components = ItemLists.handlesToIds((Collection)connection.getComponents());
                    isValid = components.contains(WorkspacePickerPage.this.desiredComponent);
                    if (!isValid) {
                        message = Messages.AddComponentFromWorkspacePage1_errMissingComponent;
                    }
                }
                catch (TeamRepositoryException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                    message = Messages.AddComponentFromWorkspacePage1_errFetchingWorkspace;
                }
            }
            if (progress.isCanceled()) {
                return Status.OK_STATUS;
            }
            final String finalMessage = message;
            final boolean finalIsValid = isValid;
            WorkspacePickerPage.this.display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    WorkspacePickerPage workspacePickerPage = WorkspacePickerPage.this;
                    synchronized (workspacePickerPage) {
                        if (toValidate != WorkspacePickerPage.this.pendingSelection) {
                            return;
                        }
                    }
                    if (finalIsValid) {
                        WorkspacePickerPage.this.setActualSelection(toValidate);
                        WorkspacePickerPage.this.setSelectionMessage("");
                    } else {
                        WorkspacePickerPage.this.setActualSelection(null);
                        if (toValidate != null) {
                            WorkspacePickerPage.this.setMessage(finalMessage, 3);
                        } else {
                            WorkspacePickerPage.this.setSelectionMessage(null);
                        }
                    }
                }
            });
            return Status.OK_STATUS;
        }
    };

    public WorkspacePickerPage(ITeamRepository repository, IWorkspaceHandle toIgnore, WORKSPACES_OR_STREAMS showWorkpaces) {
        this(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.NON_SPECIFIC, false), repository, toIgnore, showWorkpaces);
    }

    public WorkspacePickerPage(ComponentConfigurationPickerWizard.ConfigurationPickerInput componentConfigurationPickerInput, ITeamRepository repository, IWorkspaceHandle toIgnore, WORKSPACES_OR_STREAMS showWorkpaces) {
        super("fromWorkspace1", Messages.AddComponentFromWorkspacePage1_title, null);
        this.repository = repository;
        this.toIgnore = toIgnore;
        this.showWorkpaces = showWorkpaces;
        this.componentConfigurationPickerInput = componentConfigurationPickerInput;
        this.setDescription(Messages.AddComponentFromWorkspacePage1_description);
        this.display = Display.getCurrent();
    }

    public void setDesiredComponent(ItemId<IComponent> component) {
        this.desiredComponent = component;
    }

    protected void createBody(Composite composite) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        StatusCollectorAdapter statusCollector = new StatusCollectorAdapter(){

            public void reportProblem(IStatus status) {
                switch (status.getSeverity()) {
                    case 0: {
                        WorkspacePickerPage.this.setMessage(null);
                        break;
                    }
                    case 1: 
                    case 2: {
                        WorkspacePickerPage.this.errorInPicker = false;
                        break;
                    }
                    case 4: {
                        WorkspacePickerPage.this.errorInPicker = true;
                        WorkspacePickerPage.this.setMessage(status.getMessage(), 3);
                    }
                }
            }
        };
        IPartResult<AbstractPlaceWrapper[]> doubleClickHandler = new IPartResult<AbstractPlaceWrapper[]>(){

            public void setResult(AbstractPlaceWrapper[] result) {
                if (result.length > 0) {
                    WorkspacePickerPage.this.defaultSelection = result[0];
                    WorkspacePickerPage.this.processDoubleClick();
                }
            }
        };
        IFilter filter = null;
        if (this.toIgnore != null) {
            filter = new IFilter(){

                public boolean select(Object toTest) {
                    if (toTest instanceof AbstractPlaceWrapper) {
                        AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)toTest);
                        return !WorkspacePickerPage.this.toIgnore.sameItemId((IItemHandle)wrapper.getWorkspace());
                    }
                    return true;
                }
            };
        }
        this.selectionPart = new WorkspaceAndStreamSelectionPart(composite, this.repository, null, false, null, this.showWorkpaces, true, null, filter, (IStatusCollector)statusCollector, doubleClickHandler, false);
        this.selectionPart.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkspacePickerPage.this.updateSelection();
            }
        });
        if (this.componentConfigurationPickerInput.isHierarchyAware() && this.componentConfigurationPickerInput.isReplaceComponent()) {
            WidgetToolkit toolkit = WidgetToolkit.createSwtToolkit();
            this.replaceSubcomponentsButton = toolkit.createButton(composite, Messages.WorkspacePickerPage_REPLACE_SUBCOMPONENTS_BUTTON_LABEL, 32);
            final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            this.replaceSubcomponentsButton.setSelection(store.getBoolean("com.ibm.team.filesystem.ide.ui.replace_component_from_workspace_with_hierarchy"));
            this.replaceSubcomponents = this.replaceSubcomponentsButton.getSelection();
            this.replaceSubcomponentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkspacePickerPage.this.replaceSubcomponents = WorkspacePickerPage.this.replaceSubcomponentsButton.isEnabled() && WorkspacePickerPage.this.replaceSubcomponentsButton.getSelection();
                    store.setValue("com.ibm.team.filesystem.ide.ui.replace_component_from_workspace_with_hierarchy", WorkspacePickerPage.this.replaceSubcomponentsButton.getSelection());
                }
            });
            GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, false).applyTo((Control)this.replaceSubcomponentsButton);
        }
        this.setPageComplete(false);
    }

    protected void processDoubleClick() {
        if (this.defaultSelection == this.actualSelection && this.actualSelection != null) {
            AdvanceableWizard.advance(this.getWizard());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSelection(AbstractPlaceWrapper sel) {
        if (this.desiredComponent.isNull()) {
            this.setActualSelection(sel);
            return;
        }
        WorkspacePickerPage workspacePickerPage = this;
        synchronized (workspacePickerPage) {
            if (this.pendingSelection == sel) {
                return;
            }
            this.pendingSelection = sel;
            this.actualSelection = null;
            this.statusJob.cancel();
        }
        if (sel == null) {
            this.setSelectionMessage(null);
            this.setPageComplete(false);
        } else {
            this.setSelectionMessage(Messages.AddComponentFromWorkspacePage1_pending);
            this.setPageComplete(false);
            this.statusJob.schedule();
        }
    }

    private void setSelectionMessage(String message) {
        if (!this.errorInPicker) {
            this.setMessage(message);
        }
    }

    private void setActualSelection(AbstractPlaceWrapper toValidate) {
        if (this.actualSelection == toValidate) {
            return;
        }
        this.actualSelection = toValidate;
        this.setPageComplete(this.actualSelection != null);
    }

    public AbstractPlaceWrapper getWorkspace() {
        return this.actualSelection;
    }

    private void updateSelection() {
        AbstractPlaceWrapper[] selection = this.selectionPart.getItems();
        AbstractPlaceWrapper sel = null;
        if (selection.length > 0) {
            sel = selection[0];
        }
        this.processSelection(sel);
    }

    public ComponentConfigurationPickerWizard.ConfigurationPickerInput getComponentConfigurationPickerInput() {
        return this.componentConfigurationPickerInput;
    }

    public boolean replaceSubcomponents() {
        return this.replaceSubcomponents;
    }
}

