/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.ui.queries.StreamSnapshotsQuery;
import com.ibm.team.filesystem.ui.views.TeamViewSorter;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.scm.common.IBaselineSetHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SnapshotPickerPage
extends BaseWizardPage {
    private IOperationRunner runner;
    private SimpleTableViewer viewer;
    private AbstractPlaceWrapper workspace;
    private String namePattern = "";
    private Runnable timerRunnable;
    private boolean allowMultiSelect;
    private List<SnapshotWrapper> snapshots = new ArrayList<SnapshotWrapper>();
    private List<? extends IBaselineSetHandle> toIgnore;

    public SnapshotPickerPage(IOperationRunner runner) {
        this(runner, false);
    }

    public SnapshotPickerPage(IOperationRunner runner, boolean allowMultiSelect) {
        super("fromSnapshot1", Messages.AddComponentsFromSnapshotPage1_title, null);
        this.runner = runner;
        this.allowMultiSelect = allowMultiSelect;
        this.setPageComplete(false);
    }

    public void setWorkspace(AbstractPlaceWrapper workspace) {
        if (NullUtil.equals((Object)((Object)this.workspace), (Object)((Object)workspace))) {
            return;
        }
        this.workspace = workspace;
    }

    protected void createBody(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.CompareWithSnapshotWizard_SearchSnapshotLabel);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final Text namePatternText = new Text(parent, 384);
        namePatternText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        namePatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SnapshotPickerPage.this.timerRunnable == null) {
                    SnapshotPickerPage.this.timerRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!namePatternText.isDisposed()) {
                                if (namePatternText.getText().isEmpty()) {
                                    SnapshotPickerPage.this.viewer.setInput(null);
                                } else if (!SnapshotPickerPage.this.namePattern.equalsIgnoreCase(namePatternText.getText())) {
                                    SnapshotPickerPage.this.namePattern = namePatternText.getText();
                                    SnapshotPickerPage.this.updateViewerInput();
                                }
                            }
                        }
                    };
                }
                namePatternText.getDisplay().timerExec(500, SnapshotPickerPage.this.timerRunnable);
            }
        });
        int style = 0x10B00 | (this.allowMultiSelect ? 2 : 4);
        Table table = new Table(parent, style);
        table.setHeaderVisible(false);
        this.viewer = new SimpleTableViewer(table, null, null);
        new LabelColumn(this.viewer, Messages.AddComponentsFromSnapshotPage1_snapshotsColumnHeading, -1).setComparator(TeamViewSorter.getSnapComparator());
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SnapshotPickerPage.this.onSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.viewer.setDoubleClickHandler(new IRunnableWithSelection(){

            public void run(Object selectedObject, Shell targetShell) {
                if (!SnapshotPickerPage.this.snapshots.isEmpty()) {
                    AdvanceableWizard.advance(SnapshotPickerPage.this.getWizard());
                }
            }
        });
        this.onSelectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    private void updateViewerInput() {
        if (this.workspace == null || this.viewer == null) {
            return;
        }
        StreamSnapshotsQuery query = new StreamSnapshotsQuery(this.workspace.getRepository(), this.workspace.getWorkspace(), this.namePattern, this.toIgnore, this.runner);
        this.viewer.setInput((ISetWithListeners)query);
    }

    private void onSelectionChanged(IStructuredSelection selection) {
        this.snapshots = new ArrayList<SnapshotWrapper>();
        boolean onlySnapshotsSelected = true;
        for (Object obj : selection.toList()) {
            if (obj instanceof SnapshotWrapper) {
                this.snapshots.add((SnapshotWrapper)((Object)obj));
                continue;
            }
            onlySnapshotsSelected = false;
            break;
        }
        this.setPageComplete(!this.snapshots.isEmpty() && onlySnapshotsSelected);
    }

    public SnapshotId getSnapshotId() {
        SnapshotWrapper snapshot = this.snapshots.get(0);
        if (snapshot == null) {
            return SnapshotId.createEmptyId((ITeamRepository)this.workspace.getRepository());
        }
        return BaselineSetId.create((ITeamRepository)snapshot.getRepository(), (IBaselineSetHandle)snapshot.getSnapshot());
    }

    public List<SnapshotId> getSnapshotIds() {
        ArrayList<SnapshotId> snapshotIds = new ArrayList<SnapshotId>();
        for (SnapshotWrapper snapshot : this.snapshots) {
            if (snapshot == null) {
                snapshotIds.add(SnapshotId.createEmptyId((ITeamRepository)this.workspace.getRepository()));
                continue;
            }
            snapshotIds.add((SnapshotId)BaselineSetId.create((ITeamRepository)snapshot.getRepository(), (IBaselineSetHandle)snapshot.getSnapshot()));
        }
        return snapshotIds;
    }

    public SnapshotWrapper getSnapshot() {
        return this.snapshots.get(0);
    }

    public List<SnapshotWrapper> getSnapshots() {
        return this.snapshots;
    }

    public void setToIgnore(List<? extends IBaselineSetHandle> toIgnore) {
        this.toIgnore = toIgnore;
    }
}

