/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.component.SnapshotPickerPage;
import com.ibm.team.internal.filesystem.ui.wizards.component.WorkspacePickerPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.common.IBaselineSetHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SelectSnapshotWizard
extends Wizard {
    private WorkspacePickerPage fromSnapshotPage1;
    private SnapshotPickerPage fromSnapshotPage2;
    private final ITeamRepository repository;
    private final JobRunner rq = new JobRunner(false);
    private List<SnapshotWrapper> snapshots = new ArrayList<SnapshotWrapper>();
    private List<? extends IBaselineSetHandle> toIgnore;
    private String snapshotSelectionPageDescription;
    private boolean allowMultiSelect;

    public SelectSnapshotWizard(ITeamRepository repo) {
        this(repo, null, null, false);
    }

    public SelectSnapshotWizard(ITeamRepository repo, List<? extends IBaselineSetHandle> toIgnore, String snapshotSelectionPageDescription, boolean allowMultiSelect) {
        this.repository = repo;
        this.toIgnore = toIgnore;
        this.snapshotSelectionPageDescription = snapshotSelectionPageDescription;
        this.allowMultiSelect = allowMultiSelect;
        String windowTitle = allowMultiSelect ? Messages.SelectSnapshotWizard_WizardTitleWithMultiSelect : Messages.SelectSnapshotWizard_WizardTitle;
        this.setWindowTitle(windowTitle);
    }

    public void addPages() {
        this.fromSnapshotPage1 = new WorkspacePickerPage(this.repository, null, WORKSPACES_OR_STREAMS.BOTH);
        this.fromSnapshotPage1.setDescription(Messages.SelectSnapshotWizard_selectWorkspacePageDescription);
        this.addPage((IWizardPage)this.fromSnapshotPage1);
        this.fromSnapshotPage2 = new SnapshotPickerPage((IOperationRunner)this.rq, this.allowMultiSelect);
        this.fromSnapshotPage2.setDescription(this.snapshotSelectionPageDescription != null ? this.snapshotSelectionPageDescription : Messages.SelectSnapshotWizard_selectSnapshotPageDescription);
        if (this.toIgnore != null) {
            this.fromSnapshotPage2.setToIgnore(this.toIgnore);
        }
        this.addPage((IWizardPage)this.fromSnapshotPage2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.filesystem.ide.ui.wizard_selectsnapshot");
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fromSnapshotPage1) {
            this.fromSnapshotPage2.setWorkspace(this.fromSnapshotPage1.getWorkspace());
            return this.fromSnapshotPage2;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        this.snapshots = this.fromSnapshotPage2.getSnapshots();
        return true;
    }

    public SnapshotWrapper getSnapshot() {
        return this.snapshots != null ? this.snapshots.get(0) : null;
    }

    public List<SnapshotWrapper> getSnapshots() {
        return this.snapshots;
    }
}

