/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.WorkspacePickerPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SelectComponentWizard
extends AdvanceableWizard {
    private final ComponentConfigurationPickerWizard.ConfigurationPickerInput fConfigurationPickerInput;
    private final ITeamRepository fRepository;
    private final IWorkspaceHandle fWorkspace;
    private final ComponentWrapper fFilterComponent;
    private final String fDescription;
    private WorkspacePickerPage fWorkspacePickerPage;
    private WorkspaceNamespace fWorkspaceNamespace;
    private boolean fIsReplaceWithHierarchy = false;

    public SelectComponentWizard(ComponentConfigurationPickerWizard.ConfigurationPickerInput configurationPickerInput, ITeamRepository repository, IWorkspaceHandle workspace, ComponentWrapper filterComponent, String title, String description) {
        if (configurationPickerInput == null) {
            throw new IllegalArgumentException("'configurationPickerInput' must not be null");
        }
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (filterComponent == null) {
            throw new IllegalArgumentException("'filterComponent' must not be null");
        }
        this.fConfigurationPickerInput = configurationPickerInput;
        this.fRepository = repository;
        this.fWorkspace = workspace;
        this.fFilterComponent = filterComponent;
        this.setWindowTitle(title);
        this.fDescription = description;
    }

    public void addPages() {
        this.fWorkspacePickerPage = new WorkspacePickerPage(this.fConfigurationPickerInput, this.fRepository, this.fWorkspace, WORKSPACES_OR_STREAMS.STREAMS);
        this.fWorkspacePickerPage.setDescription(this.fDescription);
        this.addPage((IWizardPage)this.fWorkspacePickerPage);
        this.fWorkspacePickerPage.setDesiredComponent((ItemId<IComponent>)new ItemId((IItemHandle)this.fFilterComponent.getComponent()));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.filesystem.ide.ui.wizard_selectcomponentfromworkspaceorstream");
    }

    public boolean performFinish() {
        AbstractPlaceWrapper workspaceWrapper = this.fWorkspacePickerPage.getWorkspace();
        if (workspaceWrapper != null) {
            ITeamRepository repo = workspaceWrapper.getRepository();
            IWorkspace workspace = workspaceWrapper.getWorkspace();
            IComponent component = this.fFilterComponent.getComponent();
            this.fWorkspaceNamespace = WorkspaceNamespace.create((ITeamRepository)repo, (UUID)workspace.getItemId(), (UUID)component.getItemId());
        }
        this.fIsReplaceWithHierarchy = this.fWorkspacePickerPage.replaceSubcomponents();
        return true;
    }

    public WorkspaceNamespace getResult() {
        return this.fWorkspaceNamespace;
    }

    public boolean isReplaceWithHierarchy() {
        return this.fIsReplaceWithHierarchy;
    }
}

