/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.AbstractSearchAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.SearchForComponentsAction;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentWrapperComparator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.query.PagedTable;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.internal.layout.LayoutUtil;

public class SelectComponentPage
extends BaseWizardPage {
    private IOperationRunner runner;
    private Label filterLabel;
    private Button clearFilterButton;
    private PagedTable<ComponentWrapper> pt;
    private ComponentSearchCriteria searchCriteria;

    public SelectComponentPage(ITeamRepository repository) {
        super(SelectComponentPage.class.getName(), Messages.SelectComponentPage_pageTitle, null);
        this.searchCriteria = new ComponentSearchCriteria(repository);
    }

    protected void createBody(Composite parent) {
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        WidgetToolkit toolkit = context.getToolkit();
        MnemonicGenerator generator = context.getMnemonics();
        Composite mainControl = parent;
        this.runner = context.getBackgroundOperationRunner();
        this.filterLabel = toolkit.createLabel(mainControl, "", 64);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).grab(true, false).applyTo((Control)this.filterLabel);
        this.clearFilterButton = toolkit.createButton(mainControl, generator.generate(Messages.BaselineSelectionPart_clearFilterButton), 8);
        this.clearFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectComponentPage.this.clearFilter();
                super.widgetSelected(e);
            }
        });
        Button filterButton = toolkit.createButton(mainControl, generator.generate(Messages.BaselineSelectionPart_filterButton), 8);
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectComponentPage.this.changeFilter();
                super.widgetSelected(e);
            }
        });
        this.pt = new PagedTable(mainControl, context, 2816, null, null);
        SimpleTableViewer viewer = this.pt.getViewer();
        Table table = viewer.getTable();
        table.setHeaderVisible(false);
        table.setFont(parent.getFont());
        new LabelColumn(viewer, "", -1).setComparator((Comparator)new ComponentWrapperComparator());
        this.pt.getViewer().getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectComponentPage.this.updateFinished();
            }
        });
        this.pt.getViewer().setDoubleClickHandler(new IRunnableWithSelection(){

            public void run(Object selectedObject, Shell targetShell) {
                WizardUtil.advance((IWizard)SelectComponentPage.this.getWizard());
            }
        });
        GridDataFactory.fillDefaults().hint(300, 300).grab(true, true).span(3, 1).applyTo(this.pt.getControl());
        GridLayoutFactory.fillDefaults().numColumns(3).generateLayout(mainControl);
        this.updateInput();
    }

    protected void updateFinished() {
        this.setPageComplete(!this.pt.getViewer().getSelection().isEmpty());
    }

    private void updateInput() {
        ISetWithListeners<ComponentWrapper> query = this.searchCriteria.getQuery(this.runner, false);
        this.clearFilterButton.setEnabled(!this.searchCriteria.isAllComponents());
        final ComponentSearchCriteria criteria = this.searchCriteria;
        final Display display = Display.getCurrent();
        this.runner.enqueue(Messages.BaselineSelectionPart_computingFilterProgress, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                final String filterName = criteria.getSearchName(monitor);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SelectComponentPage.this.filterLabel.isDisposed()) {
                            return;
                        }
                        SelectComponentPage.this.filterLabel.setText(filterName);
                        LayoutUtil.resize((Control)SelectComponentPage.this.filterLabel);
                    }
                });
            }
        });
        LayoutUtil.resize((Control)this.filterLabel);
        this.pt.setInput(query);
        this.updateFinished();
    }

    protected void changeFilter() {
        boolean lockRepository = !UiPlugin.isDistributedUI();
        ComponentSearchCriteriaPart.Input componentSearchCriteriaPartInput = new ComponentSearchCriteriaPart.Input(this.searchCriteria.getRepository(), lockRepository, this.searchCriteria.getStartsWith(), this.searchCriteria.getOwnedBy());
        AbstractSearchAction.promptAndSearch(this.getShell(), SearchForComponentsAction.ARGS, componentSearchCriteriaPartInput, new IPartResult<ComponentSearchCriteria>(){

            public void setResult(ComponentSearchCriteria result) {
                SelectComponentPage.this.searchCriteria = result;
                SelectComponentPage.this.updateInput();
            }
        });
    }

    protected void clearFilter() {
        this.searchCriteria = new ComponentSearchCriteria(this.searchCriteria.getRepository());
        this.updateInput();
    }

    public ItemId<IComponent> getSelection() {
        IStructuredSelection ss = this.pt.getViewer().getSelection();
        if (ss.isEmpty()) {
            return ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        }
        return ItemId.forItem((IItem)((ComponentWrapper)((Object)ss.getFirstElement())).getComponent());
    }

    public ITeamRepository getSelectionRepo() {
        IStructuredSelection ss = this.pt.getViewer().getSelection();
        if (ss.isEmpty()) {
            return this.searchCriteria.getRepository();
        }
        return ((ComponentWrapper)((Object)ss.getFirstElement())).getRepository();
    }
}

