/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.WrapperUtil;
import com.ibm.team.internal.filesystem.ui.wizards.component.BaselineHierarchyPage;
import com.ibm.team.internal.filesystem.ui.wizards.component.BaselineSelectionPage;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentSelectionPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.wizards.PageChain;
import com.ibm.team.repository.rcp.ui.wizards.PageChainSite;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

public class PickBaselineChain
extends PageChain {
    private ComponentConfigurationPickerWizard.ConfigurationPickerInput baselinePickerInput;
    private ITeamRepository repo;
    private IWorkspaceHandle workspace1;
    private IWorkspaceHandle workspace2;
    private IComponentHandle component;
    private ComponentSelectionPage selectComponentPage;
    private BaselineSelectionPage baselinePage;
    private String baselinePageDescription = Messages.PickBaselineChain_pickBaselinePageDescription;
    private BaselineHierarchyPage baselineHierarchyPage;
    boolean showBaselineHierarchyPage = false;
    private String baselineHierarchyPageDescription = Messages.BaselineHierarchyPage_PageDescription;

    public PickBaselineChain(ComponentConfigurationPickerWizard.ConfigurationPickerInput baselinePickerInput, ITeamRepository repo, IWorkspaceHandle workspace1, IWorkspaceHandle workspace2, IComponentHandle component) {
        this.baselinePickerInput = baselinePickerInput;
        this.repo = repo;
        this.workspace1 = workspace1;
        this.workspace2 = workspace2;
        this.component = component;
        if (baselinePickerInput.isHierarchyAware() && (baselinePickerInput.isAddComponent() || baselinePickerInput.isReplaceComponent())) {
            this.showBaselineHierarchyPage = true;
        }
    }

    public void setBaselinePageDescription(String baselinePageDescription) {
        this.baselinePageDescription = baselinePageDescription;
    }

    public void showBaselineHierarchyPage(boolean showBaselineHierarchyPage) {
        this.showBaselineHierarchyPage = showBaselineHierarchyPage;
    }

    public void setBaselineHierarchyPageDescription(String baselinePageDescription) {
        this.baselinePageDescription = baselinePageDescription;
    }

    public void init(PageChainSite site) {
        super.init(site);
        if (this.component == null) {
            this.selectComponentPage = new ComponentSelectionPage(this.repo);
            this.selectComponentPage.setDescription(Messages.PickBaselineChain_selectComponentPageDescription);
            site.addPage((IWizardPage)this.selectComponentPage);
        }
        this.baselinePage = new BaselineSelectionPage(this.baselinePickerInput);
        this.baselinePage.setDescription(this.baselinePageDescription);
        site.addPage((IWizardPage)this.baselinePage);
        if (this.showBaselineHierarchyPage) {
            this.baselineHierarchyPage = new BaselineHierarchyPage(this.baselinePickerInput, this.baselinePage.getBaseline());
            this.baselineHierarchyPage.setDescription(this.baselineHierarchyPageDescription);
            this.baselinePage.addBaselineSelectionChangeListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection;
                    BaselineWrapper selectedBaseline = null;
                    if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1 && selection.getFirstElement() instanceof BaselineWrapper) {
                        selectedBaseline = (BaselineWrapper)selection.getFirstElement();
                    }
                    PickBaselineChain.this.baselineHierarchyPage.setBaseline(selectedBaseline);
                }
            });
            this.baselinePage.addTraverseBaselineHierarchyButtonSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof Button) {
                        Button button = (Button)e.widget;
                        PickBaselineChain.this.baselineHierarchyPage.setTraverseBaselineHierarchy(button.getSelection());
                    }
                }
            });
            this.baselineHierarchyPage.addTraverseBaselineHierarchyButtonSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof Button) {
                        IWizardContainer container;
                        IWizard wizard;
                        Button button = (Button)e.widget;
                        boolean isSelected = button.getSelection();
                        PickBaselineChain.this.baselinePage.setTraverseBaselineHierarchy(isSelected);
                        PickBaselineChain.this.baselinePage.getWizard().getContainer().showPage((IWizardPage)PickBaselineChain.this.baselinePage);
                        if (!isSelected && (wizard = PickBaselineChain.this.baselinePage.getWizard()) != null && (container = wizard.getContainer()) != null) {
                            container.showPage((IWizardPage)PickBaselineChain.this.baselinePage);
                        }
                    }
                }
            });
            site.addPage((IWizardPage)this.baselineHierarchyPage);
        }
    }

    public List<IWizardPage> getPageOrder() {
        ArrayList<IWizardPage> result = new ArrayList<IWizardPage>();
        IComponentHandle selectedComponent = this.component;
        ITeamRepository contextRepo = this.repo;
        if (this.selectComponentPage != null) {
            result.add((IWizardPage)this.selectComponentPage);
            selectedComponent = this.selectComponentPage.getSelection();
            if (!this.repo.equals(this.selectComponentPage.getRepository())) {
                this.repo = contextRepo = this.selectComponentPage.getRepository();
            }
        }
        if (selectedComponent != null) {
            this.baselinePage.setContext(contextRepo, selectedComponent, this.workspace1, this.workspace2);
            result.add((IWizardPage)this.baselinePage);
            if (this.showBaselineHierarchyPage) {
                this.baselineHierarchyPage.setBaseline(this.baselinePage.getBaseline());
                if (this.baselinePage.traverseBaselineHierarchy()) {
                    result.add((IWizardPage)this.baselineHierarchyPage);
                }
            }
        }
        return result;
    }

    public BaselineNamespace getBaseline() {
        ItemNamespace namespace = WrapperUtil.getNamespaceFor(this.baselinePage.getBaseline());
        if (namespace instanceof BaselineNamespace) {
            return (BaselineNamespace)namespace;
        }
        return null;
    }

    public boolean traverseBaselineHierarchy() {
        return this.baselinePage.traverseBaselineHierarchy();
    }
}

