/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.AbstractSearchAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.SearchForComponentsAction;
import com.ibm.team.filesystem.ui.ComponentSelector;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteriaPart;
import com.ibm.team.jface.internal.IElementSelectorStatusListener;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ComponentSelectionPart {
    private ITeamRepository repo;
    private final boolean fMultipleSelection;
    private ComponentSelector viewer;
    private Text filter;
    private Label filterLabel;
    private Runnable timerRunnable;
    private ComponentSearchCriteria searchCriteria;
    private IOperationRunner runner;
    private Composite filterComposite;
    private IStatusCollector statusCollector;
    private boolean lockRepository = !UiPlugin.isDistributedUI();

    protected ComponentSelectionPart(ITeamRepository repo, Composite parent, boolean multi, IOperationRunner runner, IStatusCollector statusCollector) {
        this.repo = repo;
        this.fMultipleSelection = multi;
        this.runner = runner;
        this.statusCollector = statusCollector;
        this.createControls(parent);
    }

    private void createControls(Composite parent) {
        this.filterComposite = new Composite(parent, 0);
        Label label = new Label(this.filterComposite, 0);
        label.setText(Messages.ComponentSelectionPart_0);
        this.filter = new Text(this.filterComposite, 2048);
        this.filter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComponentSelectionPart.this.patternChanged((Text)e.widget);
            }
        });
        this.filter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ComponentSelectionPart.this.viewer.setFocus();
                }
            }
        });
        DialogUtil.setFocusControl(label, (Control)this.filter);
        this.filterLabel = new Label(this.filterComposite, 0);
        Composite viewerComposite = new Composite(parent, 0);
        int flags = 0xB00 | (this.fMultipleSelection ? 2 : 4);
        this.viewer = new ComponentSelector(this.repo, viewerComposite, flags, "");
        this.viewer.addStatusListener(new IElementSelectorStatusListener(){

            public void stopped() {
            }

            public void started(String message) {
            }

            public void reset() {
                ComponentSelectionPart.this.updateStatus(Status.OK_STATUS);
            }

            public void progress(String message, double actualWork, int totalWork) {
            }

            public void error(CoreException e) {
                ComponentSelectionPart.this.updateStatus(e.getStatus());
            }
        });
        this.viewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelectionPart.this.updateStatus(Status.OK_STATUS);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ComponentSelectionPart.this.filterLabel.getText();
            }
        });
        Composite buttonComposite = new Composite(viewerComposite, 0);
        Button filterButton = new Button(buttonComposite, 8);
        filterButton.setText(Messages.ComponentSelectionPart_Filter);
        this.searchCriteria = new ComponentSearchCriteria(this.repo);
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSearchCriteriaPart.Input componentSearchCriteriaPartInput = new ComponentSearchCriteriaPart.Input(ComponentSelectionPart.this.searchCriteria.getRepository(), ComponentSelectionPart.this.lockRepository, null, ComponentSelectionPart.this.searchCriteria.getOwnedBy());
                AbstractSearchAction.promptAndSearch(ComponentSelectionPart.this.filterComposite.getShell(), SearchForComponentsAction.ARGS, componentSearchCriteriaPartInput, new IPartResult<ComponentSearchCriteria>(){

                    public void setResult(ComponentSearchCriteria result) {
                        ComponentSelectionPart.this.searchCriteria = result;
                        ComponentSelectionPart.this.changeRepository(ComponentSelectionPart.this.searchCriteria.getRepository());
                        ComponentSelectionPart.this.filterOwner((IAuditableHandle)ComponentSelectionPart.this.searchCriteria.getOwnedBy().toHandle());
                        ComponentSelectionPart.this.updateFilterLabel();
                        ComponentSelectionPart.this.viewer.forceSearch();
                    }
                });
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(1).generateLayout(this.filterComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(viewerComposite);
        GridLayoutFactory.fillDefaults().generateLayout(buttonComposite);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)viewerComposite);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.filterComposite);
        this.updateFilterLabel();
    }

    private void updateFilterLabel() {
        final Display display = Display.getCurrent();
        this.runner.enqueue(Messages.BaselineSelectionPart_computingFilterProgress, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                final String filterName = ComponentSelectionPart.this.searchCriteria.getSearchName(monitor);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ComponentSelectionPart.this.filterLabel.isDisposed()) {
                            return;
                        }
                        ComponentSelectionPart.this.filterLabel.setText(filterName);
                    }
                });
            }
        });
    }

    public void setLockRepository(boolean lockRepository) {
        this.lockRepository = lockRepository || !UiPlugin.isDistributedUI();
    }

    public ComponentSelector.Entry[] getItems() {
        return this.viewer.getWrapperSelection();
    }

    private void patternChanged(final Text text) {
        if (this.timerRunnable == null) {
            this.timerRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!text.isDisposed()) {
                        ComponentSelectionPart.this.viewer.setSearchPattern(text.getText());
                    }
                }
            };
        }
        if (text.getText().length() == 0) {
            this.viewer.setSelection(null);
        }
        text.getDisplay().timerExec(500, this.timerRunnable);
    }

    private void updateStatus(IStatus status) {
        if (status.isOK()) {
            return;
        }
        this.statusCollector.reportProblem(status);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer.getSelectionProvider();
    }

    public void changeRepository(ITeamRepository repo) {
        if (this.repo.equals(repo)) {
            return;
        }
        this.repo = repo;
        this.viewer.setRepository(repo);
        this.patternChanged(this.filter);
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public void filterOwner(IAuditableHandle owner) {
        if (!(owner instanceof IContributorHandle) && !(owner instanceof IProcessAreaHandle) && owner != null) {
            throw new IllegalArgumentException(Messages.ComponentSelectionPart_filterOwnerIllegalArg);
        }
        this.viewer.filterOwner(owner);
    }

    public void addMouseSelectionListener(MouseListener listener) {
        this.viewer.getTable().addMouseListener(listener);
    }

    public void grabFocus() {
        this.filter.setFocus();
    }

    public void stopAllJobs() {
        if (this.viewer != null) {
            this.viewer.stop(true);
        }
    }
}

