/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.wizards.component;

import com.ibm.team.filesystem.ui.ComponentSelector;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentSelectionPart;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.StatusCollectorAdapter;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.repository.rcp.ui.wizards.ChainedWizard;
import com.ibm.team.scm.common.IComponent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;

public class ComponentSelectionPage
extends BaseWizardPage {
    private ITeamRepository repo;
    private boolean lockRepository = !UiPlugin.isDistributedUI();
    private ComponentSelectionPart selectionPart;
    private final boolean multiSelect;
    private ComponentSelector.Entry[] selectedItems = new ComponentSelector.Entry[0];
    IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            if (!ComponentSelectionPage.this.isCurrentPage()) {
                ComponentSelectionPage.this.stopAllJobs();
            }
        }
    };

    public ComponentSelectionPage(ITeamRepository repo) {
        this(repo, false);
    }

    public ComponentSelectionPage(ITeamRepository repo, boolean multi) {
        this(repo, !UiPlugin.isDistributedUI(), multi);
    }

    public ComponentSelectionPage(ITeamRepository repo, boolean lockRepository, boolean multi) {
        super(ComponentSelectionPage.class.getName(), Messages.SelectComponentPage_pageTitle, null);
        this.repo = repo;
        this.lockRepository = lockRepository || !UiPlugin.isDistributedUI();
        this.multiSelect = multi;
    }

    protected void createBody(Composite parent) {
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        IOperationRunner runner = context.getBackgroundOperationRunner();
        StatusCollectorAdapter statusCollector = new StatusCollectorAdapter(){

            public void reportProblem(IStatus toReport) {
                ComponentSelectionPage.this.setErrorMessage(toReport.getMessage());
            }
        };
        this.selectionPart = new ComponentSelectionPart(this.repo, parent, this.multiSelect, runner, (IStatusCollector)statusCollector);
        this.selectionPart.setLockRepository(this.lockRepository);
        this.selectionPart.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComponentSelectionPage.this.selectedItems = ComponentSelectionPage.this.selectionPart.getItems();
                ComponentSelectionPage.this.repo = ComponentSelectionPage.this.selectionPart.getRepository();
                ComponentSelectionPage.this.setPageComplete(ComponentSelectionPage.this.selectedItems.length > 0);
            }
        });
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AdvanceableWizard.advance(ComponentSelectionPage.this.getWizard());
            }
        };
        this.selectionPart.addMouseSelectionListener((MouseListener)listener);
        IWizardContainer wc = this.getContainer();
        if (this.getWizard() instanceof ChainedWizard) {
            ChainedWizard cw = (ChainedWizard)this.getWizard();
            wc = cw.getWrappedContainer();
        }
        if (wc instanceof IPageChangeProvider) {
            IPageChangeProvider pageChangeProvider = (IPageChangeProvider)wc;
            pageChangeProvider.addPageChangedListener(this.pageChangedListener);
        }
        GridLayoutFactory.fillDefaults().applyTo(parent);
    }

    public IComponent getSelection() {
        if (this.selectedItems.length > 0) {
            return this.selectedItems[0].getComponent();
        }
        return null;
    }

    public IComponent[] getMultiSelection() {
        IComponent[] result = new IComponent[this.selectedItems.length];
        int i = 0;
        while (i < this.selectedItems.length) {
            result[i] = this.selectedItems[i].getComponent();
            ++i;
        }
        return result;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public boolean isPageComplete() {
        return this.selectedItems.length > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.selectionPart != null) {
            this.selectionPart.grabFocus();
        }
    }

    public void dispose() {
        IWizardContainer wc = this.getContainer();
        if (this.getWizard() instanceof ChainedWizard) {
            ChainedWizard cw = (ChainedWizard)this.getWizard();
            wc = cw.getWrappedContainer();
        }
        if (wc instanceof IPageChangeProvider) {
            IPageChangeProvider pageChangeProvider = (IPageChangeProvider)wc;
            pageChangeProvider.removePageChangedListener(this.pageChangedListener);
        }
        this.stopAllJobs();
        super.dispose();
    }

    public void stopAllJobs() {
        if (this.selectionPart != null) {
            this.selectionPart.stopAllJobs();
        }
    }
}

